<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Auth;
use Session;
use App\ProductSubcategory;
use App\State;
use View;
use App\ProductComment;
use App\ProductMessage;
use App\Support;
use App\Product;
use Illuminate\Support\Facades\Validator;

class AjaxController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
    }

    public function getSubCategoryById(Request $request)
    {
        $id = $request->id;
        $subcategory_model = new ProductSubcategory;
        $data['result'] = $subcategory_model->subcategory_by_category_id($id);
        $view = View::make('creators.ajax.subcategory',$data);
        $content = $view->render();
        $response['content'] = $content;
        $response['status'] = true;
        echo json_encode($response);
    }

    public function getStataByCountry(Request $request)
    {
        $id = $request->id;
        $states_model = new State;
        $data['result'] = $states_model->states_by_country_id($id);
        $view = View::make('common.ajax.states',$data);
        $content = $view->render();
        $response['content'] = $content;
        $response['status'] = true;
        echo json_encode($response);
    }

    public function getCitiesByStateId(Request $request)
    {
        $id = $request->id;
        $states_model = new State;
        $data['result'] = $states_model->cities_by_state_id($id);
        $view = View::make('common.ajax.cities',$data);
        $content = $view->render();
        $response['content'] = $content;
        $response['status'] = true;
        echo json_encode($response);
    }

    public function isEmailExist(Request $request){
        $email = $request->email;
        $users=User::where('email',$email)->get()->toArray();
        if(count($users)>0){
            $response['status'] = true;
            $response['msg'] = "Email is already registered.";
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }

    public function isUsernameExist(Request $request){
        $username = $request->username;
        $users=User::where('username',$username)->get()->toArray();
        if(count($users)>0){
            $response['status'] = true;
            $response['msg'] = "User name is already used.";
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    
    public function isbarcodeExist(Request $request){
        $bar_code = $request->bar_code;
        $bar_codes=product::where('bar_code',$bar_code)->get()->toArray();
        if(count($bar_codes)>0){
            $response['status'] = true;
            $response['msg'] = "Barcode is already exist.";
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    
    public function getCommentDetailById(Request $request){
        $id = $request->id;
        $comment_model = new ProductComment;
        $comment = $comment_model->get_comment_details_by_comment_id($id);
        if(count($comment)>0){
            $created_at = date('D j M Y',strtotime($comment[0]->created_at));
            $comment[0]->created_at = $created_at;
            $response['status'] = true;
            $response['comment'] = $comment;
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }

    public function gtetMessageDetailsByMessageId(Request $request){
        $id = $request->id;
        $message_model = new ProductMessage;
        $message = $message_model->get_message_details_by_message_id($id);
        if(count($message)>0){
            $created_at = date('D j M Y',strtotime($message[0]->created_at));
            $message[0]->created_at = $created_at;
            $response['status'] = true;
            $response['message'] = $message;
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    public function get_support_details_by_support_id(Request $request){
        $id = $request->id;
        $support_model = new Support;;
        $message = $support_model->get_support_details_by_support_id($id);
        if(count($message)>0){
            $created_at = date('D j M Y',strtotime($message[0]->created_at));
            $message[0]->created_at = $created_at;
            $response['status'] = true;
            $response['message'] = $message;
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    public function search_gpages(Request $request){
        $search_key = trim($request->search_key);
        $search_page = trim($request->search_page);
        $product_model = new Product;
        $gpages = $product_model->search_gpages($search_key);
        $output = "";
        if($gpages){
            $response['status'] = true;
            foreach ($gpages as $key => $value) {
                $image = json_decode($value->image);
                $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
                /*$output.= '<li>
                  <a href="'.url('product/'.$url_name.'/about/'.$value->id).'" target="_blank">
                  <img src="'.asset($image[0]->url).'" alt="Avatar" class="img-circle pull-left avatar" width="100px;" height="30px;">
                  <span class="title">'.$value->name.'</span>
                  </a>
                </li>';*/
                if($search_page == 'yes'){
                    $view = View::make('common.ajax.search_result', compact('gpages'));
                    $output = $view->render();
                }else{
                    $output.= '<li>
                 <a href="'.url('search/gpages?search_key=').$search_key.'" target="_blank">
                  <img src="'.asset($image[0]->url).'" alt="Avatar" class="img-circle pull-left avatar" width="100px;" height="30px;">
                  <span class="title">'.$value->name.'</span>
                  </a>
                </li>';
                }
            }
            $response['result'] = $gpages;
            $response['output'] = $output;
            $response['msg'] = "Data found";
        }else{
            $response['status'] = false;
            $response['msg'] = "Data not found";
        }
        echo json_encode($response);
    }
    public function resolved_support_message(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('support')->where('serial_number', '=', $id)->update(['status'=>1,'created_at'=>date('Y-m-d H:i:s')])){
                $response['status'] = true;
                $response['msg'] = "Support message status has been updated as resolved!";
                Session::flash('success', 'Support message status has been updated as resolved!');
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid chat id !";
        }
        echo json_encode($response);
    }

    public function postSaveDraft(Request $request){

        $rules  = array(
            'bar_code'=>  'numeric|max:12',
            //'bar_code'=>  'required',
//            'category' =>  'required',
//            'sub_category'       =>  'required',
//            'name' => 'required',
            //'summary' =>  'required',
            //'title'     => 'required',
//            'manufacture'   =>  'required',
            //'manufacture_port_no' => 'required',
            //'msr_price'   =>  'required',
            //'price' => 'required',
//            'made_in' => 'required',
            //'mnf_summary'   => 'required',
            //'color'   => 'required',
            //'weight' => 'required',
            //'unit_price'   =>  'required',
            //'dimenstions'   =>  'required',
            //'dimenstions_length'   =>  'required',
            //'dimenstions_width'   =>  'required',
            //'dimenstions_height'   =>  'required',
            //'dimenstions_girth'   =>  'required',
            //'features'   =>  'required',
            //'spect'   =>  'required',
            //'how_to_use_text'   =>  'required',
            //'how_to_use_video'   =>  'required',
            //'online_url'   =>  'required',
            //'product_web_url'   =>  'required',
            //'mnf_url'   =>  'required',
            //'age_resticted'     => 'required',
        );
        #check validation
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
            $response['status'] = false;
            $response['msg'] = "Please Complete Required Fields";
            echo json_encode($response);
            return;
        }
        #prepare dimention field
        $dimenstion = array(
            'type' => $request->dimenstions,
            'height' => $request->dimenstions_height,
            'width' => $request->dimenstions_width,
            'length'  => $request->dimenstions_length,
            'grith' => $request->dimenstions_girth,
        );
        #prepare buy online url
        //print_r($new_online_url );exit;
        #prepare product table field
        $product_param  = array(
            'user_id' => Auth::user()->id,
            'bar_code'  =>  $request->bar_code,
            'category_id'  =>  $request->category,
            'subcategory_id'  =>  $request->sub_category,
            'name'  =>  $request->name,
            'title'  =>  $request->title,
            //'description'  =>  $request->summary,
            'image' =>  $request->upload_img,
            'video' =>  $request->upload_video,
            'manufactured_by'  =>  $request->manufacture,
            'msr_price'  =>  $request->msr_price,
            //'price' => $request->price,
            'currency' => $request->currency,
            'made_in' => $request->made_in,
            'mnf_summary'   => $request->mnf_summary,
            'manufactured_port_no'  =>  $request->manufacture_port_no,
            'color_to_show'  =>  json_encode($request->color),
            'unit_price'  =>  $request->unit_price,
            'weight'  =>  $request->weight,
            'dimension'  =>  json_encode($dimenstion),
            'status'  =>  1,
        );

        $id = DB::table('product')->insertGetId($product_param);
        $response['status'] = true;
        $response['id'] = $id;
        $response['msg'] = "Saved on the Draft";
        echo json_encode($response);

    }
    
    //Update product info
    public function edit_product(Request $request)
    {
        $steps = $request->steps;
        $id = $request->id;
        $pr = Product::find($id);
        if ($pr != null) {
            if ($pr->user_id != Auth::user()->id) {
                return redirect(url('creator/dashboard'));
                $response['status'] = false;
                $response['msg'] = "Please Complete Required Fields";
                echo json_encode($response);
                return;
            }
        }
        $product_model = new Product;
        if ($steps == 1) {

            $rules = array(
            'bar_code'=>  'nullable|numeric|min:99999999|max:9999999999999',
            'category' => 'required',
            'sub_category' => 'required',
            );

            #check validation
            $validator = Validator::make($request->all(),$rules);
            if($validator->fails()){
                $response['status'] = false;
                $response['msg'] = "Please Complete Required Fields";
                echo json_encode($response);
                return;
            }

            $product_param = array(
                'bar_code' => $request->bar_code,
                'category_id' => $request->category,
                'subcategory_id' => $request->sub_category,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );

        } else if ($steps == 2) {

            $rules = array(
            'name' => 'required',
            );

            #check validation
            $validator = Validator::make($request->all(),$rules);
            if($validator->fails()){
                $response['status'] = false;
                $response['msg'] = "Please Complete Required Fields";
                echo json_encode($response);
                return;
            }

            $product_param = array(
                'name' => $request->name,
                'title' => $request->title,
                'description' => $request->summary,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        } else if ($steps == 3) {
            $rules = [
            'manufacture' => 'required',
            'msr_price'   =>  'nullable|numeric',
            'made_in' => 'required',
            'weight' => 'nullable|numeric|max:9999999999999',
            'height' => 'nullable|numeric|max:9999999999999',
            'width' => 'nullable|numeric|max:9999999999999',
            'length' => 'nullable|numeric|max:9999999999999',
            'grith' => 'nullable|numeric|max:9999999999999',
            ];

            
            if(!$request->msr_price == '' ){
                $rules = ['currency' => 'required'];
            }

            if(!$request->weight == '' ){
                $rules = ['unit_price' => 'required'];
            }

            if(!$request->dimenstions_height == '' || !$request->dimenstions_width == '' || !$request->dimenstions_length == '' || !$request->dimenstions_girth == '' ){
                $rules = ['type' => 'required'];
            }

            #check validation
            $validator = Validator::make($request->all(),$rules);
            if($validator->fails()){
                $response['status'] = false;
                $response['msg'] = "Please Complete Required Fields";
                echo json_encode($response);
                return;
            }

            $dimenstion = array(
                'type' => $request->dimenstions,
                'height' => $request->dimenstions_height,
                'width' => $request->dimenstions_width,
                'length' => $request->dimenstions_length,
                'grith' => $request->dimenstions_girth,
            );
            $product_param = array(
                'manufactured_by' => $request->manufacture,
                'made_in' => $request->made_in,
                'mnf_summary' => $request->mnf_summary,
                'msr_price' => $request->msr_price,
                //'price' => $request->price,
                'currency' => $request->currency,
                'manufactured_port_no' => $request->manufacture_port_no,
                'color_to_show' => json_encode($request->color),
                'unit_price' => $request->unit_price,
                'weight' => $request->weight,
                'dimension' => json_encode($dimenstion),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if ($steps == 4) {
            /*$type = $request->type;
            if($type == 'image'){
                $product_param = array(
                    'image' => $request->upload_img,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
            }
            if($type == 'video'){
                $product_param = array(
                    'image' => $request->upload_img,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
            }
            
            $response['msg2'] = 'SAVED '.$type;*/
            $product_param = array(
                'image' => $request->upload_img,
                'video' => $request->upload_video,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            
        }else if ($steps == 5) {
            $product_param = array(
                'features_feed' => $request->features,
                'spec_field' => $request->spect,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if ($steps == 6) {
            $product_param = array(
                'how_to_use_text' => $request->how_to_use_text,
                'how_to_use_video' => $request->how_to_use_video,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if ($steps == 7) {
            //parts data manipulation
            $parts_name = $request->parts_by_name;
            $parts_name_array = array();
            foreach ($parts_name as $key => $value) {
                if(!empty($value)){
                    $parts_name_array[] = $value;
                }
            }
            //partts gpage data manipulation
            $parts_gpage = $request->parts_by_gpage;
            $parts_gpage_array = array();
            foreach ($parts_gpage as $key => $value) {
                if(!empty($value)){
                   $parts_gpage_array[] = $value;
                }
            }
            //parts data insertion
            $parts_param = array(
                'gpage_id' => json_encode($parts_gpage_array),
                'parts_name' => json_encode($parts_name_array),
                'product_id' => $id,
                'type'  => 'p',
                'updated_at' => date("Y-m-d H:i:s")
            );
            $isPartsExist = DB::table('product_parts_accessories')->where(['product_id'=> $id,'type'=>'p'])->get();
            if($isPartsExist && count($isPartsExist)){
                DB::table('product_parts_accessories')->where(['product_id'=> $id,'type'=>'p'])->update($parts_param);
            }else{
                DB::table('product_parts_accessories')->insert($parts_param);
            }
            //accessories data manipulation
            $accessories_name = $request->accessories_by_name;
            $accessories_name_array = array();
            foreach ($accessories_name as $key => $value) {
                if(!empty($value)){
                   $accessories_name_array[] = $value;
                }
            }
            //accessories gpage data manipulation
            $accessories_gpage = $request->accessories_by_gpage;
            $accessories_gpage_array = array();
            foreach ($accessories_gpage as $key => $value) {
                if(!empty($value)){
                   $accessories_gpage_array[] = $value;
                }
            }
            //accessories data insertion
            $accessories_param = array(
                'gpage_id' => json_encode($accessories_gpage_array),
                'parts_name' => json_encode($accessories_name_array),
                'product_id' => $id,
                'type'  => 'a',
                'updated_at' => date("Y-m-d H:i:s")
            );
            $isAccessoriesExist = DB::table('product_parts_accessories')->where(['product_id'=> $id,'type'=>'a'])->get();
            if($isAccessoriesExist && count($isAccessoriesExist)){
                DB::table('product_parts_accessories')->where(['product_id'=> $id,'type'=>'a'])->update($accessories_param);
            }else{
                DB::table('product_parts_accessories')->insert($accessories_param);
            }
            $response['status'] = true;
            $response['msg'] = "Data has been updated.";
            return json_encode($response);
            exit;
        } else if ($steps == 8) {

            #prepare buy online url
            $new_online_url = array();
            $online_url = $request->online_url;
            $online_price = $request->online_price;
            if (!empty($online_url)) {
                foreach ($online_url as $key => $value) {
                    $temp_array = array(
                        'online_url' => $value,
                        'price' => $online_price[$key]
                    );
                    $new_online_url[] = $temp_array;
                }
            }
            $product_param = array(
                'buy_online_link' => json_encode($new_online_url),
                'web_page_link' => $request->product_web_url,
                'manufactured_web_page_link' => $request->mnf_url,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        } else if ($steps == 9) {
            $age_resticted =$request->age_resticted;
            
                    
            $age_restrictions = [1,2,3,4];
            
            if($request->to_be_age_resticted === '1' ){
                    
                $rules = array('age_resticted' => "required|in:". implode(',', $age_restrictions));
                
                #check validation
                $validator = Validator::make($request->all(),$rules);
                
                if($validator->fails()){
                    $response['status'] = 'false';
                    $response['msg'] = "Please select age";
                    $response['msg2'] = $age_resticted;
                    echo json_encode($response);
                    return;
                    }
            }
            
                    
            //dd('here');
            $product_param = array(
                'exclude_from_feed' => $request->exlcude_from_feed,
                'hide_price' => $request->hide_price,
                'register_to_view' => $request->register_to_view,
                'to_be_age_resticted' => $request->to_be_age_resticted,
                'age_restricted' => $request->age_resticted,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }
        //dd($product_param);
        if (DB::table('product')->where('id', $id)->update($product_param)) {
            #notification to admin
            $user_obj = User::find(Auth::user()->id);
            $user_model = new User;
            $details = [
                'from' => $user_obj->id,
                'to' => $user_model->get_admin_id(),
                'type' => 'Gpages status',
                'message' => 'Hi admin Gpages status updated by ' . $user_obj->name . '!',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ];
            //$user_obj->notify(new MyNotification($details));
            DB::table('notifications')->insert($details);
            $response['status'] = true;
            $response['msg'] = "Data has been updated.";


            //user activity log
            $gpages_name = $product_model->product_name_by_id($id);
            $activity_param = array(
                'user_id' => $user_obj->id,
                'activity' => $gpages_name . " gpage is updated!",
                'type' => 'Gpages updated',
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            DB::table('user_activity')->insert($activity_param);

            //Session::flash('updateproduct', $gpages_name . " gpage is updated!");
            $response['status'] = true;
            $response['msg'] = "Product data updated";
            echo json_encode($response);
            
        } else {
            $response['status'] = false;
            $response['msg'] = "Internal server error.";
            echo json_encode($response);
        }

    }
}
