<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use File;
use View;
use App\Product;
use File as MyFile;
use DB;

class FileUploadController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
        //$this->middleware('auth',['except' => array('/')]);
    }
    
    public function file_upload(Request $request)
    {
      if($request->hasFile('custom_name')) {
        $folder_name = $request->post('folder_name');
        $type = $request->post('type');
        $filenameWithExt = $request->file('custom_name')->getClientOriginalName();
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        $extension = $request->file('custom_name')->getClientOriginalExtension();
        $time = time();
        $fileNameToStore = $time.'.'.$extension;
        if($type == 'image'){
          $destinationFolder = "uploads/".$folder_name."/image";
        }else if($type == 'video'){
          $destinationFolder = "uploads/".$folder_name."/video";
        }else if($type == 'how_to_use'){
          $destinationFolder = "uploads/".$folder_name."/video";
        }else{
          $destinationFolder = "uploads/attachment";
        }
        $destinationPath = public_path($destinationFolder);
        if (!file_exists($destinationPath)) {
          File::makeDirectory($destinationPath, $mode = 0777, true, true);
        }
        $request->file('custom_name')->move($destinationPath, $fileNameToStore);
        //upddate product table
        $steps = $request->step;
        if($steps == 4 || $steps == 5){
          if($type == 'image' && $steps == 4){
            //create param for update product table
            $parent_array = array();
            $child_array = array(
              "name" => $fileNameToStore,
              "url" => $destinationFolder."/".$fileNameToStore,
              "id" => $time,
            );
            $product_img_array = json_decode($request->product_img_array);
            foreach ($product_img_array as $key => $value) {
              $temp = array(
                "name" => $value->name,
                "url" => $value->url,
                "id" => $value->id,
              );
              array_push($parent_array, $temp);
            }
            array_push($parent_array, $child_array);
            $product_param = array(
              'image' => json_encode($parent_array),
              'updated_at'=>date('Y-m-d H:i:s')
            );
          }elseif($type == 'video' && $steps == 4) {
            $parent_array = array();
            $child_array = array(
              "name" => $fileNameToStore,
              "url" => $destinationFolder."/".$fileNameToStore,
              "id" => $time,
            );
            $product_video_array = json_decode($request->product_video_array);
            foreach ($product_video_array as $key => $value) {
              $temp = array(
                "name" => $value->name,
                "url" => $value->url,
                "id" => $value->id,
              );
              array_push($parent_array, $temp);
            }
            array_push($parent_array, $child_array);
            $product_param = array(
              'video' => json_encode($parent_array),
              'updated_at'=>date('Y-m-d H:i:s')
            );
          }elseif($type == 'video' && $steps == 5) {
            $parent_array = array();
            $child_array = array(
              "name" => $fileNameToStore,
              "url" => $destinationFolder."/".$fileNameToStore,
              "id" => $time,
            );
            $product_video_array = json_decode($request->how_to_use_video_array);
            foreach ($product_video_array as $key => $value) {
              $temp = array(
                "name" => $value->name,
                "url" => $value->url,
                "id" => $value->id,
              );
              array_push($parent_array, $temp);
            }
            array_push($parent_array, $child_array);
            $product_param = array(
              'how_to_use_video' => json_encode($parent_array),
              'updated_at'=>date('Y-m-d H:i:s')
            );
          }
          if (DB::table('product')->where('id', $request->id)->update($product_param)){
          }else{
            $response['status'] = false;
            $response['msg'] = "Internal server error.";
            echo json_encode($response);
            return;
          }
        }
        $response['url'] =  $destinationFolder."/".$fileNameToStore;
        $response['status'] = true;
        $response['msg'] = 'File has been uploaded!';
        $response['name'] = $fileNameToStore;
        $response['id'] = $time;
        $response['type'] = $type;
        if($type == 'image'){
          $view = View::make('creators.ajax.image_div',$response);   
        }else{
          $view = View::make('creators.ajax.video_div',$response);   
        }
        $content = $view->render();
        $response['content'] = $content;
      }else{
        $response['status'] = false;
        $response['msg'] = 'File can not be empty!';
      }
      echo json_encode($response);
      exit;
    }

    public function deleteStorageFile(Request $request){
      $fileName = $request->fileName;
      $destinationPath = public_path($fileName);
      $product_id = $request->product_id;
      $fieldName = $request->fieldName;
      $fieldValue  = $request->fieldValue;
      if(myFile::exists($destinationPath)){
        myFile::Delete($destinationPath);
        $param = array();
        $response['status'] = true;
        $response['msg'] = 'File deleted successfully!';
      }else{
        $response['status'] = false;
        $response['msg'] = 'File does not exist!';
      }
      if(!empty($product_id) && !empty($fieldName) && !empty($fieldValue)){
        DB::table('product')->where('id',$product_id)->update([$fieldName => $fieldValue, 'updated_at' => date('Y-m-d H:i:s')]);
        $response['storege_deleted_from_db'] = 'yes';
      }else{
        $response['storege_deleted_from_db'] = 'no';
      }
      echo json_encode($response);
      exit;
    }
    /*public function file_upload_server(Request $request)
    {
        
        if($request->hasFile('custom_name')) {
              $folder_name = $request->post('folder_name');
              $type = $request->post('type');
              $filenameWithExt = $request->file('custom_name')->getClientOriginalName();
              $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
              $extension = $request->file('custom_name')->getClientOriginalExtension();//GET FILE TYPE
              $time = time();
              $fileNameToStore = $time.'.'.$extension;
              if($type == 'image'){
                  $validator = Validator::make($request->all(), [
                    "file" => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                  ]);
            
            
                  if($validator->fails()){
                    $response['status'] = false;
                    $response['msg'] = 'Wrong image type';
                    echo json_encode($response);
                    return;
                      
                  }else{
                    $destinationFolder = "uploads/".$folder_name."/image";
                  }
              }else if($type == 'video'){
                $destinationFolder = "uploads/".$folder_name."/video";
              }else{
                $destinationFolder = "uploads/attachment";
              }
              $destinationPath = public_path($destinationFolder);
                        //dd('here');
              if (!file_exists($destinationPath)) {
                File::makeDirectory($destinationPath, $mode = 0777, true, true);

                if ($steps == 4) {
                    $steps = $request->steps;
                    $id = $request->id;
                    $pr = Product::find($id);

                    if($type == 'image'){
                        $product_img_array = $request->product_img_array;
                        #prepare add new img
                        $new_img_arr = [
                            "name" => $fileNameToStore,
                            "url" => $destinationFolder,
                            "id" => $time,
                        ];
                        array_push($product_img_array,$new_img_arr);
                        $product_param = array(
                            'image' => $product_img_array,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        $response['new_imgs'] = $product_img_array;
                      }else if($type == 'video'){
                       $product_param = array(
                           'image' => $request->upload_img,
                           'created_at' => date("Y-m-d H:i:s"),
                           'updated_at' => date("Y-m-d H:i:s"),
                       );
                      }

                      if (DB::table('product')->where('id', $id)->update($product_param)) {
                                 
                                  
                          } else {
                              $response['status'] = false;
                              $response['msg'] = "Internal server error.";
                              echo json_encode($response);
                              return;
                          }
                }
                    
              }else{
              $response['status'] = false;
              $response['msg'] = 'File exist';
                echo json_encode($response);
                              return;
              }
              $response['url'] =  $destinationFolder."/".$fileNameToStore;
              $response['status'] = true;
              $response['msg'] = 'File has been uploaded!';
              $response['name'] = $fileNameToStore;
              $response['id'] = $time;
              $request->file('custom_name')->move($destinationPath, $fileNameToStore);
              if($type == 'image'){
                $view = View::make('creators.ajax.image_div',$response);   
              }else{
                $view = View::make('creators.ajax.video_div',$response);   
              }
              $content = $view->render();
              $response['content'] = $content;
        }else{
              $response['status'] = false;
              $response['msg'] = 'File can not be empty!';
        }
        echo json_encode($response);
        exit;
    }*/
    
}