<?php

namespace App\Http\Controllers;

use App\Product;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\DB;
use Hashids\Hashids;
use App\apps; ##to get app page data from database
use App\Post; ##to get post page data from database
use Mail;
use App\country; ##to get country  data from database

class MainController extends  BaseController
{

    public function index()
    {
        $hashids = new Hashids();
        $data = [
            'title' => 'Home',
            'meta_description' =>'A new platform is born',
            'hashids' => $hashids,
            'gpages' =>Product::orderBy('id', 'desc')->take(5)->get(),
        ];
        $product_model = new Product;
        $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
        return view('index', $data);
    }

    public function index1()
    {
        $hashids = new Hashids();
        $data = [
            'title' => 'Home',
            'meta_description' =>'A new platform is born',
            'hashids' => $hashids,
            'gpages' =>Product::orderBy('id', 'desc')->take(5)->get(),
        ];
        $product_model = new Product;
        $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
        return view('index1', $data);
    }

    public function getApps ()
    {
        $data = [
            'title' => 'Apps',
            'meta_description' => 'Check out our current apps'
        ];
        return view('layouts.apps', $data);
    }

    public function getCreator()
    {
        $data = [
            'title' => 'Create a product page',
            'meta_description' =>'What is G-Pages? and about G-pages'
        ];

        return view('layouts.creator', $data);
    }
    public function getSearchResult(Request $request)
    {
        $q =$request->q;

        $data =[
            'meta_description' =>'Search inside products',
            'title' =>'Search Result',
            'gpages_list'=>Product::select('id','name','bar_code','title','price','manufactured_by','description','image','status','view_count','created_at','updated_at','user_id')
                ->where('status','=',3)
//                ->where('product.bar_code', 'like', '%'.$request->q.'%')
//                ->orwhere('product.title', 'like', '%'.$request->q.'%')
//                ->orwhere('product.name', 'like', '%'.$request->q.'%')
                ->where(function($query) use ($q){
                    $query->where('bar_code', 'like', '%'.$q.'%');
                    $query->orwhere('title', 'like', '%'.$q.'%');
                    $query->orWhere('name', 'LIKE', '%'.$q.'%');
                })


//                ->whereHas(function ($query) use ($q) {
//                    $query->where('status','=',3);
//                })
                ->paginate(5),
            'query' => $request->q,
        ];

        return view('layouts.searchresult', $data);

    }


    public function getLogin()
    {
        $data = [
            'title' => 'Log in',
            'meta_description' => 'Log into your account or Create a new account'
        ];
        return view('layouts.login', $data);
    }

    public function getResetPassword()
    {
        $data = [
            'title' => 'Reset password',
            'meta_description' => 'Reset your password, to get a new password'
        ];
        return view('layouts.resetpassw', $data);
    }
    
    public function select_Account_Type(array $data=NULL)
    {
        $data = [
            'title' => 'Select Account',
            'meta_description' => 'Select a Gfects account type',
        ];

        return view('layouts.select_A_Type', $data);
    }
    
    public function getCreateAccount(array $data=NULL)
    {
        $data = [
            'title' => 'Create Account',
            'meta_description' => 'Create a Gfects account',
            'country' => request('country'),
            'state' => request('state')
        ];

        return view('layouts.createAccount', $data);
    }

    public function getCreatorTypes()
    {
        $data = [
            'title' => 'Creator Types',
            'meta_description' =>'There are the types of Gfects creator/publisher account types'
        ];

        return view('layouts.creatorTypes', $data);
    }

    public function getAPublisher()
    {
        $data = [
            'title' => 'Publisher Account',
            'meta_description' => 'Read about the Publisher account type'
        ];

        return view('layouts.aPublisher', $data);
    }

    public function getABusiness()
    {
        $data = [
            'title' => 'Publisher Account',
            'meta_description' => 'Read about the Publisher account type'
        ];
        return view('layouts.aPublisher', $data);
    }

    public function getAAgency()
    {
        $data = [
            'title' => 'Publisher Account',
            'meta_description' => 'Read about the Publisher account type'
        ];
        return view('layouts.aPublisher', $data);
    }

    public function getAboutPage()
    {
        $data = [
            'title' => 'About',
            'meta_description' => 'All what you new to know about Gfects'
        ];

        return view('layouts.about', $data);
    }

    public function getContactPage()
    {
        $data = [
            'title' => 'feedback',
            'meta_description' => 'Send us your feedback'
        ];
        return view('layouts.feedback', $data);
    }

    public function postContactPage(Request $request)
    {
        $request->validate([
            'name' => 'required|min:3|max:50',
            'email' => 'required|email',
            'message' => 'required|min:15|max:250'
        ]);

        $data = [
            'title' => 'feedback',
            'meta_description' => 'Send us your feedback',
            'thankyou4feedbckmsg' => 'thankyou4feedbckmsg',
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'msg' => $request->input('message'),
        ];
        $edata_name = $request->input('name');
        $edata_email = $request->input('email');
        $edata_message = $request->input('message');


//        Mail::send('layouts.feedbackmsg', $data , function($mail) use($request){
//            $mail->from('feedback@gfects.com', $request->name);
//            $mail->to('info@gfects.com')->subject('Gfects Feedback web');
//        });

        return view('layouts.thanksyou', $data);
    }

    public function getPrivacyPage()
    {
        $data = [
            'title' => 'Privacy',
            'meta_description' => 'Read our  privacy policy',
            'displayThis_1' => 'd-none',
            'displayThis_2' => ''
        ];
        return view('layouts.privTerms', $data);
    }

    public function getTermPage()
    {
        $data = [
            'title' => 'Terms',
            'meta_description' =>'Read our terms of use',
            'displayThis_1' => '',
            'displayThis_2' => 'd-none'
        ];
        return view('layouts.privTerms', $data);
    }
    
    public function getPolicyPage()
    {
        $data = [
            'title' => 'Creator Policy',
            'meta_description' =>'Read our Creator Policy',
        ];
        return view('layouts.cPolicy', $data);
    }

    public function getGscanPage()
    {

        $data = [
            'title' =>'G-scan',
            'meta_description' =>'About the G-scan Qr code and Barcode scanning app.',
            'app' => apps::all()->where('app_name', 'G-scan')->first(),
            'platforms' => ['Android', 'Apple iOS'],
            'languages' => ['English', 'German', 'Russian', 'Japanese', 'Korean', 'Spanish'],
            'displayThis' => 'd-none'

        ];
        return view('layouts.app', $data);
    }

    public function getGtosPage()
    {
        $data = [
            'title' => 'G-tos',
            'meta_description' =>'About the G-tos NFC, Qr code, and Barcode scanning app.',
            'app' => apps::all()->where('app_name', 'G-tos')->first(),
            'platforms' => ['Android', 'Apple iOS'],
            'languages' => ['English', 'German', 'Russian', 'Japanese', 'Korean', 'Spanish'],
            'displayThis' => ''
        ];

        return view('layouts.app', $data);
    }

    public function getMoreServicePage()
    {
        $data = [
            'title' => 'Create a product page',
            'meta_description' =>'What is G-Pages? and about G-pages'
        ];
        return view('layouts.moreService', $data);
    }

    public function getCreatorPage()
    {
        $data = [
            'title' => 'Create a product page',
            'meta_description' =>'What is G-Pages? and about G-pages'
        ];

        return view('layouts.creator', $data);
    }

    public function getSelectPakage()
    {
        $data = [
            'title' => 'Select Package',
            'meta_description' =>'Select the Creator package type you want to go with'
        ];

        return view('layouts.packages', $data);
    }



}
