<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class MessageChat extends Model
{
	protected $table = 'message_chat';
	public function get_chat_by_user_id($id)
	{
		$query = DB::table('message_chat as mc')
		->select('mc.*','u_reciver.username as reciver_username','u_reciver.profile_picture as reciver_picture','u_sender.username as sender_username','u_sender.profile_picture as sender_picture');
		$query->where('sender_id',$id);
		$query->orWhere('reciver_id', $id);
		$query->join('users as u_reciver','u_reciver.id','=','mc.reciver_id');
		$query->join('users as u_sender','u_sender.id','=','mc.sender_id');
		$query->orderBy('serial_number');
		$result = $query->get();
    	return $result;
	}
	public function get_chat_by_creator_id($id)
	{
		$query = DB::table('message_chat as mc')
		->select('mc.*','u_reciver.username as reciver_username','u_reciver.profile_picture as reciver_picture','u_sender.username as sender_username','u_sender.profile_picture as sender_picture');
		$query->where('reciver_id', $id);
		$query->join('users as u_reciver','u_reciver.id','=','mc.reciver_id');
		$query->join('users as u_sender','u_sender.id','=','mc.sender_id');
		$query->orderBy('serial_number');
		$result = $query->get();
    	return $result;
	}

	public function get_chat_by_creator_id_and_user_id($user_id, $creator_id)
	{
		$query = DB::table('message_chat as mc')
		->select('mc.*','u_reciver.username as reciver_username','u_reciver.profile_picture as reciver_picture','u_sender.username as sender_username','u_sender.profile_picture as sender_picture');
		$query->where(function($query) use ($user_id,$creator_id){
             $query->where('reciver_id', $user_id);
             $query->where('sender_id', $creator_id);
         });
		$query->orWhere(function($query) use ($user_id,$creator_id){
             $query->where('reciver_id', $creator_id);
             $query->where('sender_id', $user_id);
         });
		$query->join('users as u_reciver','u_reciver.id','=','mc.reciver_id');
		$query->join('users as u_sender','u_sender.id','=','mc.sender_id');
		$query->orderBy('serial_number');
		$result = $query->get();
    	return $result;
	}
}
