@extends('layouts.main')
@section('content')
<div>
    <div>
        <h3>Gpages List</h3>
        <div>
            <table class="table table-striped">
                <thead>
                  <tr>
                    <th>SN</th>
                    <th>Barcode</th>
                    <th>Name</th>
                    <th>title</th>
                    <th>Category</th>
                    <th>Subcategory</th>
                    <th>Descriptions</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  @if(count($gpages_list))
                    @foreach($gpages_list as $key=>$value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$value->bar_code}}</td>
                            <td><a href="{{url('creator/preview-gpages/'.$value->id)}}">{{$value->name}}</a></td>
                            <td>{{$value->title}}</td>
                            <td>{{$value->category_name}}</td>
                            <td>{{$value->subcategory_name}}</td>
                            <td>{{$value->description}}</td>
                            @if($value->status == 1)   
                                <td><span class="btn-sm btn-info">Drafted</span></td>
                            @elseif($value->status == 2)
                                <td><span class="btn-sm btn-primary">Submitted</span></td>
                            @elseif($value->status == 3)
                                 <td><span class="btn-sm btn-success">Approved</span></td>
                             @elseif($value->status == 4)
                                 <td><span class="btn-sm btn-danger">Rejected</span></td>
                            @endif
                            <td>
                                <a  href="{{url('creator/gpages-info/'.$value->id)}}" style="font-size:18px" class=""><i class="fa fa-eye"></i></a>
                                <a href="{{url('creator/edit-product/'.$value->id)}}" style="font-size:18px" class=""><i class="fa fa-edit"></i></a>
                                <a  style="font-size:18px" class="delete_icon" data-id="{{$value->id}}" ><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                    @endforeach
                  @endif
              </table>
        </div>
    </div>
        <hr class="featurette-divider">
        @include('common.menu')
    </div>
    <div id="info_model" class="modal fade" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
              <button type="button" class="close close_btn" data-model_id="info_model" data-type="video" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
              <div class="">
                <h3>Sorry, this task is under construction.</h3>
              </div>
            </div>
            <div class="modal-footer">
            </div>
          </div>

        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function(){
            $('body').on('click', '.close_btn', function(e) {
                var id = $(this).data('model_id');
                $("#"+id).modal("toggle");
            });
            $('body').on('click', '.common_action', function(e) {
                $("#info_model").modal("toggle");
            });
            $('body').on('click', '.delete_icon', function(e) {
                var id = $(this).data('id');
                if(id != "" || id != undefined){
                    bootbox.confirm({
                        message: "Are you sure want to delete ?",
                        buttons: {
                            cancel: {
                                label: '<i class="fa fa-times"></i> Cancel'
                            },
                            confirm: {
                                label: '<i class="fa fa-check"></i> Confirm'
                            }
                        },
                        callback: function (result) {
                            console.log('This was logged in the callback: ' + result);
                            if(result){
                                $.ajax({
                                    type: "POST",
                                    url: site_url+"/creator/delete-product",
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    data: {id: id},
                                    success: function(res){
                                       var data = jQuery.parseJSON(res);
                                       if(data.status){
                                        toastr.success(data.msg);
                                        setTimeout(function(){
                                           window.location.reload();
                                        }, 900);
                                          
                                       }else{
                                        toastr.error(data.msg);
                                        setTimeout(function(){
                                            window.location.reload();
                                        }, 900);
                                       }
                                    }
                                });
                            }
                        }
                    });
                }
            });
        })
    </script>
  @endsection
