@extends('layouts.main')
@section('content')
<style type="text/css">
   .remove_click{
   pointer-events:none;
   }
   .required_span{
   font-size: 19px;
   margin-left: 1px;
   color: red;
   }
   .text-label-value{
   margin-top: 7px;
   margin-left: 10px;
   }
</style>
<div>
   <div class="row">
      <div class="col-md-8">
         <h3>Preview Gpages</h3>
      </div>
      <div class="col-md-2">
         <a class="btn btn-primary" href="{{url('creator/edit-product')}}/{{$product->id}}" style="width: 120px;margin-left: 80px">Edit</a>
      </div>
      <div class="col-md-2">
         @if($product->status == 1)
         <a  class="btn btn-primary" href="#" id="publish_btn" data-id="{{$product->id}}" style="width: 120px;margin-left: 30px;" >Publish</a>
         @else
         <a  class="btn btn-primary remove_click" href="#" id="publish_btn" data-id="{{$product->id}}" style="width: 155px;margin-left: 30px;background-color: green" >Already Published</a>
         @endif
      </div>
   </div>
   <div>
      <nav class="mt-4">
         <div class="nav nav-tabs" id="nav-tab" role="tablist">
            <a class="nav-item nav-link active " id="nav-home-barcode" data-toggle="tab" href="#home-barcode" role="tab" aria-controls="nav-barcode" aria-selected="true">1: Bar Code/UPC</a>
            <a class="nav-item nav-link " id="nav-basic-details" data-toggle="tab" href="#basic-details" role="tab" aria-controls="nav-basic-details" aria-selected="true">2: Basic Details</a>
            <a class="nav-item nav-link " id="nav-maker-details" data-toggle="tab" href="#maker-details" role="tab" aria-controls="nav-maker-details" aria-selected="true">3: Makers Details</a>
            <a class="nav-item nav-link " id="nav-product-media" data-toggle="tab" href="#product-media" role="tab" aria-controls="nav-product-media " aria-selected="true">4: Product Media</a>
            <a class="nav-item nav-link " id="nav-about-product" data-toggle="tab" href="#about-product" role="tab" aria-controls="nav-about-product" aria-selected="true">5: About Product</a>
            <a class="nav-item nav-link " id="nav-external-sources" data-toggle="tab" href="#external-sources" role="tab" aria-controls="nav-external-sources" aria-selected="true">6: External Sources</a>
            <!-- <a class="nav-item nav-link " id="nav-pages-options" data-toggle="tab" href="#pages-options" role="tab" aria-controls="nav-pages-options" aria-selected="true">7: G Pages Options</a> -->
         </div>
      </nav>
      <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: 103px;margin-left: 353px; display: none;" id="loader_img_product_update" />
      @csrf
      <div class="tab-content" id="nav-tabContent">
         <div class="tab-pane active" id="home-barcode" role="tabpanel" aria-labelledby="home-barcode-tab">
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Bar Code</label>
               <div class="col-md-6 text-label-value">
                  {{$product->bar_code}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Category</label>
               <div class="col-md-6 text-label-value">
                  {{$product->category_name}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Subcategory</label>
               <div class="col-md-6 text-label-value">
                  {{$product->subcategory_name}}                         
               </div>
            </div>
         </div>
         <div class="tab-pane fade" id="basic-details" role="tabpanel" aria-labelledby="basic-details">
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Product Name</label>
               <div class="col-md-6 text-label-value">
                  {{$product->name}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Product Title</label>
               <div class="col-md-6 text-label-value">
                  {{$product->title}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Product Summary</label>
               <div class="col-md-6 text-label-value">
                  {{$product->description}}
               </div>
            </div>
         </div>
         <div class="tab-pane fade" id="maker-details" role="tabpanel" aria-labelledby="maker-details">
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Manufacture</label>
               <div class="col-md-6 text-label-value">
                  {{$product->manufactured_by}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Made In</label>
               <div class="col-md-6 text-label-value">
                  {{$product->made_in_name}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Summary</label>
               <div class="col-md-6 text-label-value">
                  {{$product->mnf_summary}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Msr Price</label>
               <div class="col-md-6 text-label-value">
                  {{$product->msr_price}}
               </div>
            </div>
            <!-- <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Price</label>
               <div class="col-md-6 text-label-value">
                  {{$product->price}}
               </div>
            </div> -->
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Currency</label>
               <div class="col-md-6 text-label-value">
                  {{$product->code}}({{$product->symbol}})
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Manufactured Part No</label>
               <div class="col-md-6 text-label-value">
                  {{$product->manufactured_port_no}}
               </div>
            </div>
            <div id="add_more_color_div">
               <div class="row m-4">
                  <label for="name" class="col-md-4 col-form-label text-md-right">Color Show</label>
                  <div class="col-md-2">
                     @if(!empty($product->color_to_show))
                     <?php 
                        $colors= json_decode($product->color_to_show); 
                        ?>
                     @foreach ($colors as $key => $value)
                     <span class="btn btn-primary" style="background-color:<?=$value?>; height: 20px;width: 50px;"></span>
                     @endforeach
                     @endif
                  </div>
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Weight</label>
               <div class="col-md-6 text-label-value">
                  {{$product->weight}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Unit Price</label>
               <div class="col-md-4">
                  {{$product->unit_price}}
               </div>
            </div>
            <?php
               $d_details = json_decode($product->dimension);
               ?>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Dimenstions Unit</label>
               <div class="col-md-4">
                  {{$d_details->type}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right"></label>
               <div class="col-md-2">
                  <label class="col-form-label">Length</label>
                  {{$d_details->length?$d_details->length:''}}
               </div>
               <div class="col-md-2">
                  <label class="col-form-label">Width</label>
                  {{$d_details->width?$d_details->width:''}}
               </div>
               <div class="col-md-2">
                  <label class="col-form-label">Height</label>
                  {{$d_details->height?$d_details->height:''}}
               </div>
               <div class="col-md-2">
                  <label class="col-form-label">Grith</label>
                  {{$d_details->grith?$d_details->grith:''}}
               </div>
            </div>
         </div>
         <div class="tab-pane fade" id="product-media" role="tabpanel" aria-labelledby="product-media">
            <div class="row">
               <div class="col-md-6 text-label-value">
                  Product Pictures
               </div>
            </div>
            <div class="row" >
               <div class="col-md-6 text-label-value"></div>
            </div>
            <!-- image section start here-->
            <div id="image_preview_main_div">
               <?php 
                  $img = json_decode($product->image);
                  ?>
               <div class="row">
                  @foreach($img as $key => $img)
                  <div class="col-md-4">
                     <img src="{{asset($img->url)}}" height="250px" width="300px">
                  </div>
                  @endforeach
               </div>
            </div>
            <div class="row" >
               <div class="col-md-6 text-label-value">
                  Product Videos
               </div>
            </div>
            <div id="video_preview_main_div">
               <div class="row">
                  @if(!empty($product->video))
                  <?php 
                     $video = json_decode($product->video);
                     ?>
                  @foreach($video  as $key => $video)
                  <div class="col-md-4">
                     <video height="250px" width="300px" controls class="video">
                        <source src="{{asset($video->url)}}" id="preview_video">
                        Your browser does not support HTML5 video.
                     </video>
                  </div>
                  @endforeach
                  @endif
               </div>
            </div>
         </div>
         <div class="tab-pane fade" id="about-product" role="tabpanel" aria-labelledby="about-product">
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Featured</label>
               <div class="col-md-6">
                  <?=$product->features_feed?>
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Specification</label>
               <div class="col-md-6">
                  <?=$product->spec_field?>
               </div>
            </div>
         </div>
         <div class="tab-pane fade" id="external-sources" role="tabpanel" aria-labelledby="external-sources">
            @if(!empty($product->buy_online_link))
            <?php 
               $buy_link = json_decode($product->buy_online_link);                                
               ?>
            @foreach($buy_link as $key => $value)
            <div class="row m-4">
               @if($key == 0)
               <label for="name" class="col-md-4 col-form-label text-md-right">Buy online url:</label>
               @else
               <label for="name" class="col-md-4 col-form-label text-md-right"></label>
               @endif
               <div class="col-md-6 text-label-value">
                  {{$value->online_url}}     Price: {{$value->price}}
               </div>
            </div>
            @endforeach   
            @endif                                  
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Product Webpage</label>
               <div class="col-md-6 text-label-value">
                  {{$product->web_page_link}}
               </div>
            </div>
            <div class="row m-4">
               <label for="name" class="col-md-4 col-form-label text-md-right">Manufacture Webpage</label>
               <div class="col-md-6 text-label-value">
                  {{$product->manufactured_web_page_link}}
               </div>
            </div>
         </div>
      </div>
   </div>
   <hr class="featurette-divider">
   @include('common.menu')
</div>
<script type="text/javascript">
   $(document).ready(function(){
     $('body').on('click', '#publish_btn', function(e) {
       var id = $(this).data('id');
       if(id != "" || id != undefined){
         bootbox.confirm({
             message: "Are you sure want to Publish ?",
           buttons: {
               cancel: {
                   label: '<i class="fa fa-times"></i> Cancel'
               },
               confirm: {
                   label: '<i class="fa fa-check"></i> Confirm'
               }
           },
           callback: function (result) {
               if(result){
                   $.ajax({
                       type: "POST",
                       url: site_url+"/creator/publish-gpages",
                       headers: {
                           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                       },
                       data: {id: id},
                       success: function(res){
                          var data = jQuery.parseJSON(res);
                          if(data.status){
                           toastr.success(data.msg);                                  
                          }else{
                           toastr.error(data.msg);
                           /*setTimeout(function(){
                               window.location.reload();
                           }, 900);*/
                          }
                       }
                   });
               }
           }
         });
       }
     });
   })
</script>
@endsection