@extends('layouts.main')
@section('content')
<style type="text/css">
  .error {
    color: red;
    margin-left: 5px;
  }
  .text-span{
    margin-left: 50px;
  }
</style>
<div>
    <div class="">
        <div class="">
          <h3>Gpages Qrcode List</h3>
        </div>
        <!-- <div class="" style="float: right;margin-bottom: 10px;">
        <h3>
          <a class="btn btn-primary" href="#" id="send_msg_to_support">Support</i></a>
        </h3>
        </div> -->
        <div>
            <table class="table table-striped">
                <thead>
                  <tr>
                    <th>SN</th>
                    <th>Name</th>
                    <th>Scan</th>
                    <th>Created At</th>
                    <th>Gfx linked</th>
                  </tr>
                </thead>
                <tbody>
                  @if(count($list))
                    @foreach($list as $key=>$value)
                    <?php
                      $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                      $page_name = preg_replace('/-+/', '-', $page_name); 
                      $gfx=env('GFX_URL','https://gfx.li/gfects/');
                      if(!empty($value->link_id)){
                        $short_url = $gfx.$value->link_id;
                      }else{
                        $short_url = $gfx.strtolower($page_name).'/about/'.$value->id;
                      }
                    ?>
                        <tr>
                            <td>{{$key+1}}</td>
                            <td><a href="{{url('creator/gpages-qrcode/'.$value->id)}}">{{$value->name}}</a></td>
                            <td>0</td>
                            <td>{{date("d M Y", strtotime($value->created_at))}}</td>
                            <td class="link"><a href="javascript::void">{{$short_url}}</a></td>
                        </tr>
                    @endforeach
                  @endif
              </table>
        </div>
    </div>
        <hr class="featurette-divider">
        @include('common.menu')
    </div>
    <script type="text/javascript">
        $(document).ready(function(){
        });
    </script>
  @endsection
