@extends('layouts.main')
@section('content')
<style type="text/css">
  .error {
    color: red;
    margin-left: 5px;
  }
  .text-span{
    margin-left: 50px;
  }
</style>
<div>
    <div class="">
        <div class="">
          <h3>Support Message List</h3>
        </div>
        <div class="" style="float: right;margin-bottom: 10px;">
        <h3>
          <a class="btn btn-primary" href="{{url('home/support')}}">Create Support Message</i></a>
        </h3>
        </div>
        <div>
            <table class="table table-striped">
                <thead>
                  <tr>
                    <th>SN</th>
                    <th>About</th>
                    <th>Description</th>
                    <th>Created At</th>
                    <th>Resolved </th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  @if(count($message_list))
                    @foreach($message_list as $key=>$value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>
                              <a href="{{url('creator/support-message-exchange/'.$value->id)}}"> {{$value->subject}} </a>
                            </td>
                            <td>{{$value->message}}</td>
                            <td>{{date("d M Y", strtotime($value->created_at))}}</td>
                            <td><span class="btn btn-{{$value->support_status == 1 ?"success":"info"}}" style="width: 60px;padding: 0px;">{{$value->support_status == 1 ?"Yes":"No"}}</span>
                            </td>
                            <td>
                                <a  style="font-size:18px" class="common_action" data-id="{{$value->id}}"><i class="fa fa-eye"></i></a>
                                <a  style="font-size:18px" class="delete_icon" data-id="{{$value->id}}"><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                    @endforeach
                  @endif
              </table>
        </div>
    </div>
        <hr class="featurette-divider">
        @include('common.menu')
    </div>
    <div id="info_model" class="modal fade" role="dialog">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Message Details</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="message_reply_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body mx-3">
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form29">About:</label>
              <span id="about" class="text-span"></span>
            </div>
             <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form29">Description:</label>
              <span id="description" class="text-span"></span>
            </div>
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form29">To:</label>
             <span id="to" class="text-span"></span>
            </div>
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form34">Time:</label>
              <span id="created_at" class="text-span"></span>
            </div>
            <div class="modal-footer d-flex justify-content-center">
             
            </div>
          </div>
        </div>
    </div>
  </div>
    <!-- reply model start here -->
    <div class="modal fade" id="support_reply_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
      aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Send Message to Support Team</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="message_reply_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form method="post" name="support_reply_frm" id="support_reply_frm">
            <div class="modal-body mx-3">
              <div class="md-form mb-4">
                <i class="fas fa-envelope prefix grey-text"></i>
                <label data-error="wrong" data-success="right" for="form34">About</label>
                <input type="text" id="about_txt" name="about_txt" class="form-control">
              </div>
              <div class="md-form mb-4">
                <i class="fas fa-envelope prefix grey-text"></i>
                <label data-error="wrong" data-success="right" for="form34">Message</label>
                <textarea id="message_txt" name="message_txt" class="form-control" style="min-height: 160px;"></textarea> 
              </div>
            </div>
            <div class="modal-footer d-flex justify-content-center">
              <input class="btn btn-unique" type="submit" value="Send"> <i class="fas fa-paper-plane-o ml-1"></i></button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- reply model end here -->
    <script type="text/javascript">
        $(document).ready(function(){
          //close model by id
          $('body').on('click', '.close_btn', function(e) {
              var id = $(this).data('model_id');
              $("#"+id).modal("toggle");
          });
          //message details by id
          $('body').on('click', '.common_action', function(e) {
            var id = $(this).data('id');
            if(id != '' || id != undefined){
              $.ajax({
                  type: "POST",
                  url: site_url+"/ajax/support-details",
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  data: {id: id},
                  success: function(res){
                     var data = jQuery.parseJSON(res);
                     if(data.status){
                      $("#about").html(data.message[0].subject);
                      $("#description").html(data.message[0].message);
                      $("#to").html(data.message[0].reciver_name);
                      $("#created_at").html(data.message[0].created_at);
                      $("#info_model").modal("toggle");
                     }else{
                      toastr.error(data.msg);
                     }
                  }
              });
            }
          });          
          //open message reply model
          $('body').on('click', '#send_msg_to_support', function(e) {
            $("#about_txt").val('');
            $("#message_txt").val('');
            $("#support_reply_model").modal("toggle");
          });
          //message reply form submit
          $('form[id="support_reply_frm"]').validate({
            rules: {
              about_txt: 'required',
              message_txt: 'required',
            },
            messages: {
              about_txt: 'Please enter about field.',
              message_txt: 'Please enter message field.',
            },
            submitHandler: function(form) {
              //form.submit();
              frm = $('#support_reply_frm');
              $.ajax({
                type: "POST",
                url: site_url+"/creator/message-to-support",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: frm.serialize(),
                success: function(res){
                   var data = jQuery.parseJSON(res);
                   $("#support_reply_model").modal("toggle");
                   if(data.status){
                      toastr.success(data.msg);
                      setTimeout(function(){
                         window.location.reload();
                      }, 900);
                   }else{
                      toastr.error(data.msg);
                   }
                }
              });
            }
          });
        })

        //delete message
        $('body').on('click', '.delete_icon', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: "Are you sure want to delete ?",
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        console.log('This was logged in the callback: ' + result);
                        if(result){
                            $.ajax({
                                type: "POST",
                                url: site_url+"/creator/delete-support-message",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: {id: id},
                                success: function(res){
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                    toastr.success(data.msg);
                                    setTimeout(function(){
                                       window.location.reload();
                                    }, 900);
                                      
                                   }else{
                                    toastr.error(data.msg);
                                    setTimeout(function(){
                                        window.location.reload();
                                    }, 900);
                                   }
                                }
                            });
                        }
                    }
                });
            }
        });
    </script>
  @endsection
