@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
    <style type="text/css">
      #badge_new{
        width: 40px;
        position:relative;
        top: 0;
        left:-23px;
      }
        #phone_silhouette
        {
            min-width:152px;
            min-height:300px;
            background: url("{{url('/public/assets_web/img/iphone-x-silhouette.png')}}");
            background-size: contain;
            background-repeat: no-repeat;
        }

      #scene_item_1{
        position:absolute;
          top: 70px;
          left: 24px;
        width:103px;
        height:250px;
      }

        #scene_item_1 .scan
        {
          width:107px;
          height:1px;
          background-color:rgba(23, 159, 220, 0.46);
          position:absolute;
          z-index:3;
           -moz-animation: scan 3s  5100ms 1;
          -webkit-animation: scan 3s  5100ms 1;
          animation: scan 3s 5100ms 1;
        }

        @-webkit-keyframes scan {
          0%, 100% {
            -webkit-transform: translateY(-20px);
            transform: translateY(-20px);
          }
          100% {
            -webkit-transform: translateY(210px);
            transform: translateY(100px);
          }
        }
        
        #scene_item_2
        {
           width:150px;
          height:50px;
          position:absolute;
        }

        #scene_item_2 .code
        {
          width: 90px;
          height: 55px;
          position:relative;
          top: 60px;
          margin:auto;
          background: url("{{url('/public/assets_web/img/G-web.png')}}") -30px -576px;
          background-size:259px;
        }

        #scene_item_3
        {
          width:150px;
          height:50px;
          position:absolute;
        }

        #scene_item_3 .codes
        {
          margin:auto;
            position: relative;
            top: 110px;
          width:65px;
          height:68px;
          background:url("{{url('/public/assets_web/img/G-web.png')}}") -507px -504px;
          background-size:323px;
        }

        #scene_item_4
        {
          width:150px;
          height:150px;
          position:absolute;
        }

        #scene_item_4 .codes
        {
          margin:auto;
            position: relative;
            top: 180px;
          width:65px;
          height:68px;
          background:url("{{url('/public/assets_web/img/G-web.png')}}") -361px -504px;
          background-size:323px;
        }


        /* ----------------------------------------------
         * Generated by Animista on 2019-7-28 8:33:6
         * w: http://animista.net, t: @cssanimista
         * ---------------------------------------------- */

        /**
         * ----------------------------------------
         * animation slide-out-bck-center
         * ----------------------------------------
         */

        .slide-out-bck-center {
            -webkit-animation: slide-out-bck-center 0.5s cubic-bezier(0.550, 0.085, 0.680, 0.530) 7s both;
                    animation: slide-out-bck-center 0.5s cubic-bezier(0.550, 0.085, 0.680, 0.530) 7s both;
        }

        @-webkit-keyframes slide-out-bck-center {
          0% {
            -webkit-transform: translateZ(0);
                    transform: translateZ(0);
            opacity: 1;
          }
          100% {
            -webkit-transform: translateZ(-1100px);
                    transform: translateZ(-1100px);
            opacity: 0;
          }
        }
        @keyframes slide-out-bck-center {
          0% {
            -webkit-transform: translateZ(0);
                    transform: translateZ(0);
            opacity: 1;
          }
          100% {
            -webkit-transform: translateZ(-1100px);
                    transform: translateZ(-1100px);
            opacity: 0;
          }
        }




        #scene_item_5
        {
          width:50px;
          height:50px;
          position:absolute;
        }


        #scene_item_5 .img
        {
          position: relative;
          width:inherit;
          height:inherit;
          top: 60px;
          right: -82px;
          background-color:rgba(29, 34, 230, 0.2);
        }

        #scene_item_6
        {
          width:50px;
          height:50px;
          position:absolute;
        }

        #scene_item_6 .img
        {
          position: relative;
          width:inherit;
          height:inherit;
          top: 60px;
          left:23px;
        }

        #scene_item_7
        {
          width: 52px;
          height: 53px;
          position: absolute;
        }

        #scene_item_7 .img
        {
          position: relative;
          width:inherit;
          height:inherit;
          top: 125px;
          right: -52px;
          background: url("{{url('/public/assets_web/img/G-web.png')}}") -478px -5px;
          background-size: 265px;
        }

        #scene_item_8
        {
          width:50px;
          height:50px;
          position:absolute;
        }

        #scene_item_8 .img
        {
          position: relative;
          width:inherit;
          height:inherit;
          top: 190px;
          right: -82px;
        }

        #scene_item_9
        {
          width:50px;
          height:50px;
          position:absolute;
        }

        #scene_item_9 .img
        {
          position: relative;
          width:inherit;
          height:inherit;
          top: 190px;
          left:23px;
        }


        /* ----------------------------------------------
         * Generated by Animista on 2019-7-28 7:19:58
         * w: http://animista.net, t: @cssanimista
         * ---------------------------------------------- */

        /**
         * ----------------------------------------
         * animation fade-in-bottom
         * ----------------------------------------
         */

        .fade-in-bottom-1 {
            -webkit-animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 9s both;
                    animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 9s both;
        }

        .fade-in-bottom-2 {
            -webkit-animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 9700ms both;
                    animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 9700ms both;
        }

        .fade-in-bottom-3 {
            -webkit-animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 9800ms both;
                    animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 9800ms both;
        }

        .fade-in-bottom-4 {
            -webkit-animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 10000ms both;
                    animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 10000ms both;
        }

        .fade-in-bottom-5 {
            -webkit-animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 10100ms both;
                    animation: fade-in-bottom 0.6s cubic-bezier(0.390, 0.575, 0.565, 1.000) 10100ms both;
        }

        @-webkit-keyframes fade-in-bottom {
          0% {
            -webkit-transform: translateY(50px);
                    transform: translateY(50px);
            opacity: 0;
          }
          100% {
            -webkit-transform: translateY(0);
                    transform: translateY(0);
            opacity: 1;
          }
        }
        @keyframes fade-in-bottom {
          0% {
            -webkit-transform: translateY(50px);
                    transform: translateY(50px);
            opacity: 0;
          }
          100% {
            -webkit-transform: translateY(0);
                    transform: translateY(0);
            opacity: 1;
          }
        }
    </style>
  @endsection
  @section('Google_adsense')
    @includeif('gfects.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
    <div class="container">
        <div class="row align-items-center">
          <div class="col-6 mx-auto col-md-6 order-md-2">
            
            <div id="scenes" class="position-relative">
              <div id="scene_1">
                    
                    <div id="phone_silhouette" class="img-fluid mb-3 mx-auto d-block relative" role="img">
                        <div class="slide-out-bck-center">
                            <div id="scene_item_1">
                                <div class="scan"></div>
                            </div>
                            <div id="scene_item_2">
                                <div class="code"></div>
                            </div>
                            <div id="scene_item_3">
                                <div class="codes"></div>
                            </div>
                            <div id="scene_item_4">
                                <div class="codes"></div>
                            </div>
                        </div>
                            
                        <div class="">
                            <div id="scene_item_5" title="video icon">
                                <div class="img text-center rounded bg-success fade-in-bottom-2">
                                    <span><i class="fas fa-play text-white" style="padding-top: 17px;"></i></span>
                                </div>
                                
                            </div>
                            <div id="scene_item_6" title="images icon">
                                <div class="img text-center rounded bg-info fade-in-bottom-4">
                                    <span><i class="fas fa-image text-white" style="padding-top: 17px;"></i></span>
                                </div>
                            </div>
                            <div id="scene_item_7" title="Gpages icon">
                                <div class="img fade-in-bottom-1">
                                    
                                </div>
                            </div>
                            <div id="scene_item_8" title="3D icon">
                                <div class="img text-center rounded bg-warning fade-in-bottom-3">
                                    <span><i class="fas fa-cube text-white" style="padding-top: 17px;"></i></span>
                                </div>
                            </div>
                            <div id="scene_item_9" title="AI icon">
                                <div class="img text-center rounded bg-danger fade-in-bottom-5">
                                    <span><i class="fas fa-robot text-white" style="padding-top: 17px;"></i></span>
                                </div>
                            </div>
                        </div>
                            
                    </div>
              </div>
              
            </div>
          </div>
          <div class="col-md-6 order-md-1 text-center text-md-left pr-md-5">
            <div class="w-100 mb-3">
                <div id="badge_new"><span class="badge badge-pill badge-info">New</span></div>
              <h4 style="color:#2e6184">Let's introduce G-pages -<span class="text-muted">the page for your product</span>.</h4>
            </div>
            <p class="lead">
              G-page is the page that gives you all the information you need to know about a product.
            </p>
            <div class="row mx-n2">
              <div class="col-md m-3 px-2">
                @guest
                <a href="{{ url('/') }}/creator/add-product"><button type="button" class="btn btn-primary shadow">Get started</button></a>
                @endguest
              </div>
              <div class="col-md m-3 px-2">
                <a href="{{ url('/') }}/Gpages"><button type="button" class="btn btn-info shadow">Read more</button></a>
              </div>
            </div>
          </div>
        </div>

      </div>
  @endsection

  {{-- Middle --}}
  @section('section_content')

          <hr class="featurette-divider">
<!--
          <div class="container">
             <div class="row">
                <h3>Recently Gpages</h3>
             </div>

             <div class="m-auto mt-1 row">
                 <?php $x=0 ?>
                 @if(count($gpages_list))
                                    <style type="text/css">
                                      /*-----Gpages---start---*/
                                      .G-box
                                      {
                                          min-width:237px;
                                          max-width:237px;
                                          height:255px;
                                      }
                                      @media only screen and (max-width: 767px) {
                                        .G-box {
                                          margin: auto;
                                        }
                                      }
                                      .G-box .cardDiv1
                                      {
                                          width:237px;
                                          margin-bottom:17px;
                                          overflow:hidden;
                                      }
                                      .G-box .cardDiv2
                                      {
                                          max-width: 237px;
                                          padding-bottom:120px;
                                      }
                                      .G-box .cardDiv3
                                      {
                                        max-height:150px;
                                          bottom: 0;
                                          left: 0;
                                          position: absolute;
                                          right: 0;
                                          text-align: center;
                                          top: 0;
                                      }
                                      .G-box img
                                      {
                                          max-height: 100%;
                                          max-width: 100%;
                                          vertical-align: middle;
                                      }
                                      /*-----Gpages---END---*/
                                    </style>
                 @foreach($gpages_list as $key => $value)
                 @if($x < 5)
                 <?php
                    $image = json_decode($value->image);
                    $this->product_model = new \App\Product;
                    $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                    $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                    $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                    $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                                    $grency = $this->product_model->product_details_by_id($value->id);
                    $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                    $page_name = preg_replace('/-+/', '-', $page_name);
                    if(Auth::check()){
                        $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                    }else{
                        $like_status = 0;
                    }
                    $x++;

                                        $gcurrency = \App\Currencie::find($grency->currency)->symbol;#$grency->currency
                    
                    ?>


                  @includeif('layouts.gpagesDiv2')

                @endif
                @endforeach
                @endif
             </div>

          </div>

          <hr>-->
          
          <h4>Our apps</h4>
          <div class="row">
              <div class="col-md my-2">
                <div class="">
                  <a class="btn btn-secondary m-auto" href="G-tos" role="button">
                    <img class="rounded" src="/public/img/Gtos-icon-2.png" alt="Generic placeholder image" width="140" height="140">
                    <h2>G-tos app </h2>
                    <p>G-tos is an NFC, Qr, and barcode reading app.</p>
                    <p>View details &raquo;</p>
                  </a>
                </div>
                  
              </div>
              <div class="col-md my-2">
                <div class="">
                  <a class="btn btn-secondary m-auto" href="G-scan" role="button">
                    <img class="rounded" src="/public/img/G-scan-icon-2.png" alt="Generic placeholder image" width="140" height="140">
                    <h2>G-scan</h2>
                    <p>G-scan is a QR code and barcode scanner app.</p>
                    <p>View details &raquo;</p>
                  </a>
                </div>
              </div>
          </div>
          <hr class="featurette-divider">
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
    
          <hr class="featurette-divider">
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
  <!-- Mail chip newsletter sign up ----Start-->
          <script type="text/javascript" src="//downloads.mailchimp.com/js/signup-forms/popup/unique-methods/embed.js" data-dojo-config="usePlainJson: true, isDebug: false"></script><script type="text/javascript">window.dojoRequire(["mojo/signup-forms/Loader"], function(L) { L.start({"baseUrl":"mc.us19.list-manage.com","uuid":"3d1f73587c5af91829132f561","lid":"50f416f6ff","uniqueMethods":true}) })</script>
  <!-- Mail chip newsletter sign up ----end-->
  @endsection
{{-- script end--}}

{{--Body  end--}}
