@extends('layouts.layout_C')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  <style>
    @media (min-width: 768px) 
      { 
        #smallmenu
        {
          display:none;
        }
      }

      @if ($pass === 'edit')
        .remove_click{
          pointer-events:none;
        }
         .required_span{
          font-size: 19px;
          margin-left: 1px;
          color: red;
        }
        <?php
          $video = 0;
          $how_to_use_video = 0;
        ?>
      @endif

      @if ($pass === 'message-list')
        .error {
            color: red;
            margin-left: 5px;
          }
          .text-span{
            margin-left: 50px;
          }
      @endif
        
  </style>
  @if ($pass === 'message-view')
      @includeif('layouts.inc_messageView_CSS')
    @endif

  @endsection

  
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
    <div class="container-fluid mt-5">

            <nav id="smallmenu" class="navbar navbar-expand-lg navbar-light bg-light">
              <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav2" aria-controls="navbarNav2" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
              </button>
              <div class="collapse navbar-collapse text-center" id="navbarNav2">
                @includeif('layouts.dash_side_nav')
              </div>
            </nav>
        <div class="row">
            <nav class="col-md-2 d-none d-md-block bg-transparent sidebar">
              <div class="sidebar-sticky">
                @includeif('layouts.dash_side_nav')
              </div>
            </nav>

            <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
              <!-- Page title -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">{{$pagetitle}}</h1>
                    
                      <div class="btn-toolbar mb-2 mb-md-0">
                          <a href="{{url('creator/create')}}"><button class="btn font-weight-bold ml-2 text-white shadow" style="background-color: #f15b29;">Create +</button></a>
                      </div>
                </div>

                <!-- Q Stats -->

                
              @if ($pass === 'home')
                  <div class="d-flex justify-content-around">
                  <!-- <div class="col-lg-3 col-sm-4 mb-4">
                    <div class="card bg-primary text-white shadow">
                      <div class="card-body">
                        Published Gpages
                        <div class="text-white-50 small">{{$published_gpages = 0}}</div>
                      </div>
                    </div>
                  </div> -->
                  <div class="col-lg-3 col-sm-4 mb-4">
                    <div class="card bg-success text-white shadow">
                      <div class="card-body">
                        Approved Gpages
                        <div class="text-white-50 small">{{$approved_gpages}}</div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-sm-4 mb-4">
                    <div class="card bg-info text-white shadow">
                      <div class="card-body">
                        Total Likes
                        <div class="text-white-50 small">{{$total_likes}}</div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-sm-4 mb-4">
                    <div class="card bg-warning text-white shadow">
                      <div class="card-body">
                        Total Comments
                        <div class="text-white-50 small">{{$total_comments}}</div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-sm-4 mb-4">
                    <div class="card bg-danger text-white shadow">
                      <div class="card-body">
                        Total Views
                        <div class="text-white-50 small">{{$total_views}}</div>
                      </div>
                    </div>
                  </div>
                </div>
              @endif
                

                <!-- top Gpages -->
                <?php 
                  $data =
                    [
                      'heading' => $heading,
                      'pass' => $pass
                    ]; 
                ?>
                @includeif('layouts.dataCard',$data)

            </main>
        </div>
    </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
    @if ($pass === 'edit')
      {{-- Create Gpage pop ups--}}

      @includeif('layouts.create_Gpage_pop_ups')
    @endif
  @endsection

{{-- section end--}}

{{-- footer Start--}}
  @section('footer_content_1')
  @includeif('layouts.footer_C')
  @endsection
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')

    @if ($pass === 'edit')
      {{--forms js Scripts --}}
      @includeif('layouts.create_js')
    @endif

    @if ($pass === 'preview-gpages')
      $(document).ready(function(){
           $('body').on('click', '#publish_btn', function(e) {
             var id = $(this).data('id');
             if(id != "" || id != undefined){
               bootbox.confirm({
                   message: "Are you sure want to Publish ?",
                 buttons: {
                     cancel: {
                         label: '<i class="fa fa-times"></i> Cancel'
                     },
                     confirm: {
                         label: '<i class="fa fa-check"></i> Confirm'
                     }
                 },
                 callback: function (result) {
                     if(result){
                         $.ajax({
                             type: "POST",
                             url: site_url+"/creator/publish-gpages",
                             headers: {
                                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                             },
                             data: {id: id},
                             success: function(res){
                                var data = jQuery.parseJSON(res);
                                if(data.status){
                                 toastr.success(data.msg);                                  
                                }else{
                                 toastr.error(data.msg);
                                 /*setTimeout(function(){
                                     window.location.reload();
                                 }, 900);*/
                                }
                             }
                         });
                     }
                 }
               });
             }
           });
         })
    @endif

    @if ($pass === 'message-list')
      @includeif('layouts.inc_message_list_js')
    @endif

  @endsection
{{-- script end--}}

{{--Body  end--}}
