@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
    <hr class="featurette-divider">
    <div class="container  ">
                <div class=" mx-auto " style="max-width: 600px;">
                    <h5 class="center">Drop a feedback</h5>
                    <form id="add_feedback" class="form-signin" action="feedback" method="post">
                        @csrf
                        <span id="show_message"></span>
                    <div class="mb-3">
                        <input type="text" class="form-control {{ $errors->has('name') ? ' is-invalid' : '' }}" id="name" name="name" placeholder="Name" value="{{ old('name') }}" required="">
                        @if ($errors->has('name'))
                        <div class="invalid-feedback{{ $errors->has('name') ? ' is-invalid' : '' }}">
                            <p>{{ $errors->first('name') }}
                                <br>Valid name is required.</p>
                        </div>
                        @endif
                    </div>
                    <div class="mb-3">
                        <input type="email" class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}" id="email" name="email" ng-model="email" placeholder="work@example.com" value="{{ old('email') }}" required> 
                        @if ($errors->has('email'))
                        <div class="text-danger {{ $errors->has('email') ? ' is-invalid' : '' }}">
                            {{ $errors->first('email') }}
                        </div>
                        @endif
                    </div>
                    <div class="mb-3">
                        <textarea class="form-control{{ $errors->has('message') ? ' is-invalid' : '' }}" type="textarea" id="message" name="message" placeholder="Message" maxlength="245" rows="7">{{ old('message') }}</textarea>
                        @if ($errors->has('message'))
                        <div class="text-danger {{ $errors->has('message') ? ' is-invalid' : '' }}">
                            {{ $errors->first('message') }} <a href="log-in">log in</a>
                        </div>
                        @endif
                    </div>
                     <input type="submit" class="btn btn-primary pull-right" id="submit" name="submit" value="Submit">   
                    <!--button type="submit" id="submit" name="submit" class="btn btn-primary pull-right">Submit</button-->
                    </form>
                </div>
            </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
  <!-- For country and state selector cass start-->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/country-region-dropdown-menu/1.2.1/geodatasource-cr.min.js"></script>
  <!--cass end -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="/js/angular-contr.js"></script>
  @endsection
{{-- script end--}}

{{--Body  end--}}
