@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
    <style>
    body {
      font-size: .875rem;
    }

    .container {
         padding-right: 0; 
         padding-left: 0; 
      }

    /*
     * Sidebar
     */
     /* ---------------------------------------------------
         SIDEBAR STYLE
     ----------------------------------------------------- */

     .wrapper {
         display: flex;
         align-items: stretch;
     }

     #sidebar {
         min-width: 250px;
         max-width: 250px;
         background:#f8f9fa;
         transition: all 0.3s;
     }

     #sidebar.active {
         min-width: 80px;
         max-width: 80px;
         text-align: center;
     }

     #sidebar.active .sidebar-header h3,
     #sidebar.active .CTAs, #sidebar.active .hideOntog {
         display: none;
     }

     #sidebar.active .sidebar-header strong {
         display: block;
     }

     #sidebar ul li a {
         text-align: left;
     }

     #sidebar.active ul li a {
         padding: 20px 10px;
         text-align: center;
         font-size: 0.85em;
     }

     #sidebar.active ul li a i {
         margin-right: 0;
         display: block;
         font-size: 1.8em;
         margin-bottom: 5px;
     }

     #sidebar.active ul ul a {
         padding: 10px !important;
     }

     #sidebar.active .dropdown-toggle::after {
         top: auto;
         bottom: 10px;
         right: 50%;
         -webkit-transform: translateX(50%);
         -ms-transform: translateX(50%);
         transform: translateX(50%);
     }

     #sidebar .sidebar-header {
         padding: 20px;
     }

     #sidebar .sidebar-header strong {
         display: none;
         font-size: 1.8em;
     }

     #sidebar ul.components {
         padding: 20px 0;
         border-bottom: 1px solid #47748b;
     }

     #sidebar ul li a {
         padding: 10px;
         font-size: 1.1em;
         display: block;
     }

     #sidebar ul li a:hover {
         color: #7386D5;
         background: #fff;
     }

     #sidebar ul li a i {
         margin-right: 10px;
     }

     #sidebar ul li.active>a,
     a[aria-expanded="true"] {
         color: #fff;
         background: #6d7fcc;
     }

     a[data-toggle="collapse"] {
         position: relative;
     }

     .dropdown-toggle::after {
         display: block;
         position: absolute;
         top: 50%;
         right: 20px;
         transform: translateY(-50%);
     }

     ul ul a {
         font-size: 0.9em !important;
         padding-left: 30px !important;
         background: #6d7fcc;
     }

     ul.CTAs {
         padding: 20px;
     }

     ul.CTAs a {
         text-align: center;
         font-size: 0.9em !important;
         display: block;
         border-radius: 5px;
         margin-bottom: 5px;
     }

     a.download {
         background: #fff;
         color: #7386D5;
     }

     a.article,
     a.article:hover {
         background: #6d7fcc !important;
         color: #fff !important;
     }

     /* ---------------------------------------------------
         MEDIAQUERIES
     ----------------------------------------------------- */

     @media (max-width: 768px) {
         #sidebar {
             min-width: 80px;
             max-width: 80px;
             text-align: center;
             margin-left: -80px !important;
         }
         .dropdown-toggle::after {
             top: auto;
             bottom: 10px;
             right: 50%;
             -webkit-transform: translateX(50%);
             -ms-transform: translateX(50%);
             transform: translateX(50%);
         }
         #sidebar.active {
             margin-left: 0 !important;
         }
         #sidebar .sidebar-header h3,
         #sidebar .CTAs {
             display: none;
         }
         #sidebar .sidebar-header strong {
             display: block;
         }
         #sidebar ul li a {
             padding: 20px 10px;
         }
         #sidebar ul li a span {
             font-size: 0.85em;
         }
         #sidebar ul li a i {
             margin-right: 0;
             display: block;
         }
         #sidebar ul ul a {
             padding: 10px !important;
         }
         #sidebar ul li a i {
             font-size: 1.3em;
         }
         #sidebar {
             margin-left: 0;
         }
         #sidebarCollapse span {
             display: none;
         }
         .hideOntog {
                  display: none;
              }
     }

     /* ---------------------------------------------------
         MEDIAQUERIES end
     ----------------------------------------------------- */

    /*
     * Content
     */
     /* ---------------------------------------------------
         CONTENT STYLE
     ----------------------------------------------------- */

     #content {
         width: 100%;
         padding: 20px;
         min-height: 100vh;
         transition: all 0.3s;
     }

    [role="main"] {
      padding-top: 48px; /* Space for fixed navbar */
    }

    /*
     * Navbar
     */

    .form-control-dark {
      color:#fff;
      background-color: rgba(255, 255, 255, .1);
      border-color: rgba(255, 255, 255, .1);
    }

    .form-control-dark:focus {
      border-color: transparent;
      box-shadow: 0 0 0 3px rgba(255, 255, 255, .25);
    }


    .nav-scroller {
      position: relative;
      z-index: 2;
      height: 2.75rem;
      overflow-y: hidden;
    }

    .nav-scroller .nav {
      display: -ms-flexbox;
      display: flex;
      -ms-flex-wrap: nowrap;
      flex-wrap: nowrap;
      padding-bottom: 1rem;
      margin-top: -1px;
      overflow-x: auto;
      text-align: center;
      white-space: nowrap;
      -webkit-overflow-scrolling: touch;
    }

    .nav-scroller .nav-link {
      padding-top: .75rem;
      padding-bottom: .75rem;
      font-size: .875rem;
    }
    /*
     * Utilities
     */

    .border-top { border-top: 1px solid #e5e5e5; }
    .border-bottom { border-bottom: 1px solid #e5e5e5; }

    /*
    *hide angular ex
    */
    [ng\:cloak], [ng-cloak], .ng-cloak {
          display: none;
        }


    </style>
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
     <div class="wrapper" ng-app="app"  ng-controller='qr-code-Gen-cntrlr'>
          <div class="nav-scroller py-1 mb-2">
            <!--
            <nav class="nav nav-masthead justify-content-center">
                <a href="More-service"><button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('create')">Create a page for your product</button></a>
                <a href="Qr-code-generator">
                    <button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('con')">Qr code generator</button>
                </a>
                <a href="Select-package"><button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('pricin')">Pricing</button></a>
                <a href="Dynamic-Pages"><button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('Dynamic')">Dynamic Qr code</button></a>
            </nav>
            -->
          </div>
        <!-- Sidebar  -->
        <nav id="sidebar" class="">
            <div class="sidebar-header">
                <h3>Select Type</h3>
                <strong>Qr code</strong>
            </div>

            <ul class="list-unstyled components">
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('ulr')">
                      <i class="fas fa-globe-africa"></i> <span class="hideOntog">Url</span>  <span class="sr-only">(current)</span>
                  </button>
              </li>
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('con')">
                      <i class="far fa-id-card"></i> <span class="hideOntog">Contact/Business card</span> 
                  </button>
              </li>
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('ema')">
                      <i class="far fa-envelope-open"></i> <span class="hideOntog">Email</span> 
                  </button>
              </li>
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('sms')">
                      <i class="far fa-comment-alt"></i> <span class="hideOntog">SMS</span> 
                  </button>
              </li>
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('wif')">
                      <i class="fas fa-wifi"></i> <span class="hideOntog">Wifi</span> 
                  </button>
              </li>
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('cal')">
                      <i class="fas fa-calendar-plus"></i> <span class="hideOntog">Calendar/Events</span> 
                  </button>
              </li>
              <!--li class="nav-item">
                <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('geo')">
                  <i class="fas fa-map-marker-alt"></i>
                  Geolocation
                </button>
              </li-->
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('pho')">
                      <i class="fas fa-phone"></i> <span class="hideOntog">Phone number</span> 
                  </button>
              </li>
              <li class="nav-item">
                  <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('tex')">
                      <i class="far fa-file-alt"></i> <span class="hideOntog">Text</span> 
                  </button>
              </li>
            </ul>

            <ul class="list-unstyled CTAs">
                <li>
                </li>
                <li>
                </li>
            </ul>
        </nav>

        <!-- Page Content  -->
        <div id="content">

            <nav class="navbar navbar-expand-lg navbar-light bg-light">
                <div class="container-fluid">
                  <button type="button" id="sidebarCollapse" class="btn bg-dark">
                      <i class="fas fa-align-left text-light"></i>
                      <!-- <i class="fas fa-align-left"></i> -->
                      <span></span>
                  </button>
                </div>
            </nav>

            <div class="row">

                <div class="col-md-8 order-md-1" ng-init="getHTML('{!! !empty(session('form_type')) ? session('form_type') : '' !!}')">
                   @includeif('layouts.html_url')
                   @includeif('layouts.html_contact')
                   @includeif('layouts.html_email')
                   @includeif('layouts.html_sms')
                   @includeif('layouts.html_wifi')
                   @includeif('layouts.html_calendar')
                   @includeif('layouts.html_phone')
                   @includeif('layouts.html_text')
                </div>
                
                <div class="col-md-4 order-md-2 mb-4 ">

                    <div class="p-1"><img class="mb-3 w-100" src="{{url('/public/')}}/img/qrcodes/{!! !empty(session('img_file')) ? session('img_file') : 'gfects_qrcode.png' !!}"></div>
                    
                    <div class="p-3">
                      <p><small class="text-muted">Always test code by scanning your new Qr code before downloading it.</small></p>
                      <p>
                        <strong>Image size</strong> 
                        <!--button type="button" class="btn btn-outline-success">200px</button>
                        <button type="button" class="btn btn-outline-success">300px</button>
                        <button type="button" class="btn btn-outline-success">400px</button-->
                        <button type="button" class="btn btn-outline-success">500px</button>
                      </p>
                      <nav aria-label="breadcrumb">
                        <p><strong>Image format</strong>
                          <i class="breadcrumb d-inline">
                            <span class="breadcrumb-item"><a href="#"> PNG </a></span>
                          </i>
                        </p>
                        @if (session('img_file'))
                        <p><a class="btn btn-warning" href="/public/img/qrcodes/{{session('img_file')}}" title="Qr code" download>Download</a></p>
                        @else
                            <p><button  class="btn btn-warning" disabled>Download</button></p>
                        @endif
                      </nav>
                    </div>
                  </div>
                </div>

                <div class="col-md-8 order-md-3 mb-4" style="margin-top:20px;">
                  <div class="">
                      <div class="">
                          <h5 class="">Need a Qr code scanner?</h5>
                          <p class="lead">You can download one of our Qr code scanner apps to scan your generated Qr code.</p>
                      </div>
                      <div class="mt-3 text-center">
                          <a href="G-tos"><img class="rounded mx-auto d-inline" src="{{url('/public/img/Gtos-icon-2.png')}}" alt="G-tos logo" width="100"></a>
                          <a href="G-scan"><img class="rounded mx-auto d-inline" src="{{url('/public/img/G-scan-icon-2.png')}}" alt="G-scan logo" width="100"></a>
                      </div>
                  </div>
                  <!--
                  <div class="jumbotron p-3 p-md-5 text-white rounded bg-dark">
                    <div class="px-0">
                      <h1 class="display-4 font-italic">Create a page for your product</h1>
                      <p class="lead my-3">Welcome to Gfects, we develop this new service for business to be able to publish an awesome and interactive page for their customers to quickly find useful information about their products.</p>
                      <p class="lead mb-0"><a href="More-service" class="text-white font-weight-bold">Continue reading...</a></p>
                    </div>
                  </div>
                  -->
                </div>

            
        </div>
    </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
    <!-- Custom styles for this template -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="{{url('/public/js/angular-contr.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#sidebarCollapse').on('click', function () {
                $('#sidebar').toggleClass('active');
            });
        });
    </script>
  @endsection
{{-- script end--}}

{{--Body  end--}}
