@extends('layouts.layout')

{{-- head Start--}}
@section('meta_description'){{$meta_description}}@endsection
@section('title'){{$title}}@endsection
@section('more_css_style')
    <style>
        .sidepopup-switch{padding:7px; line-height:34px;    background: linear-gradient(90deg,#2e6184, #5182a0);}
        .sidepopup{background: linear-gradient(90deg,#2e6184, #5182a0); height:100%; z-index:3;}
        .sidepopup.on{transition: all 0.3s ease;}
        .sidepopup.off{left:-350px; transition: all 0.3s ease;}
        .trigger-nav{list-style:none; margin: 0; padding: 5px 10px;display: flex; justify-content: space-between;}
        .trigger-nav li{display: inline-block; text-align: center;}
        .trigger-nav li a{color:#fff; font-size: 12px; display: block; text-align: center}
        .trigger-nav li a img{height: 18px; margin-right: 3px}
        .trigger-nav li a {position: relative}
        .trigger-nav li a i.flag{position: absolute; top:-5px; right:-20px; background: #f05a28; padding: 2px; color:#fff; border-radius: 3px; width: 16px; height: 16px; text-align: center; line-height: 12px}
        @media (min-width: 768px)
        {
            #sidetoggle
            {
                display:none;
            }
        }
        @media (max-width: 768px)
        {
            #panel
            {
                display:none;
            }
        }

    </style>
@endsection
@section('Google_adsense')
    @includeif('layouts.googleadsense')
@endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
{{-- top --}}
@section('section_content_top')
@endsection

{{-- Middle --}}
@section('section_content')
    <div class="container app sidebar-mini rtl pace-done sidenav-toggled">
        <!-- Navbar-->
        <header class="app-header" style="background: url('{{asset('/public/assets_web/img/bannerbg.png')}}'); height: 150px">
            <!-- Navbar Right Menu-->
        </header>
        <div class="row">
            <div class="col-md-4 order-md-1  sidepopup on pb-3 mb-3" style="padding-top: 60px">

                <div  class="w-100" style="position: absolute; top:-30px; left:7px; color:#fff">
                    <div>

                    </div>
                    <table class="no">
                        <tbody>
                        <tr>
                            <td class="d-flex flex-row bd-highlight mb-3">
                                <div class="p-2 bd-highlight">
                                    <img src="<?=Auth::user()->profile_picture?Auth::user()->profile_picture:asset('/public/assets_web/img/1.jpg')?>" style="border-radius: 4px; width: 60px; height: 60px;  border:2px solid #224099"/>
                                </div>
                                <div class="bd-highlight pl-2 pt-3 text-white">
                                    <b style="text-shadow: 2px 2px 4px #000000;"><?=Auth::user()->username?></b>
                                    <br>
                                    <p>
                                        <?php
                                        if(Auth::user()->role == 2) {
                                            $account_type = \App\UserDetails::where('user_id',Auth::user()->id)->first()->account_type;
                                        }else{
                                            $account_type = 0;
                                        }
                                        ?>
                                        @if($account_type == 1)
                                            <span>Publisher</span>
                                        @elseif($account_type == 2)
                                            <span>Agency</span>
                                        @elseif($account_type == 3)
                                            <span>Business</span>
                                        @else
                                            <span>{{$account_type = 'user'}}</span>
                                    @endif

                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>

                <ul class="trigger-nav">
                    <li>
                        <u><a href="{{url('user/home')}}">
                            <span>Home</span>
                        </u></a>
                    </li>
                    @if(!($account_type === 'user'))
                        <li>
                            <u><a href="{{url('user/'.$user_id.'/'.Auth::user()->username.'/gpages')}}">
                                <span>Gpages <i class='flag'>{{$gpages_list?count($gpages_list):0}}</i> </span>
                            </u></a>
                        </li>
                    @endif
                    <li>
                        <u><a href="{{url('user/activities')}}">
                            <span>Activities </span>
                        </u></a>
                    </li>
                    <li>
                        <u><a href="{{url('user/info')}}">
                            <span>Setting</span>
                        </u></a>
                    </li>
                </ul>
                <hr>
                <h5 style="color:#fff; padding: 5px 15px; font-size: 13px; margin-bottom: 0">
                    @if(Auth::user()->state)
                        {{Auth::user()->state.', '}}
                    @endif
                    {{Auth::user()->country}}
                </h5>
                <div class="d-flex justify-content-between">
                    <h5 style="color:#fff; padding: 5px 15px; font-size: 13px">
                        <span>Member Since: {{date('M d, Y',strtotime(Auth::user()->created_at))}}</span>
                    </h5>
                    <button id="sidetoggle" type="button" class="btn dropdown-toggle dropdown-toggle-split text-white text-right" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <span class="sr-only">Toggle Dropdown</span>
                    </button>
                </div>
                <hr>
                <div id="panel">
                    <div class="mb-3 text-white" >
                        <Div class="d-flex justify-content-between bg-transparent pl-3 pr-4">
                            <div>
                                <h6 class="my-0"><a href="{{url('user/'.$user_id.'/'.Auth::user()->username.'/gpages')}}" class="text-white">Gpages </a></h6>
                            </div>
                            <span>{{$gpages_list?count($gpages_list):0}}</span>
                        </Div>
                        @if(!($account_type === 'user'))
                            <Div class="d-flex justify-content-between bg-transparent pl-3 pr-4">
                                <div>
                                    <h6 class="my-0">Vitalized</h6>
                                </div>
                                <span>{{abs($total_like - $total_unlike)}}</span>
                            </Div>
                            <Div class="d-flex justify-content-between bg-transparent pl-3 pr-4">
                                <div>
                                    <h6 class="my-0">Comments</h6>
                                </div>
                                <span>{{$total_comments?$total_comments:0}}</span>
                            </Div>
                            <Div class="d-flex justify-content-between bg-transparent pl-3 pr-4">
                                <div>
                                    <h6 class="my-0">Followers</h6>
                                </div>
                                <span>{{$followers}}</span>
                            </Div>
                        @endif
                        <Div class="d-flex justify-content-between bg-transparent pl-3 pr-4">
                            <div>
                                <h6 class="my-0">Last Seen</h6>
                            </div>
                            <span>{{$time_ago}}</span>
                        </Div>
                    </div>


                    <div style="padding: 0 25px; margin-top: 40px">
                        <div class="row">
                            @if(Auth::check())
                                <div class="col-6"><a href="{{url('user/messageList/')}}" class="btn btn-primary" style="display: block">Message</a></div>
                                <div class="col-6">
                                    <a href="{{url('user/logout')}}" class="btn btn-success" style="display: block">Logout</a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-8 order-md-2 mt-1 row">
                <?php
                $data =
                    [
                        'pass' => $pass
                    ];
                ?>
                @includeif('layouts.inc_userHome_Display',$data)
            </div>
        </div>

    </div>
@endsection

{{-- bottom for pop ups--}}
@section('section_content_3')
@endsection

{{-- section end--}}

{{-- footer Start--}}
@section('footer_content_1')
    @includeif('layouts.footer_C')
@endsection
{{-- footer end --}}

{{-- Scripts start--}}
@section('ext_scripts')
    @includeif('users.inc.footer_js_lib')
    @if ($pass === 'activities')
        <script type="text/javascript">
            $(document).ready(function(){
                $('body').on('click', '.delete_activity_btn', function(e) {
                    var id = $(this).data('id');
                    if(id != "" || id != undefined){
                        bootbox.confirm({
                            message: "Are you sure want to delete ?",
                            buttons: {
                                cancel: {
                                    label: '<i class="fa fa-times"></i> Cancel'
                                },
                                confirm: {
                                    label: '<i class="fa fa-check"></i> Confirm'
                                }
                            },
                            callback: function (result) {
                                $.ajax({
                                    type: "POST",
                                    url: site_url+"/user/delete-activity",
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    data: {id:id},
                                    success: function(res){
                                        var data = jQuery.parseJSON(res);
                                        if(data.status){
                                            toastr.success(data.msg);
                                            setTimeout(function(){
                                                window.location.reload(true);
                                            }, 900);

                                        }else{
                                            toastr.error(data.msg);
                                            setTimeout(function(){
                                                // window.location.reload(true);
                                            }, 900);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
                // datatable
                var t = $('.datatable').DataTable();
                t.on( 'order.dt search.dt', function () {
                    t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                        cell.innerHTML = i+1;
                    } );
                } ).draw();
            });
        </script>
    @elseif ($pass === 'profile_info')
        <script type="text/javascript">
            function readURL(input,id,preview_id){
                var max_size = 1048576 * 4;
                var ext = input.files[0]['name'].substring(input.files[0]['name'].lastIndexOf('.') + 1).toLowerCase();
                if(ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg"){
                }else{
                    //alert("Please upload only png|jpg|jpeg image.");
                    toastr.warning('Please upload only png, jpg, jpeg image.');
                    $('#'+id).val('');
                    return false;
                }
                if(input.files[0].size >max_size){
                    //alert("File size should be equal or less than 4MB");
                    toastr.warning('File size should be equal or less than 4MB');
                    $('#'+id).val('');
                    return false;
                }
                if (input.files && input.files[0] && (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")){
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#'+preview_id).attr('src', e.target.result);
                    }

                    reader.readAsDataURL(input.files[0]);
                }else{
                    //$('#img').attr('src', '/assets/no_preview.png');
                }
            }

        </script>
    @elseif ($pass === 'message-list')
        @includeif('layouts.inc_messages_js')
    @else
        @includeif('layouts.inc_userPage_js')
    @endif
    <script>
        $(document).ready(function(){
            $("#sidetoggle").click(function(){
                $("#panel").slideToggle("slow");
            });
        });
    </script>
@endsection
{{-- script end--}}

{{--Body  end--}}
