<?php
$product_id = session()->get('product_id');
$product_name =session()->get('product_name');
$url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
$url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
    <!DOCTYPE html>
<html lang="en">
@include('users.inc.head')
<body class="app sidebar-mini rtl pace-done sidenav-toggled">
<div class="mask"></div>
@include('users.inc.side_pop_up')
<!-- Navbar-->
<header class="app-header">

    <h4 class="header-title">Buy It</h4>
    <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
        <img src="{{asset('/public/assets_web/img/icons/menu.png')}}" height="16"/>
    </a>
    <!-- Navbar Right Menu-->
    @include('users.inc.nav_right_menu')
</header>
<!-- Sidebar menu-->
<div class="app-sidebar__overlay" data-toggle="sidebar"></div>
<aside class="app-sidebar">
    @include('users.inc.app_side_bar')
</aside>
<main class="app-content">
    <?php
    $this->product_model = new App\product;
    $total_likes = $this->product_model->get_total_likes_by_page_id($product_id);
    $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($product_id);
    $total_comments = $this->product_model->get_total_comments_by_page_id($product_id);
    if(Auth::check()){
        $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$product_id);
        if(!$like_status){
            $like_status = 'new';
        }
    }else{
        $like_status = 0;
    }
    ?>
    <div class="widget">
        <table>
            <tr>
                <td><i class="fa fa-thumbs-up"></i></td>
                <td>
                    <p>{{$total_likes}}</p>
                    <h4><a href="#" class="like_action" data-page_id="{{$product_id}}" data-like_status="{{$like_status}}">Likes</a></h4>
                </td>
                <td><i class="fa fa-thumbs-down"></i></td>
                <td>
                    <p>{{$total_unlikes}}</p>
                    <h4><a href="#" class="dislike_action" data-page_id="{{$product_id}}" data-like_status="{{$like_status}}">Unlikes</a></h4>
                </td>
                <td><i class="fa fa-plus"></i></td>
                <td>
                    <p>1.3K</p>
                    <h4><a href="#">Add</a></h4>
                </td>
                <td><i class="fa fa-share-alt"></i></td>
                <td>
                    <p>0</p>
                    <h4><a href="#">Share</a></h4>
                </td>
                <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                <td>
                    <p>{{$total_comments}}</p>
                    <h4><a class="comment_action" href="#" data-page_id="{{$product_id}}">Comments</a></h4>
                </td>
            </tr>
            <tr>
                <td colspan="3" class="text-center">
                    <h3>By {{$gpage->username}}</h3>
                </td>
                <td colspan="4" class="text-center">
                    <h3>Created At {{date('M d, Y',strtotime($gpage->created_at))}}</h3>
                </td>
                <td colspan="3" class="text-center">
                    <h3>Last Updated {{date('M d, Y',strtotime($gpage->updated_at))}} </h3>
                </td>
            </tr>
        </table>
    </div>
    <div class="row">
        <div class="col-md-7">
            <h4 class="text-center">Buy Online</h4>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th>Store</th>
                        <th>Image</th>
                        <th>Item</th>
                        <th>Price</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(count($gpages_list))
                        <?php
                        $image = json_decode($gpage->image);
                        ?>
                        <tr>
                            <td>{{$gpage->manufactured_by}}</td>
                            <td><img src="{{asset('/public/'.$image[0]->url)}}" height="40"/></td>
                            <td>{{$gpage->name}}</td>
                            <td>${{$gpage->price}}</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>


        </div>
        <div class="col-md-5">
            @if(count($gpages_list))
                @foreach($gpages_list as $key=>$value)
                    <?php
                    $image = json_decode($value->image);
                    $this->product_model = new \App\Product;
                    $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                    $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                    $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                    $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                    $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                    $page_name = preg_replace('/-+/', '-', $page_name);
                    if(Auth::check()){
                        $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                        if(!$like_status){
                            $like_status = 'new';
                        }
                    }else{
                        $like_status = 0;
                    }
                    ?>
                    <div class="more-product">
                        <div class="more-product-info">
                            @if(isset($image[0]->url))
                                <div class="more-product-img"><img src="{{asset('/public/'.$image[0]->url)}}"/></div>
                            @else
                                <div class="more-product-img"><img src="{{asset('/public/')}}"/></div>
                            @endif

                            <p><a target="_blank" href="{{url('product/'.strtolower($page_name).'/about/'.$value->id)}}">{{$value->description}}</a></p>
                        </div>
                        <div class="more-product-assets">
                            <table>
                                <tr>
                                    <td style='font-weight: bold'>
                                        <a href="{{url('user/publisher-dashboard/'.$value->user_id)}}" target="_blank">
                                            <img src="{{$value->profile_picture}}"/> {{$value->username}}
                                        </a>
                                    </td>
                                    <td><i class="fa fa-thumbs-up"></i></td>
                                    <td>
                                        <p>{{$total_likes}}</p>
                                        <h4><a href="#" class="like_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status}}">Likes</a></h4>
                                    </td>
                                    <td><i class="fa fa-thumbs-down"></i></td>
                                    <td>
                                        <p>{{$total_unlikes}}</p>
                                        <h4>
                                            <a href="#" class="dislike_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status}}"> Unlikes</a>
                                        </h4>
                                    </td>
                                    <td><i class="fa fa-eye"></i></td>
                                    <td>
                                        <p>{{$value->view_count}}</p>
                                        <h4><a href="javascript::void">Views</a></h4>
                                    </td>
                                    <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                                    <td>
                                        <p>{{$total_comments}}</p>
                                    <!-- <h4><a target="_blank" class="comment_action" data-page_id="{{$value->id}}" href="#">Comments</a></h4> -->
                                        <h4><a class="" href="{{url('product/'.$url_name.'/comment/'.$value->id)}}">Comments</a></h4>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>

</main>
<!-- reply model start here -->
<div class="modal fade" id="comment_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h4 class="modal-title w-100 font-weight-bold">Gpages Comment</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="comment_model">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" name="comment_frm" id="comment_frm">
                <input type="hidden" name="page_id" id="page_id">
                <div class="modal-body mx-3">
                    <div class="md-form">
                        <i class="fas fa-pencil prefix grey-text"></i>
                        <label data-error="wrong" data-success="right" for="form8">Message</label>
                        <textarea type="text" id="message"  name="message" class="md-textarea form-control" rows="4"></textarea>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <input class="btn btn-unique" type="submit" value="Send"> <i class="fas fa-paper-plane-o ml-1"></i></button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- reply model end here -->
@include('users.inc.footer_js_lib')
<!-- Essential javascripts for application to work-->
<script type="text/javascript">
    $(document).ready(function(){
        //close model by id
        $('body').on('click', '.close_btn', function(e) {
            var id = $(this).data('model_id');
            $("#"+id).modal("toggle");
        });
        //message reply form submit
        $('form[id="comment_frm"]').validate({
            rules: {
                message: 'required',
            },
            messages: {
                message: 'Please enter your comment',
            },
            submitHandler: function(form) {
                //form.submit();
                frm = $('#comment_frm');
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-comment",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: frm.serialize(),
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        $("#comment_model").modal("toggle");
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
        //open comment model
        $('body').on('click', '.comment_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                $("#page_id").val(page_id);
                $("#message").val('');
                setTimeout(function(){
                    $("#comment_model").modal("toggle");
                }, 50);
            }
        });
        $('body').on('click', '.like_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'yes'){
                    toastr.success('You have already like this page!');
                    return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id
                        ,_token:@csrf_field
                        , like_status:'yes'},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
        $('body').on('click', '.dislike_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'no'){
                    toastr.success('You have already unlike this page!');
                    return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id, like_status:'no'},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
        $('body').on('click', '.fllow_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-fllows",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
    })
</script>
</body>
</html>
