<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
    $this->product_model = new \App\Product;
    $this->comment_model = new \App\ProductComment;
?>
<!DOCTYPE html>
<html lang="en">
  @include('users.inc.head')
    <style>    
    .comment-body ul li>table tr td img{    width: 50px;
      height: 50px;
      border-radius: 50%;
      margin-right: 15px;
    }
    .comment-body ul li>table{
      width:100%;}
    .comment-body ul li{display: block; padding: 15px 0;}
    .comment-body ul{
      margin: 0px;
      padding: 0px;
      list-style: none;
      margin-bottom: 25px;}
    .comment-body ul li>table tr:first-of-type td:first-child {
      width: 50px;
    }

    .comment-body ul li>table tr td {
      vertical-align: top;
    }
    .comment-body ul li.sub-comments {
      padding-left: 60px;
    }
    .comment-body ul li+li {
      border-top: 1px solid #ececec;
    }
    .comment-container{padding-top: 25px;}
    .comment-header{margin: 13px 0px;
      font-size: 20px;
      font-weight: 600;
    }
  </style>
    <body class="app sidebar-mini rtl pace-done sidenav-toggled">
        <div class="mask"></div>
      @include('users.inc.side_pop_up')  
    
        <!-- Navbar-->
        <header class="app-header">
            <h4 class="header-title">Comments</h4>
            <!-- Sidebar toggle button-->
            <a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
                <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
            </a>
            <!-- Navbar Right Menu-->
       @include('users.inc.nav_right_menu')
    
        </header>
        <!-- Sidebar menu-->
        <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
        <aside class="app-sidebar">
      @include('users.inc.app_side_bar')
    </aside>
        <main class="app-content">
            <div class="row">
                <div class="col-md-4 offset-md-1">
                    Enter Comment Here
                    <div style="padding: 10px 0 0 0">
                         <textarea name="message" id="message_new" cols="25" rows="4"></textarea>
                        <a href="#" class="btn btn-primary comment_reply_action" style="margin-top: -80px;padding: 5px 10px 5px 10px;" data-page_id="{{$selected_page_id}}" data-comment_id="new" data-type="parent">Send</a>
                    </div>
                    @if(count($comment_list))
                        <?php $parent_id = '' ?>
                        @foreach($comment_list as $key=>$comment)
                            <?php  
                                $total_comment = $this->comment_model->get_total_comments_by_parent_id($comment->serial_number);
                                $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($comment->serial_number);
                                $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($comment->serial_number);
                                if(Auth::check()){
                                  $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id,$comment->serial_number);
                                  if(!$like_status){
                                    $like_status = 'new';
                                  }
                                }else{
                                  $like_status = 0;
                                }
                                $time_ago = App\Helpers\Common_func::time_ago_int($comment->created_at); 
                                $time_ago_arr = explode(" ",$time_ago);
                                $parent_have_child = 0;
                            ?>
                            <div class="comment-container" style='margin-top: 0; padding-top: 0; border-bottom: 1px solid #ddd'>
                                @if(!$comment->parent_id)
                                    <div class="comment-body">
                                        <ul style="margin-bottom: 5px">
                                            <li>
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <img src="{{$comment->sender_picture}}" alt="user"/>
                                                            <a href="#" class="link user-name" style='font-size: 12px; color:#333'>{{$comment->name}}</a>
                                                        </td>
                                                        <td>
                                                            <p style="margin: 0px; color:#444; max-height: 63px; overflow: hidden; text-overflow: ellipsis">{{$comment->comment}}</p>
                                                           <!--  <a href="#" style="background: #e19e39; padding: 3px; color:#fff; font-size: 10px; border-radius: 3px;">Show All</a> -->
                                                            <div class="more-product-assets" style="background: #f1f1f2; border:0; margin-top: 5px">
                                                                <table>
                                                                    <tr>
                                                                        <td style="border:0">
                                                                            <i class="fa fa-thumbs-up"></i>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <p>{{ $total_com_likes?$total_com_likes:0}}</p>
                                                                            <h4>
                                                                                <a href="#" class="comment_like_action" data-comment_id="{{$comment->serial_number}}" data-like_status="{{$like_status}}">Likes</a>
                                                                            </h4>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <i class="fa fa-thumbs-down"></i>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <p>{{$total_com_unlikes?$total_com_unlikes:0}}</p>
                                                                            <h4>
                                                                                <a href="#" class="comment_dislike_action" data-comment_id="{{$comment->serial_number}}" data-like_status="{{$like_status}}">Unlikes</a>
                                                                            </h4>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <i class="fa fa-comment" style="color:#1073b8"></i>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <p>{{$total_comment?$total_comment:0}}</p>
                                                                            <h4>
                                                                               <!--  <a href="#" class="comment_reply_action" data-page_id="{{$comment->product_id}}" data-comment_id="{{$comment->serial_number}}" >Reply</a> -->
                                                                                 <a href="#">Reply</a>
                                                                            </h4>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <i class="fa fa-calendar"></i>
                                                                        </td>
                                                                        <td style="border:0">
                                                                            <p>{{$time_ago_arr?$time_ago_arr[0]:0}}</p>
                                                                            <h4>
                                                                                <a href="javascript::void">{{$time_ago_arr?$time_ago_arr[1]:''}}</a>
                                                                            </h4>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div style="padding: 10px 0 0 0">
                                                                <textarea name="message" id="message_{{$comment->serial_number}}" cols="25"></textarea>
                                                                <a class="btn btn-primary comment_reply_action" style="margin-top: -40px;padding: 5px 10px 5px 10px;" data-page_id="{{$comment->product_id}}" data-comment_id="{{$comment->serial_number}}" data-type="child">Send</a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </li>
                                        </ul>
                                    </div>
                                @endif
                                @foreach($comment_list as $key=>$child)
                                    @if(!empty($child->parent_id) && $child->parent_id == $comment->serial_number)
                                        <?php
                                            $time_ago = App\Helpers\Common_func::time_ago_int($child->created_at); 
                                            $time_ago_arr = explode(" ",$time_ago);
                                            $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($child->serial_number);
                                            $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($child->serial_number);
                                            if(Auth::check()){
                                              $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id,$child->serial_number);
                                              if(!$like_status){
                                                $like_status = 'new';
                                              }
                                            }else{
                                              $like_status = 0;
                                            }
                                            $parent_have_child = 1;
                                        ?>
                                        <div class="comment-container" style='margin-top: 0; padding-top: 0; padding-left: 65px'>
                                            <div class="comment-body">
                                                <ul style="margin-bottom: 5px">
                                                    <li style="margin-top: 0">
                                                        <table>
                                                            <tr>
                                                                <td>
                                                                    <img src="{{$child->sender_picture}}" alt="user"/>
                                                                    <a href="#" class="link user-name" style='font-size: 12px; color:#333'>{{$child->name}}</a>
                                                                </td>
                                                                <td style="border-radius: 6px;background: #0872b9; padding: 10px">
                                                                    <p style="margin: 0px; color:#fff; max-height: 63px; overflow: hidden; text-overflow: ellipsis">{{$child->comment}}</p>
                                                                    <!-- <a href="#" style="background: #e19e39; padding: 3px; color:#fff; font-size: 10px; border-radius: 3px;">Show All</a> -->
                                                                    <div class="more-product-assets" style="background: #f1f1f2; border:0; margin-top: 5px">
                                                                        <table>
                                                                            <tr>
                                                                                <td style="border:0">
                                                                                    <i class="fa fa-thumbs-up"></i>
                                                                                </td>
                                                                                <td style="border:0">
                                                                                    <p>{{$total_com_likes?$total_com_likes:0}}</p>
                                                                                    <h4>
                                                                                    <a href="#" class="comment_like_action" data-comment_id="{{$child->serial_number}}" data-like_status="{{$like_status}}">Likes</a>
                                                                                    </h4>
                                                                                </td>
                                                                                <td style="border:0">
                                                                                    <i class="fa fa-thumbs-down"></i>
                                                                                </td>
                                                                                <td style="border:0">
                                                                                    <p>{{$total_com_unlikes?$total_com_unlikes:0}}</p>
                                                                                    <h4>
                                                                                        <a href="#" class="comment_dislike_action" data-comment_id="{{$child->serial_number}}" data-like_status="{{$like_status}}">Unlikes</a>
                                                                                    </h4>
                                                                                </td>
                                                                                <!-- <td style="border:0">
                                                                                    <i class="fa fa-comment" style="color:#1073b8"></i>
                                                                                </td> -->
                                                                                <!-- <td style="border:0">
                                                                                    <p>12</p>
                                                                                    <h4>
                                                                                        <a href="#">Reply</a>
                                                                                    </h4>
                                                                                </td> -->
                                                                                <td style="border:0">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </td>
                                                                                <td style="border:0">
                                                                                    <p>{{$time_ago_arr?$time_ago_arr[0]:0}}</p>
                                                                                    <h4>
                                                                                        <a href="javascript::void">{{$time_ago_arr?$time_ago_arr[1]:''}}</a>
                                                                                    </h4>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                                @if(!$comment->parent_id && $parent_have_child)
                                   <!--  <div style="margin-bottom: 10px;">
                                        <textarea name="message" id="message_{{$comment->serial_number}}" cols="20" style="margin-left: 130px;"></textarea>
                                        <a class="btn btn-primary comment_reply_action" style="margin-top: -38px;padding: 5px 10px 5px 10px;margin-right: -3px;" data-page_id="{{$comment->product_id}}" data-comment_id="{{$comment->serial_number}}" type="child">Send</a>
                                    </div> -->
                                @endif
                            </div>
                        @endforeach
                    @else
                    <!-- Enter Comment Here
                    <div style="padding: 10px 0 0 0">
                        <textarea name="comment" id="comment_0" cols="25" rows="4"></textarea>
                        <a href="#" class="btn btn-primary comment_reply_action" style="margin-top: -80px;padding: 5px 10px 5px 10px;" data-page_id="{{$selected_page_id}}" data-comment_id="0" data-type="parent">Send</a>
                    </div> -->
                    @endif
                </div>
                <div class="col-md-5 offset-md-2">
                    @if(count($gpages_list))
                @foreach($gpages_list as $key=>$value)
                  <?php 
                    $image = json_decode($value->image);
                    $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                    $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                    $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                    //$total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                    $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                    $page_name = preg_replace('/-+/', '-', $page_name);
                    if(Auth::check()){
                      $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                      if(!$like_status){
                        $like_status = 'new';
                      }
                    }else{
                      $like_status = 0;
                    }
                  ?>
                  <div class="more-product">
                    <div class="more-product-info">
                        <div class="more-product-img"><img src="{{asset($image[0]->url)}}"/></div>
                        <p><a href="{{url('product/'.strtolower($page_name).'/comment/'.$value->id)}}">{{$value->description}}</a></p>
                    </div>
                    <div class="more-product-assets">
                        <table>
                          <tr>
                              <td style='font-weight: bold'>
                                  <img src="{{$value->profile_picture}}"/> {{$value->username}}
                              </td>
                              <td><i class="fa fa-thumbs-up"></i></td>
                              <td>
                                  <p>{{$total_likes}}</p>
                                  <h4><a href="#" class="like_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status}}">Likes</a></h4>
                              </td>
                              <td><i class="fa fa-thumbs-down"></i></td>
                              <td>
                                  <p>{{$total_unlikes}}</p>
                                  <h4><a href="#" class="dislike_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status}}"> Unlikes</a></h4>
                              </td>
                              <td><i class="fa fa-eye"></i></td>
                              <td>
                                  <p>{{$value->view_count}}</p>
                                  <h4><a href="#">Views</a></h4>
                              </td>
                              <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                              <td>
                                  <p>{{$total_comments}}</p>
                                  <!-- <h4><a target="_blank" class="comment_action" data-page_id="{{$value->id}}" href="{{url('user/gpages-comment/'.$value->id)}}">Comments</a></h4> -->
                                  <h4><a class="" href="{{url('product/'.$url_name.'/comment/'.$value->id)}}">Comments</a></h4>
                              </td>
                          </tr>
                      </table>
                    </div>
                  </div>
                @endforeach
              @endif
                </div>
            </div>
        </main>
        <!-- Essential javascripts for application to work-->
    @include('users.inc.footer_js_lib')
    <script type="text/javascript">
        $(document).ready(function(){
          $('body').on('click', '.comment_reply_action', function(e) {
            e.preventDefault();
            if(check_login()){
              var page_id = $(this).data("page_id");
              var comment_id = $(this).data("comment_id");
              var type = $(this).data("type");
              // if(type == 'child'){
              //   var message = $("#message_"+comment_id).val().trim();
              // }else{
              //   var message = $("#message").val().trim();
              // }
              var message = $("#message_"+comment_id).val().trim();
              if(message ==undefined || message == ''){
                toastr.error('please enter message!');
                return true;
              }
              $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-comment",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data:{page_id:page_id,comment_id: comment_id,message:message,type:type},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       $("#comment_model").modal("toggle");
                       if(data.status){
                          toastr.success(data.msg);
                          $("#message_"+comment_id).val('');
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                       }else{
                          toastr.error(data.msg);
                       }
                    }
                });
            }
          });
          $('body').on('click', '.like_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'yes'){
                  toastr.success('You have already like this page!');
                  return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id, like_status:'yes'},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                          toastr.success(data.msg);
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                       }else{
                          toastr.error(data.msg);
                       }
                    }
                });
            }
          });
          $('body').on('click', '.dislike_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'no'){
                  toastr.success('You have already unlike this page!');
                  return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id, like_status:'no'},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                          toastr.success(data.msg);
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                       }else{
                          toastr.error(data.msg);
                       }
                    }
                });
            }
          });

          $('body').on('click', '.fllow_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-fllows",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                          toastr.success(data.msg);
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                       }else{
                          toastr.error(data.msg);
                       }
                    }
                  });
                }
            })
          //comment like  action
          $('body').on('click', '.comment_like_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var comment_id = $(this).data("comment_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'yes'){
                  toastr.success('You have already like this comment!');
                  return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/comment-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {comment_id:comment_id, like_status:'yes'},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                          toastr.success(data.msg);
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                       }else{
                          toastr.error(data.msg);
                       }
                    }
                });
            }
          });
          //dislike comment 
          $('body').on('click', '.comment_dislike_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var comment_id = $(this).data("comment_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'no'){
                  toastr.success('You have already unlike this comment!');
                  return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/comment-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {comment_id:comment_id, like_status:'no'},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                          toastr.success(data.msg);
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                       }else{
                          toastr.error(data.msg);
                       }
                    }
                });
            }
          });
        })
      </script>
    </body>
</html>