<?php
$product_id = session()->get('product_id');
$product_name = session()->get('product_name');
$url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
$url_name = strtolower(preg_replace('/-+/', '-', $url_name));
$this->comment_model = new \App\ProductComment;
use Hashids\Hashids;
$hashids = new Hashids();



?>

    <!DOCTYPE html>
<html lang="en">

<head>
    <meta name="description" content="">
    <!-- Open Graph Meta-->
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="">
    <link rel="icon" href="{{asset('/public/img/Gfects_icon.png')}}">
    <meta property="og:title" content="">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Gfects | {{$title}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
<!--  <script src="{{asset('/public/assets_web/js/jquery-3.2.1.min.js')}}"></script> -->
    <script src="https://code.jquery.com/jquery-latest.min.js"></script>
    <!-- Main CSS-->
    <link rel="stylesheet" type="text/css"
          href="{{asset('/public/assets_web/js/plugins/slick-1.8.1/slick/slick.css')}}">
    <link rel="stylesheet" type="text/css"
          href="{{asset('/public/assets_web/js/plugins/slick-1.8.1/slick/slick-theme.css')}}">
    <link rel="stylesheet"
          href="{{asset('/public/assets_admin/scripts/DataTables/DataTables-1.10.16/css/jquery.dataTables.css')}}">
    <link href="{{asset('/public/vendor/toastr/toastr.min.css')}}" rel="stylesheet">
    <link href="{{asset('/public/vendor/lightbox/css/jquery.lightbox.css')}}" rel="stylesheet">
    <!-- Font-icon css-->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.1/css/all.css"
          integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <link rel="stylesheet" href="{{url(asset('/public/css/product.css'))}}">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">


    <meta property="og:url" content="{{url()->full()}}"/>
    <meta property="og:type" content="website"/>
    @if(isset($gpage->name))
        <meta property="og:title" content="{{$gpage->name}}"/>
    @endif
    @if(isset($gpage->description))
        <meta property="og:description" content="{{$gpage->description}}"/>
    @endif
    @if($gpage->image)
        <?php $images = json_decode($gpage->image);
        ?>

        <meta property="og:image" content="{{asset('/public/'.$images[0]->url)}}"/>
    @endif
</head>
<script type="text/javascript">
    var site_url = "<?=url('/')?>";
</script>


<header>
    <div class="navbar-fixed">
        <nav class="productHeader">
            <div class="nav-wrapper">

                <div class="container">
                    <div class="headerMain">
                        <div class="row containHeader">
                            <div class="inlineDiv col s4">
                                <img class="productHeaderLogo"
                                     src="{{asset('/public/assets_web/img/logo_original_sm.png')}}" alt="Gfects logo">
                            </div>
                            <div class="inlineDiv searchDiv col s3 hide-on-small-only">
                                <form id="searchForm" method="post" action="{{url('/search')}}">
                                    @csrf
                                    <div class="productSearchInput row">
                                        <div class="col s10 inputSearchDiv" >
                                            <input name="q" class="searchInput" type="search" required>
                                        </div>
                                        <div class="col s2 iconSearchDiv" >
                                            {{--<i class="material-icons">search</i>--}}
                                            <i class="fas fa-search" onclick="document.getElementById('searchForm').submit();"></i>

                                        </div>

                                    </div>
                                </form>
                            </div>
                            <div class="col s1"></div>
                            <div class="col s4">
                                {{--<ul class="right hide-on-med-and-down">--}}
                                {{--<li><a href="{{url('/')}}">HOME</a></li>--}}
                                {{--<li><a href="sass.html">APPS</a></li>--}}
                                {{--<li><a href="badges.html">ACCOUNT</a></li>--}}
                                {{--</ul >--}}

                                <ul class="right hide-on-med-and-down">
                                    @if(Auth::check())
                                        @if(Auth::user()->role == 2 && Auth::user()->switch_role == 0)
                                            <li class="nav-item dropdown">
                                                <a href="#" class="dropdown-trigger" data-target="dropdown1">
                                                    Account
                                                </a>
                                                <ul id="dropdown1" class="dropdown-content">
                                                    <li>
                                                        <a href="{{  url('creator/dashboard/') }}"
                                                           class="login text-light">User Home Page</a>
                                                    </li>
                                                    <li>
                                                        <a href="{{  url('creator/dashboard') }}"
                                                           class="login text-light">Dashboard</a>
                                                    </li>
                                                </ul>
                                            </li>
                                        @elseif(Auth::user()->role == 2 && Auth::user()->switch_role == 3)
                                            <li class="nav-item"><a href="{{  url('user/dashboard') }}"
                                                                    class="login text-light">Account</a></li>
                                        @else
                                            <li class="nav-item"><a href="{{ url('user/dashboard') }}"
                                                                    class="login text-light">Account</a></li>
                                        @endif
                                    @else

                                        <li class="nav-item"><a href="{{url('/')}}" class="text-light">Home</a></li>
                                        <li class="nav-item"><a href="{{url('apps')}}" class="text-light">APSS</a></li>
                                        <li class="nav-item">
                                            <a href="{{  url('Account') }}" class="nav-register-btn text-light">
                                                ACCOUNT
                                            </a>
                                        </li>
                                        @if(Auth::check())
                                            <li class="nav-item"><a href="{{ url('logout') }}" class="login signup">Logout</a>
                                            </li>
                                        @endif
                                    @endif
                                </ul>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </nav>
    </div>
</header>

<main>
    <div class="productBannerDiv">
        <img class="productBannerImg" src="{{url(asset('/public/img/banner.jpg'))}}" alt="">
    </div>

    <div class="productMainContent">
        <?php
        $this->product_model = new App\product;
        $total_likes = $this->product_model->get_total_likes_by_page_id($product_id);
        $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($product_id);
        $total_comments = $this->product_model->get_total_comments_by_page_id($product_id);
        if (Auth::check()) {
            $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id, $product_id);
        } else {
            $like_status = 0;
        }
        $color = json_decode($gpage->color);
        $buy_url = json_decode($gpage->buy_url);
        $dim = json_decode($gpage->dimension);
        ?>
        <div class="container">
            <div class="row productMainDiv">
                <div class="col m5 s12">


                    <div class="slider">
                        <ul class="slides">
                            @if($gpage && !empty($gpage))
                                <?php
                                if (isset($gpage->image)) {
                                    $images = json_decode($gpage->image);
                                } else {
                                    $images = [];
                                }
                                ?>
                                @foreach($images as $key=>$value)
                            <li>
                                <img class="materialboxed" src="{{url(asset('/public/'.$value->url))}}"> <!-- random image -->

                            </li>
                                 @endforeach
                                @endif
                        </ul>
                    </div>

                </div>
                <div class="col m5 s12 productDetailDiv">
                    <h4 class="productTitle">
                        {{$gpage?$gpage->name:''}}
                    </h4>
                    <div class="row productStatusDiv">
                        <div class="card-footer-item col s4 colorTextTitle">

                            <a href="https://gfects.com/user/9QiVcz/kooreal" title="Open Author's page">
                                <div class="d-inline"><img src="{{$gpage->profile_picture}}"
                                                           style="border-radius: 50%;height: 15px;max-width: 15px;"> <h6
                                        class="usernameH6"> By {{$gpage->username}}</h6></div>
                            </a>
                        </div>

                        <div class="col s4 divView">
                            <span class="visspan"><i
                                    class="material-icons left  middle-indicator-text">visibility</i></span>
                            <div class="divViewCounter">
                                <h6 class="disblock">{{$gpage?$gpage->view_count:''}} Views</h6>
                            </div>
                        </div>
                        <div class="col s4 timeShareDiv">
                            <div class=" productShareDiv inlineDiv">
                                {{--<span class="spanShare">Share:</span>--}}
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{url()->full()}}"
                                   class="stretched-link"><i class="fab fa-lg fa-facebook"></i></a>
                                <a href="https://www.linkedin.com/sharing/share-offsite/?url={{url()->full()}}"
                                   class="stretched-link"><i class="fab fa-lg fa"></i></a>
                                <a href="whatsapp://send?text={{url()->full()}}" data-action="share/whatsapp/share"
                                   class="stretched-link"><i class="fab fa-lg fa-whatsapp"></i></a>
                                <a href="https://twitter.com/share?url={{url()->full()}}" class="stretched-link"><i
                                        class="fab fa-lg fa-twitter"></i></a>
                                <i class="fas fa-lg fa-copy"></i>

                            </div>
                            {{--<div  class="s2">--}}
                            {{--Created At Jul 20, 2019--}}
                            {{--</div>--}}
                            {{--<div class="inlineDiv" >--}}
                            {{--{{date('M d, Y',strtotime($gpage->updated_at))}}--}}
                            {{--</div>--}}

                        </div>

                    </div>
                    <div class="productMainPrice colorTextTitle">
                        <div class="row">
                            <div class="col s3 ">
                                <h6 class="centerPriceM"><sup
                                        class="priceSymbol">{{\App\Currencie::find($gpage->currency)->symbol}}</sup>{{$gpage?$gpage->price:''}}
                                </h6>
                                <p class="priceText">LOWEST PRICE</p>
                            </div>
                            <div class="col s3">
                                <h6 class="centerPriceM"><sup
                                        class="priceSymbol">{{\App\Currencie::find($gpage->currency)->symbol}}</sup> {{$gpage?$gpage->msr_price:''}}
                                </h6>
                                <p class="priceText"> MSRP</p>
                            </div>

                        </div>

                    </div>
                    <div class="row">
                        <a id="addpage" data-page_id="{{$gpage->id}}" class="waves-effect waves-light btn"><i
                                class="material-icons left">add</i>Add</a>
                        <a class="waves-effect waves-light btn"><i class="material-icons left">add_shopping_cart</i>Buy</a>
                    </div>
                    <div class="divCountry hite">

                        <div class="inlineDiv">BY Intel <span class="spanConurty"> <i
                                    class="fas fa-globe-americas blacktext"></i> USA</span></div>
                        <div class="inlineDiv arrowDiv">
                            <i data-page_id="{{$gpage->id}}" class="fas fa-arrow-up  like_action blacktext"></i>
                            120
                            <i data-page_id="{{$gpage->id}}" class="fas fa-arrow-down dislike_action blacktext"></i>
                        </div>
                    </div>
                    <div class="productDesc">
                        {{$gpage?$gpage->description:''}}
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top: 111px;">
                <div class="col s10">
                    <ul class="tabs tabs-fixed-width z-depth-1 ulTabsDesc">
                        @if($gpage?$gpage->how_to_use_text:'')
                            <li class="tab">
                                <a class="nav-link" href="#h2usee">How to use</a>
                            </li>
                        @endif
                        @if($gpage?$gpage->features:'')
                            <li class="tab">
                                <a class="nav-link" href="#features">Features</a>
                            </li>
                        @endif
                        <li class="tab">
                            <a class="" href="#Specs">Specs</a>
                        </li>
                    </ul>

                    <div class="pt-5" id="h2usee">
                        @if($gpage?$gpage->how_to_use_text:'')
                            <h4>How to use</h4>
                            <?=$gpage ? $gpage->how_to_use_text : ''?>
                        @endif
                    </div>
                    <div class="pt-5" id="features">
                        @if($gpage?$gpage->features:'')
                            <h4>Features</h4>
                            <?=$gpage ? $gpage->features : ''?>
                        @endif
                    </div>
                    <div class="pt-5" id="Specs">
                        <h4>Specs</h4>
                        @if(count($color))

                            <div class="row mb-3">
                                <div class="col-md-1">Color :</div>
                                <div class="col-md-1">
                                    @foreach($color as $key=>$value)
                                        <div class="pb-3">
                                            <span class="custom_button"
                                                  style="padding:2px 14px 2px 36px; background-color: <?=$value?>"></span>
                                        </div>
                                    @endforeach
                                </div>

                            </div>

                        @endif
                        <p><span
                                class="span_label">Manufactred Part No: </span>{{$gpage?$gpage->manufactured_part_no:''}}
                        </p>
                        <p><span
                                class="span_label">Weight: </span>{{$gpage?$gpage->weight:''}} {{$gpage?$gpage->unit_price:''}}
                        </p>
                        <p><span class="span_label">Height: </span>{{$dim->height}} {{$dim->type}}</p>
                        <p><span class="span_label">Width: </span>{{$dim->width}} {{$dim->type}}</p>
                        <p><span class="span_label">Length: </span>{{$dim->length}} {{$dim->type}}</p>
                        <p><span class="span_label">Grith: </span>{{$dim->grith}} {{$dim->type}}</p>
                        <p><span class="span_label">Specfications: </span>
                            <?=$gpage ? $gpage->specification : ''?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="row">

                <div class="m12 s12">

                    <!--buy table start-->
                @includeif('layouts.buytable')
                <!--buy table start-->
                </div>
                <div class="">

                    <div class="carousel">
                        <?php $x = 0 ?>
                        @if(count($gpages_list))
                            @foreach($gpages_list as $key=>$value)
                                @if($x<10)
                                    <?php
                                    $image = json_decode($value->image);
                                    $this->product_model = new \App\Product;
                                    $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                                    $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                                    $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                                    $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                                    $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                                    $page_name = preg_replace('/-+/', '-', $page_name);
                                    if (Auth::check()) {
                                        $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id, $value->id);
                                    } else {
                                        $like_status = 0;
                                    }
                                    $x++;

                                    ?>

                                    <a class="carousel-item eachFeature white hoverable" href="{{url('product/tv1/'.strtolower($page_name).'/'.$hashids->encode($value->id,$value->id+11,$value->id+22,$value->id+33,$value->id+44,$value->id+55))}}">
                                        <div class="row" style="margin: 0">
                                            <div class="col s12">
                                                @if(isset($image[0]->url))
                                                    <img width="100%" height="100px" src="{{asset('/public/'.$image[0]->url)}}">
                                                @else
                                                    <img height="100px"  class="bd-placeholder-img card-img-top"
                                                         src="{{asset('/public/')}}" width="100%" height="225"
                                                         role="img" aria-label="Placeholder: Thumbnail">
                                                @endif
                                            </div>
                                            <div class="titleSame col s12"><h6 class="black-text">{{$value->name}}</h6></div>
                                        </div>
                                    </a>
                                @endif
                            @endforeach
                        @endif



                    </div>
                </div>

                <div class="col m8 s12">
                    <!-- comments start -->
                    <div class="mainDivComment">
                        <div class="clearfix">
                            <h4>Comments</h4>

                            <div class="">
                                <form method="post" name="comment_frm" id="comment_frm">
                                    <input type="hidden" name="page_id" id="page_id">
                                    <div class="form-group">
                                        <h6 class="blacktext" for="exampleFormControlTextarea1">Enter your comment</h6>
                                        <textarea class="form-control" type="text" name="message" id="message_new"
                                                  rows="3"></textarea>
                                    </div>
                                    <a href="#" class="btn btn-primary float-right m-2 comment_reply_action"
                                       data-page_id="{{$selected_page_id}}" data-comment_id="new" data-type="parent">Send</a>
                                </form>
                            </div>


                            <hr class="mb-4" id="comments">
                            @if(count($comment_list))


                                <?php $parent_id = '' ?>
                                @foreach($comment_list as $key=>$comment)
                                    <?php
                                    $total_comment = $this->comment_model->get_total_comments_by_parent_id($comment->serial_number);
                                    $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($comment->serial_number);
                                    $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($comment->serial_number);
                                    if (Auth::check()) {
                                        $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id, $comment->serial_number);
                                        if (!$like_status) {
                                            $like_status = 'new';
                                        }
                                    } else {
                                        $like_status = 0;
                                    }
                                    $time_ago = App\Helpers\Common_func::time_ago_int($comment->created_at);
                                    $time_ago_arr = explode(" ", $time_ago);
                                    $parent_have_child = 0;
                                    ?>
                                    <div>
                                        @if(!$comment->parent_id)
                                            <div class="media mb-4 row">
                                                <div class="col s1">
                                                    <img class="d-flex mr-3 rounded-circle"
                                                         src="{{$comment->sender_picture}}" width="50" height="50"
                                                         alt="">
                                                </div>
                                                <div class="media-body col s11">

                                                    <div>
                                                        <div
                                                            class="d-flex justify-content-between align-items-center w-100">
                                                            <strong class="text-gray-dark"><h6
                                                                    class="mt-0">{{$comment->name}}</h6></strong>
                                                            <span
                                                                class="text-muted">{{$time_ago_arr?$time_ago_arr[0]:0}} {{$time_ago_arr?$time_ago_arr[1]:''}}</span>
                                                        </div>

                                                        <p>{{$comment->comment}}</p>
                                                        <div
                                                            class="card-footer d-flex justify-content-between align-items-center">
                                                            <div class="btn-group">
                                                            <span>
                                                                <a href="#" class="comment_like_action"
                                                                   data-comment_id="{{$comment->serial_number}}"
                                                                   data-like_status="{{$like_status == 'yes'?'yes':'no'}}"><i
                                                                        class="fas fa-arrow-up font-weight-bold"></i> </a> {{ $total_com_likes?$total_com_likes:0 - $total_com_unlikes?$total_com_unlikes:0 }} <a
                                                                    href="#" class="comment_dislike_action"
                                                                    data-comment_id="{{$comment->serial_number}}"
                                                                    data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> <i
                                                                        class="fas fa-arrow-down font-weight-bold"></i></a>
                                                             </span>
                                                            </div>
                                                            <div>
                                                                <span>{{$total_comment?$total_comment:0}} <a href="#"
                                                                                                             class="text-muted">replies </a><span> </span> <a
                                                                        href="#" class="comment_reply_action"
                                                                        data-page_id="{{$comment->product_id}}"
                                                                        data-comment_id="{{$comment->serial_number}}"> reply</a> </span>
                                                            </div>
                                                        </div>
                                                        <div class="form-group" style="padding: 10px 0 0 0">
                                                            <textarea name="message"
                                                                      id="message_{{$comment->serial_number}}"
                                                                      class="form-control" rows="3"></textarea>
                                                            <a class="btn btn-primary comment_reply_action m-3 p-1 float-right"
                                                               data-page_id="{{$hashids->encode($comment->product_id,$comment->product_id+11,$comment->product_id+22,$comment->product_id+33,$comment->product_id+44,$comment->product_id+55)}}"
                                                               data-comment_id="{{$comment->serial_number}}"
                                                               data-type="child">reply</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @foreach($comment_list as $key=>$child)
                                            @if(!empty($child->parent_id) && $child->parent_id == $comment->serial_number)
                                                <?php
                                                $time_ago = App\Helpers\Common_func::time_ago_int($child->created_at);
                                                $time_ago_arr = explode(" ", $time_ago);
                                                $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($child->serial_number);
                                                $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($child->serial_number);
                                                if (Auth::check()) {
                                                    $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id, $child->serial_number);
                                                    if (!$like_status) {
                                                        $like_status = 'new';
                                                    }
                                                } else {
                                                    $like_status = 0;
                                                }
                                                $parent_have_child = 1;
                                                ?>
                                                <div class="media mt-4">
                                                    <div class="row">
                                                        <div class="col s1">
                                                            <img class="d-flex mr-3 rounded-circle"
                                                                 src="{{$child->sender_picture}}" width="50" height="50"
                                                                 alt="">
                                                        </div>
                                                        <div class="media-body col s11">
                                                            <div>
                                                                <div
                                                                    class="d-flex justify-content-between align-items-center w-100">
                                                                    <strong class="text-gray-dark"><h6
                                                                            class="mt-0">{{$child->name}}</h6></strong>
                                                                    <span
                                                                        class="text-muted">{{$time_ago_arr?$time_ago_arr[0]:0}} {{$time_ago_arr?$time_ago_arr[1]:''}}</span>
                                                                </div>
                                                                <div
                                                                    style="border-radius: 6px;background: #0872b9; padding: 10px">
                                                                    <p class="text-white">{{$child->comment}}</p>
                                                                    <div
                                                                        class="card-footer d-flex justify-content-between align-items-center"
                                                                        style="background: #f1f1f2; margin-top: 5px">
                                                                        <div class="btn-group">
                                                                                    <span>
                                                                                      <a href="#"
                                                                                         class="comment_like_action"
                                                                                         data-comment_id="{{$child->serial_number}}"
                                                                                         data-like_status="{{$like_status == 'yes'?'yes':'no'}}"><i
                                                                                              class="fas fa-arrow-up font-weight-bold"></i> </a> {{ $total_com_likes?$total_com_likes:0 - $total_com_unlikes?$total_com_unlikes:0 }} <a
                                                                                            href="#"
                                                                                            class="comment_dislike_action"
                                                                                            data-comment_id="{{$child->serial_number}}"
                                                                                            data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> <i
                                                                                                class="fas fa-arrow-down font-weight-bold"></i></a>
                                                                                    </span>
                                                                        </div>
                                                                        <div>
                                                                            <span> <a href="#" class="text-muted">replies </a><span> </span> <a
                                                                                    href="#"> reply</a> </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach

                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
                <!-- comments end -->

                <div class="why123"></div>

            </div>
        </div>

    </div>

</main>
@if(Auth::check())
    <input id="is_login" type="hidden" value="yes">
@else
    <input id="is_login" type="hidden" value="no">
    @endif

    </div>
    <footer class="bg-dark">
        <section class="section" id="section-subfooter">
            <div class="container">
                <div class="row">
                    <div class="col m2 s6 subfooter-links">
                        <div class="subfooter-nav">
                            <h4 class="text-muted">About</h4>
                            <ul class="list-unstyled">
                                <li><a href="{{ url('/') }}/about" class="text-light">About Us</a></li>
                                <li><a href="{{ url('/') }}/posts" class="text-light">Posts</a></li>
                                <li><a href="{{ url('/') }}/privacy" class="text-light">Privacy</a></li>
                                <li><a href="{{ url('/') }}/terms" class="text-light">Terms</a></li>
                                <li><a href="{{ url('/') }}/apps" class="text-light">Apps</a></li>
                                <li><a href="{{ url('/') }}/contact" class="text-light">Feedback</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col m2  s6 subfooter-links">
                        <div class=" subfooter-nav">
                            <h4 class="text-muted">Q-links</h4>
                            <ul class="list-unstyled">
                                <li><a href="{{ url('/') }}/Account" class="text-light">Sign in</a></li>
                                <li><a href="{{ url('/') }}/apps" class="text-light">Get the app</a></li>
                                <li><a href="{{ url('/') }}/creator/add-product" class="text-light">Create a page</a>
                                </li>
                                <li><a href="{{ url('/') }}/register" class="text-light">Become a creator</a></li>
                                <li><a href="{{ url('/') }}/Qr-code-generator" class="text-light">QR Generator</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col s2  s6 subfooter-links">
                        <div class="subfooter-nav">
                            <h5 class="text-muted">Gfecst</h5>
                            <p class="text-light">General Helpline 24x7</p>
                            <br><br>
                            <h5 class="text-muted">G-pages</h5>
                            <p class="text-light">We are committed to your satisfaction at every step.</p>
                            <br><br>
                            <h5 class="text-muted">Our Apps</h5>
                            <p class="text-light">We provide you with fast and easy creation regardless of tech
                                knowledge.</p>
                            <br><br>
                        </div>
                    </div>
                    <div class="col m4 s6 subfooter-links">
                        <div class="subfooter-nav">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="container" id="footer-first">
            <div class="row">
                <div class="col s6">
                    <img src="{{url('/public/assets_web/img/logo_original_sm.png')}}" height="32">
                    <p class="paragraph mt-2 text-light">&copy; 2017-{{ date('Y') }} Gfects | All Rights Reserved</p>
                </div>
                <!-- /.col-lg-6 -->
                <div class="col s6">
                    <ul class="footer-nav-social list-inline list-unstyled  mt-2 h4">
                        <li class="list-inline-item"><a href="https://fb.me/Gfects" class="text-light" target="blank"><i
                                    class="fab fa-facebook-square"></i></a></li>
                        <li class="list-inline-item"><a href="https://www.linkedin.com/company/gfects"
                                                        class="text-light" target="blank"><i
                                    class="fab fa-linkedin"></i></a></li>
                        <li class="list-inline-item"><a href="https://www.instagram.com/gfects_nfc/?hl=en"
                                                        class="text-light" target="blank"><i
                                    class="fab fa-instagram"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- /.container -->
    </footer>





    <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

    <script>

        document.addEventListener('DOMContentLoaded', function() {
            var elems = document.querySelectorAll('.slider');
            var instances = M.Materialbox.init(elems, {
                onOpenStart: function () {
                    $('nav.productHeader').hide();
                },
                onCloseEnd : function () {
                    $('nav.productHeader').show();

                }
            });
        });
        $(document).ready(function(){

            $('.slider').slider();

        });


    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const carousel = document.querySelectorAll('.carousel');
            const instances = M.Carousel.init(carousel, {
                dist: 0,
                padding: 10,
                numVisible: 4,
                duration: 1,
                indicators: true
            });
        });

        function check_login() {
            var is_login = $("#is_login").val();
            if (is_login == 'yes') {
                return true;
            } else {
                alert('Please login !')
                window.location = "<?=url('user/login')?>";
            }
        }

        $(document).ready(function () {
            $('body').on('click', '#addpage', function (e) {
                e.preventDefault();
                if (check_login()) {
                    var page_id = $(this).data("page_id");
                    console.log(page_id);

                    $.ajax({
                        type: "GET",
                        url: site_url + "/user/favoritePage",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {page_id: page_id},
                        success: function (res) {
                            var data = jQuery.parseJSON(res);
                            if (data.status) {
                                toastr.success(data.msg);
                            } else {
                                toastr.error(data.msg);
                            }
                        }
                    });
                }
            });
        });


        $(document).ready(function () {
            $(".dropdown-trigger").dropdown();
            $('.tabs').tabs();
        });


        // start carrousel
        $('.carousel.carousel-slider').carousel({
            fullWidth: true,
            indicators: false
        });


        // move next carousel
        $('.moveNextCarousel').click(function (e) {
            e.preventDefault();
            e.stopPropagation();
            $('.carousel').carousel('next');
        });

        // move prev carousel
        $('.movePrevCarousel').click(function (e) {
            e.preventDefault();
            e.stopPropagation();
            $('.carousel').carousel('prev');
        });


        function fallbackCopyTextToClipboard(text) {
            var textArea = document.createElement("textarea");
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                var successful = document.execCommand('copy');
                var msg = successful ? 'successful' : 'unsuccessful';
                console.log('Fallback: Copying text command was ' + msg);
            } catch (err) {
                console.error('Fallback: Oops, unable to copy', err);
            }

            document.body.removeChild(textArea);
        }

        function copyTextToClipboard(text) {
            if (!navigator.clipboard) {
                fallbackCopyTextToClipboard(text);
                return;
            }
            navigator.clipboard.writeText(text).then(function () {
                console.log('Async: Copying to clipboard was successful!');
            }, function (err) {
                console.error('Async: Could not copy text: ', err);
            });
        }

        var copyBobBtn = document.querySelector('.fa-copy');

        copyBobBtn.addEventListener('click', function (event) {
            copyTextToClipboard('{{url()->full()}}');
        });


        $(document).ready(function () {
            //comment like  action
            $('body').on('click', '.comment_like_action', function (e) {
                e.preventDefault();
                if (check_login()) {
                    var comment_id = $(this).data("comment_id");
                    var like_status = $(this).data('like_status');
                    if (like_status == 'yes') {
                        toastr.success('You have already like this comment!');
                        return true;
                    }
                    $.ajax({
                        type: "POST",
                        url: site_url + "/user/comment-likes",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {comment_id: comment_id, like_status: 'yes'},
                        success: function (res) {
                            var data = jQuery.parseJSON(res);
                            if (data.status) {
                                toastr.success(data.msg);
                                setTimeout(function () {
                                    window.location.reload();
                                }, 900);
                            } else {
                                toastr.error(data.msg);
                            }
                        }
                    });
                }
            });
            //dislike comment
            $('body').on('click', '.comment_dislike_action', function (e) {
                e.preventDefault();
                if (check_login()) {
                    var comment_id = $(this).data("comment_id");
                    var like_status = $(this).data('like_status');
                    if (like_status == 'no') {
                        toastr.success('You have already unlike this comment!');
                        return true;
                    }
                    $.ajax({
                        type: "POST",
                        url: site_url + "/user/comment-likes",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {comment_id: comment_id, like_status: 'no'},
                        success: function (res) {
                            var data = jQuery.parseJSON(res);
                            if (data.status) {
                                toastr.success(data.msg);
                                setTimeout(function () {
                                    window.location.reload();
                                }, 900);
                            } else {
                                toastr.error(data.msg);
                            }
                        }
                    });
                }
            });

            $('body').on('click', '.comment_reply_action', function (e) {
                e.preventDefault();
                if (check_login()) {
                    var comment_id = $(this).data("comment_id");
                    var page_id = $(this).data("page_id");
                    var message = $("#message_" + comment_id).val().trim();
                    if (message == undefined || message == '') {
                        toastr.error('please enter message!');
                        return true;
                    }
                    $.ajax({
                        type: "POST",
                        url: site_url + "/user/gpages-comment",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {page_id: page_id},
                        success: function (res) {
                            var data = jQuery.parseJSON(res);
                            // $("#comment_model").modal("toggle");
                            if (data.status) {
                                toastr.success(data.msg);
                                $("#message_" + comment_id).val('');
                                setTimeout(function () {
                                    window.location.reload();
                                }, 900);
                            } else {
                                toastr.error(data.msg);
                            }
                        }
                    });
                }
            });

            $('body').on('click', '.like_action', function (e) {
                e.preventDefault();
                if (check_login()) {
                    var page_id = $(this).data("page_id");
                    var like_status = $(this).data('like_status');
                    if (like_status == 'yes') {
                        toastr.success('You have already like this page!');
                        return true;
                    }
                    $.ajax({
                        type: "POST",
                        url: site_url + "/user/gpages-likes",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {page_id: page_id, like_status: 'yes'},
                        success: function (res) {
                            var data = jQuery.parseJSON(res);
                            if (data.status) {
                                toastr.success(data.msg);
                                setTimeout(function () {
                                    window.location.reload();
                                }, 900);
                            } else {
                                toastr.error(data.msg);
                            }
                        }
                    });
                }
            });
            $('body').on('click', '.dislike_action', function (e) {
                e.preventDefault();
                if (check_login()) {
                    var page_id = $(this).data("page_id");
                    var like_status = $(this).data('like_status');
                    if (like_status == 'no') {
                        toastr.success('You have already unlike this page!');
                        return true;
                    }
                    $.ajax({
                        type: "POST",
                        url: site_url + "/user/gpages-likes",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {page_id: page_id, like_status: 'no'},
                        success: function (res) {
                            var data = jQuery.parseJSON(res);
                            if (data.status) {
                                toastr.success(data.msg);
                                setTimeout(function () {
                                    window.location.reload();
                                }, 900);
                            } else {
                                toastr.error(data.msg);
                            }
                        }
                    });
                }
            });

        });


    </script>
</html>
