<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
  @include('users.inc.head')
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <div class="mask"></div>
        @include('users.inc.side_pop_up') 
    <!-- Navbar-->
    <header class="app-header">
        
        <h4 class="header-title">Profile info</h4>
        
        <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
             <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
      <!-- Navbar Right Menu-->
       @include('users.inc.nav_right_menu')
       <style type="text/css">
        .error{color:#800000;}     
        </style>
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
    @include('users.inc.app_side_bar')
    </aside>
    <main class="app-content">
    <form class="form-auth-small" action="{{url('user/profile-info')}}" method="post" enctype="multipart/form-data" id="user_profile_frm">
    @if(session('success'))
      <div class="alert alert-success" role="alert" style="width: 400px;position: fixed;margin-top: 0px;margin-left: 0px;z-index: 1000;">
      <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
      {{session('success')}}
      </div>
    @elseif(session('error'))
      <div class="alert alert-danger" role="alert" style="width: 400px;position: fixed;margin-top: 0px;margin-left: 0px;z-index: 1000;">
       <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
      {{session('error')}}
    </div>
    @endif
      <div class="row">
        <div class="col-md-4" style='float: none; margin: auto'>          
            @csrf
            <input type="hidden" name="user_id" value="{{$user[0]->id}}">
            <div class="form-group">
              <label  class="control-label ">First Name</label>
              <input type="text" class="form-control" name="first_name"  value="{{$user?$user[0]->first_name:''}}" required readonly>
              <br>
              @if ($errors->has('first_name'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('first_name') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label  class="control-label">Last Name</label>
              <input type="text" class="form-control" name="last_name"  value="{{$user?$user[0]->last_name:''}}" required readonly>
              <br>
              @if ($errors->has('last_name'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('last_name') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label  class="control-label ">Date of birth</label>
              <input type="date" class="form-control" name="date_of_birth"  value="{{$user?$user[0]->date_of_birth:''}}" required readonly>
              <br>
              @if ($errors->has('date_of_birth'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('date_of_birth') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label class="control-label ">Email</label>
              <input type="email" class="form-control" name="email"  value="{{$user?$user[0]->email:''}}" required readonly>
              <br>
              @if ($errors->has('email'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('email') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label class="control-label ">Username</label>
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">@</span>
                  </div>
                  <input type="text" class="form-control " id="username" name="username" value="{{$user?$user[0]->username:''}}" placeholder="Username" required readonly>
                  <br>
                  @if ($errors->has('username'))
                      <span class="error" role="alert">
                          <strong>{{ $errors->first('username') }}</strong>
                      </span>
                  @endif
                </div>
            </div>
            <a href="{{url()->previous()}}" class="btn btn-primary btn-lg btn-block">Back</a>
            <div class="bottom text-center">
            </div>
        </div>
         <div class="col-md-6"> 
            <div class="form-group">
             <div class="form-group">
              <label class="control-label ">Profile Picture</label>
                <img src="{{$user?$user[0]->profile_picture:''}}" width="250px" height="200px" id="profile_pic_preview" />
              </div>
            </div>
         </div>
      </div>
    </form>
  </main>
    <!-- Essential javascripts for application to work-->
   @include('users.inc.footer_js_lib')
  </body>
</html>