<?php
$product_id = session()->get('product_id');
$product_name =session()->get('product_name');
$url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
$url_name = strtolower(preg_replace('/-+/', '-', $url_name));
$this->comment_model = new \App\ProductComment;
use Hashids\Hashids;
$hashids = new Hashids();



?>
    <!DOCTYPE html>
<html lang="en">
@include('users.inc.head')

<!-- Custom styles for this template -->
<link href="{{asset('/public/css/styling.css')}}" rel="stylesheet">
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<style>
    body{
        position: relative; /* required */
    }
    .nav-group{
        position:sticky; /* Supported in latest version of Chrome, Firefox, Safari, Opera and Edge browsers */
        top: 15px;
    }
    .comment-body ul li>table tr td img{    width: 50px;
        height: 50px;
        border-radius: 50%;
        margin-right: 15px;
    }
    .comment-body ul li>table{
        width:100%;}
    .comment-body ul li{display: block; padding: 15px 0;}
    .comment-body ul{
        margin: 0px;
        padding: 0px;
        list-style: none;
        margin-bottom: 25px;}
    .comment-body ul li>table tr:first-of-type td:first-child {
        width: 50px;
    }

    .comment-body ul li>table tr td {
        vertical-align: top;
    }
    .comment-body ul li.sub-comments {
        padding-left: 60px;
    }
    .comment-body ul li+li {
        border-top: 1px solid #ececec;
    }
    .comment-container{padding-top: 25px;}
    .comment-header{margin: 13px 0px;
        font-size: 20px;
        font-weight: 600;
    }
    .share_icon
    {
        width:50px;
        height: 50px;
        text-align:center;
        border-radius:30%;
        font-size: 56px;
        overflow:hidden;
    }
    .share_icon i
    {
        position: relative;
        top: -16px;
    }


    /* Start Sticky menu */

    .sticky {
        position: fixed;
        top: 56px;
        width: 100%;
        z-index: 9999999;
    }

    .sticky + .content {
        padding-top: 102px;
    }

    /* End Sticky menu */


</style>

<body class="app sidebar-mini rtl pace-done sidenav-toggled">
<div class="mask"></div>
@include('users.inc.side_pop_up')


<!-- Navbar-->
@include('layouts.inc_header')

<!-- Sidebar menu-->
<div class="app-sidebar__overlay" data-toggle="sidebar"></div>
<main class="app-content">

    <div class="row">
        <div class="col-md-7">
            <div class="product-slider-wrapper out">
                <div class="products-slider">
                    @if($gpage && !empty($gpage))
                        <?php
                        if (isset($gpage->image)){
                            $images = json_decode($gpage->image);
                        }else {
                            $images = [];
                        }
                        ?>
                        @foreach($images as $key=>$value)
                            <div class="product"><img src="{{asset('/public/'.$value->url)}}" /></div>
                        @endforeach
                    @else
                        No Image Available!
                    @endif

                </div>
                <a href="#" class="zoom-in"><img src="{{asset('/public/assets_web/img/icons/zoomin.png')}}" /></a>
                <a href="#" class="zoom-out"><img src="{{asset('/public/assets_web/img/icons/zoomout.png')}}" /></a>
            </div>
        </div>
        <div class="col-md-5">
            <?php
            $this->product_model = new App\product;
            $total_likes = $this->product_model->get_total_likes_by_page_id($product_id);
            $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($product_id);
            $total_comments = $this->product_model->get_total_comments_by_page_id($product_id);
            if(Auth::check()){
                $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$product_id);
            }else{
                $like_status = 0;
            }
            $color = json_decode($gpage->color);
            $buy_url = json_decode($gpage->buy_url);
            $dim = json_decode($gpage->dimension);
            ?>
            <div class="tile">
                <div class="card-body">
                    <h4 class="tile-title">{{$gpage?$gpage->name:''}}</h4>
                    <p>{{$gpage?$gpage->description:''}}</p>
                    <p></p>
                </div>
                <div class="card-body ">
                    <div class="row">
                        <div class="col-lg-5 text-success d-flex justify-content-between">
                            <div>
                                <h6 class="my-0">lowest price :<small></small></h6>
                                <p>
                                    <span data-toggle="tooltip" data-placement="top" title="the Manufacturer Suggested Retail Price"> MSRP :</span>  <small class="text-muted">{{\App\Currencie::find($gpage->currency)->symbol}}{{$gpage?$gpage->msr_price:''}}</small>
                                </p>
                            </div>
                            <span class="text-muted">{{\App\Currencie::find($gpage->currency)->symbol}}{{$gpage?$gpage->price:''}}</span>
                        </div>
                        <div class="col-lg-5">
                            <div class="float-right">
                                <button type="button" class="btn btn-success">Buy</button>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex  flex-row">
                        <div class="" title="Made in">
                            <span data-toggle="tooltip" data-placement="top" title="Manufactured/supplied by"><i class="fas fa-industry"></i> By {{$gpage?$gpage->manufactured_by:''}} </span>
                        </div>
                        <div class="ml-3" title="Made in">
                            <span data-toggle="tooltip" data-placement="top" title="Made/assembled in"> <i class="fa fa-globe-africa"></i> {{$gpage?$gpage->made_in_name:''}} </span>
                        </div>
                    </div>

                </div>

                <div>

                    <div class="card-footer d-flex justify-content-between align-items-center">
                        <div class="card-footer-item">
                            <span>
                              <a href="#" class="like_action" data-page_id="{{$product_id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"><i class="fas fa-arrow-up font-weight-bold"></i> </a> {{ $total_likes - $total_unlikes }} <a href="#" class="dislike_action" data-page_id="{{$product_id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> <i class="fas fa-arrow-down font-weight-bold"></i></a>
                            </span>
                            <div class="text-muted text-center small"> Push</div>
                        </div>
                        <div class="card-footer-item">
                            <i class="fa fa-eye text-teal"></i> {{$gpage?$gpage->view_count:''}}
                            <div class="text-muted small"> Views</div>
                        </div>
                        <div id='addpage' class="card-footer-item" data-page_id="{{$product_id}}">
                            <a href="#">
                                <i class="fa fa-plus text-teal"></i>
                                <div class="text-muted small"> Add</div>
                            </a>
                        </div>
                        <div class="card-footer-item">
                            <a data-toggle="modal" data-target="#share_div" href="">
                                <i class="fas fa-share-alt"></i>
                                <div class="text-muted small"> Share</div>
                            </a>
                        </div>
                        <div class="card-footer-item">
                            <a href="#comments" >
                                <i class="fas fa-comment-alt"></i> {{$total_comments}}
                                <div class="text-muted small"> Comments </div>
                            </a>
                        </div>
                    </div>
                    <div class="card-footer d-flex justify-content-between align-items-center">
                        <div class="card-footer-item">

                            <a href="{{url('user/'.$hashids->encode($gpage->user_id,$gpage->user_id+11,$gpage->user_id+22,$gpage->id+33,$gpage->id+44,$gpage->id+55).'/'.$gpage->username)}}" title="Open Author's page">
                                <div class="d-inline"><img src="{{$gpage->profile_picture}}" style="border-radius: 50%;height: 30px;max-width: 25px;" /></div>
                                <div class="d-inline text-muted small"> By {{$gpage->username}} </div>
                            </a>
                        </div>
                        <div class="card-footer-item">
                            <div class="text-muted small"> Created At {{date('M d, Y',strtotime($gpage->created_at))}}</div>
                        </div>
                        <div class="card-footer-item">
                            <div class="text-muted small"> Last Updated {{date('M d, Y',strtotime($gpage->updated_at))}} </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">

        <div class="m-1" id="stickHeader">
            <nav id="navbar-bar2" class="navbar navbar-light bg-light">
                <ul class="nav nav-pills nav-group">
                    @if($gpage?$gpage->how_to_use_text:'')
                        <li class="nav-item">
                            <a class="nav-link" href="#h2usee">How to use</a>
                        </li>
                    @endif
                    @if($gpage?$gpage->features:'')
                        <li class="nav-item">
                            <a class="nav-link" href="#features">Features</a>
                        </li>
                    @endif
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="#Specs">Specs</a>
                    </li>
                </ul>
            </nav>
        </div>
    </div>


    <div class="container content">

        <div  data-spy="scroll" data-target="#navbar-bar2" data-offset="0">
            <div class="pt-5" id="h2usee">
                @if($gpage?$gpage->how_to_use_text:'')
                    <h4>How to use</h4>
                    <?=$gpage?$gpage->how_to_use_text:''?>
                @endif
            </div>
            <div class="pt-5" id="features">
                @if($gpage?$gpage->features:'')
                    <h4>Features</h4>
                    <?=$gpage?$gpage->features:''?>
                @endif
            </div>
            <div class="pt-5" id="Specs">
                <h4>Specs</h4>
                @if(is_array($color))
                @if(count($color))

                    <div class="row mb-3">
                        <div class="col-md-1">Color :</div>
                        <div class="col-md-1">
                            @foreach($color as $key=>$value)
                                <div class="pb-3">
                                    <span class="custom_button" style="padding:2px 14px 2px 36px; background-color: <?=$value?>"></span>
                                </div>
                            @endforeach
                        </div>

                    </div>

                @endif
                @else
                    <div class="row mb-3">
                    <div class="col-md-1">Color :</div>
                    <div class="col-md-1">
                            <div class="pb-3">
                                <span class="custom_button" style="padding:2px 14px 2px 36px; background-color: <?=$color?>"></span>
                            </div>
                    </div>

            </div>

            @endif
                <p><span class="span_label">Manufactred Part No: </span>{{$gpage?$gpage->manufactured_part_no:''}}</p>
                <p><span class="span_label">Weight: </span>{{$gpage?$gpage->weight:''}} {{$gpage?$gpage->unit_price:''}}</p>
                <p><span class="span_label">Height: </span>{{$dim->height}} {{$dim->type}}</p>
                <p><span class="span_label">Width: </span>{{$dim->width}} {{$dim->type}}</p>
                <p><span class="span_label">Length: </span>{{$dim->length}} {{$dim->type}}</p>
                <p><span class="span_label">Grith: </span>{{$dim->grith}} {{$dim->type}}</p>
                <p><span class="span_label">Specfications: </span>
                    <?=$gpage?$gpage->specification:''?>
                </p>
            </div>
        </div>
    </div>


    <hr class="mb-4">

            <!--buy table start-->
                @includeif('layouts.buytable')
            <!--buy table start-->
            
            
    <div class="container">
        <div class="mb-4">
            <!-- Gpages start -->
            <div class="row">
                <?php $x=0 ?>
                @if(count($gpages_list))
                    @foreach($gpages_list as $key=>$value)
                        @if($x<5)
                            <?php
                            $image = json_decode($value->image);
                            $this->product_model = new \App\Product;
                            $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                            $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                            $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                            $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                            $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                            $page_name = preg_replace('/-+/', '-', $page_name);
                            if(Auth::check()){
                                $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                            }else{
                                $like_status = 0;
                            }
                            $x++;

                            ?>


                            @includeif('layouts.gpagesDiv')
                            
                            
                        @endif
                    @endforeach
                @endif
            </div>

        <!-- Gpages end -->
            </div>
        </div>


        <div class="m-auto" style="max-width:500px;">
            
            <!-- comments start -->

                <div class="mt-2 clearfix">
                    <h4>Comments</h4>

                    <div class="">
                        <form  method="post" name="comment_frm" id="comment_frm">
                            <input type="hidden" name="page_id" id="page_id">
                            <div class="form-group">
                                <label for="exampleFormControlTextarea1">Enter your comment</label>
                                <textarea class="form-control"  type="text" name="message" id="message_new" rows="3"></textarea>
                            </div>
                            <a href="#" class="btn btn-primary float-right m-2 comment_reply_action" data-page_id="{{$selected_page_id}}" data-comment_id="new" data-type="parent">Send</a>
                        </form>
                    </div>
                </div>


                <hr class="mb-4" id="comments">
                @if(count($comment_list))


                    <?php $parent_id = '' ?>
                    @foreach($comment_list as $key=>$comment)
                        <?php
                        $total_comment = $this->comment_model->get_total_comments_by_parent_id($comment->serial_number);
                        $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($comment->serial_number);
                        $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($comment->serial_number);
                        if(Auth::check()){
                            $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id,$comment->serial_number);
                            if(!$like_status){
                                $like_status = 'new';
                            }
                        }else{
                            $like_status = 0;
                        }
                        $time_ago = App\Helpers\Common_func::time_ago_int($comment->created_at);
                        $time_ago_arr = explode(" ",$time_ago);
                        $parent_have_child = 0;
                        ?>
                            @if(!$comment->parent_id)
                                <div class="media m-auto mb-4"  style="max-width:500px;">
                                    <img class="d-flex mr-3 rounded-circle" src="{{$comment->sender_picture}}" width="50" height="50" alt="">
                                    <div class="media-body">
                                        <div>
                                            <div class="d-flex justify-content-between align-items-center w-100">
                                                <strong class="text-gray-dark"><h6 class="mt-0">{{$comment->name}}</h6></strong>
                                                <span class="text-muted">{{$time_ago_arr?$time_ago_arr[0]:0}} {{$time_ago_arr?$time_ago_arr[1]:''}}</span>
                                            </div>

                                            <p>{{$comment->comment}}</p>
                                            <div class="card-footer d-flex justify-content-between align-items-center">
                                                <div class="btn-group">
                                     <span>
                                       <a href="#" class="comment_like_action" data-comment_id="{{$comment->serial_number}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"><i data-page_id="{{$hashids->encode($comment->product_id,$comment->product_id+11,$comment->product_id+22,$comment->product_id+33,$comment->product_id+44,$comment->product_id+55)}}" class="fas fa-arrow-up font-weight-bold"></i> </a> {{ $total_com_likes?$total_com_likes:0 - $total_com_unlikes?$total_com_unlikes:0 }} <a href="#" class="comment_dislike_action" data-comment_id="{{$comment->serial_number}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> <i class="fas fa-arrow-down font-weight-bold"></i></a>
                                     </span>
                                                </div>
                                                <div>
                                                    <span>{{$total_comment?$total_comment:0}} <a href="#" class="text-muted">replies </a><span> </span> <a href="#" class="comment_reply_action" data-page_id="{{$comment->product_id}}" data-comment_id="{{$comment->serial_number}}"> reply</a> </span>
                                                </div>
                                            </div>
                                            <div class="form-group" style="padding:10px 0 45px 0">
                                                <textarea name="message" id="message_{{$comment->serial_number}}"  class="form-control" rows="3" ></textarea>
                                                <a class="btn btn-primary comment_reply_action m-3 p-1 float-right" data-page_id="{{$hashids->encode($comment->product_id,$comment->product_id+11,$comment->product_id+22,$comment->product_id+33,$comment->product_id+44,$comment->product_id+55)}}" data-comment_id="{{$comment->serial_number}}" data-type="child">reply</a>
                                            </div>
                                        </div>
                                        @endif
                                        @foreach($comment_list as $key=>$child)
                                            @if(!empty($child->parent_id) && $child->parent_id == $comment->serial_number)
                                                <?php
                                                $time_ago = App\Helpers\Common_func::time_ago_int($child->created_at);
                                                $time_ago_arr = explode(" ",$time_ago);
                                                $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($child->serial_number);
                                                $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($child->serial_number);
                                                if(Auth::check()){
                                                    $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id,$child->serial_number);
                                                    if(!$like_status){
                                                        $like_status = 'new';
                                                    }
                                                }else{
                                                    $like_status = 0;
                                                }
                                                $parent_have_child = 1;
                                                ?>
                                                <div class="media mt-4">
                                                    <img class="d-flex mr-3 rounded-circle" src="{{$child->sender_picture}}" width="50" height="50" alt="">
                                                    <div class="media-body">
                                                        <div>
                                                            <div class="d-flex justify-content-between align-items-center w-100">
                                                                <strong class="text-gray-dark"><h6 class="mt-0">{{$child->name}}</h6></strong>
                                                                <span class="text-muted">{{$time_ago_arr?$time_ago_arr[0]:0}} {{$time_ago_arr?$time_ago_arr[1]:''}}</span>
                                                            </div>
                                                            <div  style="border-radius: 6px;background: #0872b9; padding: 10px">
                                                                <p class="text-white">{{$child->comment}}</p>
                                                                <div class="card-footer d-flex justify-content-between align-items-center" style="background: #f1f1f2; margin-top: 5px">
                                                                    <div class="btn-group">
                                           <span>
                                             <a href="#" class="comment_like_action" data-comment_id="{{$child->serial_number}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"><i class="fas fa-arrow-up font-weight-bold"></i> </a> {{ $total_com_likes?$total_com_likes:0 - $total_com_unlikes?$total_com_unlikes:0 }} <a href="#" class="comment_dislike_action" data-comment_id="{{$child->serial_number}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> <i class="fas fa-arrow-down font-weight-bold"></i></a>
                                           </span>
                                                                    </div>
                                                                    <div>
                                                                        <span> <a href="#" class="text-muted">replies </a><span> </span> <a href="#"> reply</a> </span>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                @endforeach
                            @endif
            </div>
            <!-- comments end -->



</main>

<!-- share_div -->
<div id="share_div" style="max-width: 18rem; height: 18rem;top: auto;" class="card border-primary mx-auto modal fade p-0" tabindex="-1" role="dialog" aria-labelledby="share_div" aria-hidden="true">
    <div class="">
        <div class="modal-header">
            <h5>Share</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="share_div" aria-hidden="true">
                <span data-dismiss="modal" aria-label="Close" data-model_id="share_div" aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="card-body">
            <div class="d-flex flex-wrap">
                <div class="share_icon m-2" style="transform: rotate(0);"><a href="https://www.facebook.com/sharer/sharer.php?u={{url()->full()}}" class="stretched-link"><i class="fab fa-facebook-square" style="color:#1e4b95;"></i></a></div>
                <div class="share_icon m-2" style="transform: rotate(0);"><a href="https://www.linkedin.com/sharing/share-offsite/?url={{url()->full()}}" class="stretched-link"><i class="fab fa-linkedin" style="color:#0271ae;"></i></a></div>
                <div class="share_icon m-2" style="transform: rotate(0);"><a href="https://twitter.com/share?url={{url()->full()}}" class="stretched-link"><i class="fab fa-twitter-square" style="color:#1c9deb;"></i></a></div>
                <div class="share_icon m-2" style="transform: rotate(0);"><a href="whatsapp://send?text={{url()->full()}}" data-action="share/whatsapp/share" class="stretched-link"><i class="fab fa-whatsapp-square" style="color:#1d9910;"></i></a></div>
                <div class="share_icon m-2" style="transform: rotate(0);"><a href="http://www.reddit.com/submit?url={{url()->full()}}" class="stretched-link"><i class="fab fa-reddit-square" style="color:#f83200;"></i></a></div>
                <div class="share_icon m-2" style="transform: rotate(0); border: 1px solid #9e9e9e; font-size: 42px;"><a href="#" class="stretched-link"><i class="fas fa-copy" style=" top: -7px"></i></a></div>
            </div>
        </div>
    </div>
</div>
<!-- share_div -->

<!-- Essential javascripts for application to work-->
@include('users.inc.footer_js_lib')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script type="text/javascript">

    function fallbackCopyTextToClipboard(text) {
        var textArea = document.createElement("textarea");
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();

        try {
            var successful = document.execCommand('copy');
            var msg = successful ? 'successful' : 'unsuccessful';
            console.log('Fallback: Copying text command was ' + msg);
        } catch (err) {
            console.error('Fallback: Oops, unable to copy', err);
        }

        document.body.removeChild(textArea);
    }
    function copyTextToClipboard(text) {
        if (!navigator.clipboard) {
            fallbackCopyTextToClipboard(text);
            return;
        }
        navigator.clipboard.writeText(text).then(function() {
            console.log('Async: Copying to clipboard was successful!');
        }, function(err) {
            console.error('Async: Could not copy text: ', err);
        });
    }

    var copyBobBtn = document.querySelector('.fa-copy');

    copyBobBtn.addEventListener('click', function(event) {
        copyTextToClipboard('{{url()->full()}}');
    });




    $(document).ready(function(){
        $('body').on('click', '#addpage', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");

                $.ajax({
                    type: "GET",
                    url: site_url+"/user/favoritePage",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data:{page_id:page_id},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });


        $('body').on('click', '.comment_reply_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var message = $("#message_"+comment_id).val().trim();
                if(message ==undefined || message == ''){
                    toastr.error('please enter message!');
                    return true;
                }
                $.ajax({
                    type: "GET",
                    url: site_url+"/user/gpages-comment",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data:{page_id:page_id},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        $("#comment_model").modal("toggle");
                        if(data.status){
                            toastr.success(data.msg);
                            $("#message_"+comment_id).val('');
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
        $('body').on('click', '.like_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'yes'){
                    toastr.success('You have already like this page!');
                    return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id, like_status:'yes'},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
        $('body').on('click', '.dislike_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'no'){
                    toastr.success('You have already unlike this page!');
                    return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id, like_status:'no'},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });

        $('body').on('click', '.fllow_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var page_id = $(this).data("page_id");
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/gpages-fllows",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {page_id:page_id},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        })
        //Get domain name
        $('a.storeadd').each(function() {
            var hostname = $(this).attr('hostname');
            $(this).find( "span" ).html( hostname );
        });


        //comment like  action
        $('body').on('click', '.comment_like_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var comment_id = $(this).data("comment_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'yes'){
                    toastr.success('You have already like this comment!');
                    return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/comment-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {comment_id:comment_id, like_status:'yes'},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
        //dislike comment
        $('body').on('click', '.comment_dislike_action', function(e) {
            e.preventDefault();
            if(check_login()){
                var comment_id = $(this).data("comment_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'no'){
                    toastr.success('You have already unlike this comment!');
                    return true;
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/user/comment-likes",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {comment_id:comment_id, like_status:'no'},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            setTimeout(function(){
                                window.location.reload();
                            }, 900);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            }
        });
    })
</script>


<script>

    /* Start Sticky menu */
    window.onscroll = function() {myFunction()};

    var header = document.getElementById("stickHeader");
    var sticky = header.offsetTop;

    function myFunction() {
        if (window.pageYOffset > sticky) {
            header.classList.add("sticky");
        } else {
            header.classList.remove("sticky");
        }
    }

    /* End Sticky menu */
</script>
</body>
</html>
