<?php

use Hashids\Hashids;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/test1', function (\Illuminate\Http\Request $request){
    var_dump($request->id);

});

Route::any('/search','MainController@getSearchResult');


Route::get('/', 'MainController@index');
Route::get('/index1', 'MainController@index1');
Route::get('/apps', 'MainController@getApps');
Route::get('/G-pages', 'MainController@getCreator');
Route::get('/G-page', 'MainController@getCreator');
Route::get('/Gpages', 'MainController@getCreator');
Route::get('/Gpage', 'MainController@getCreator');
Route::get('/Account', 'MainController@getLogin')->middleware('guest');
Route::get('/Select-Account-Type', 'MainController@select_Account_Type')->middleware('guest');
Route::get('/log-in', 'MainController@getLogin')->middleware('guest');
Route::get('/login', 'MainController@getLogin')->middleware('guest');
//Route::post('/loggin', 'MainController@getLogin')->middleware('guest');
Route::get('/Reset-password', 'MainController@getResetPassword')->middleware('guest');
Route::get('/Create-Account', 'MainController@getCreateAccount')->middleware('guest');
//Route::get('/register', 'MainController@getRegisterUser')->middleware('guest')->name('register');
//Route::post('/Create-Account', 'MainController@postCreateAccount')->middleware('guest');

Route::get('/Creator-Types', 'MainController@getCreatorTypes');
Route::get('/A-Publisher', 'MainController@getAPublisher');
Route::get('/A-Business', 'MainController@getABusiness');
Route::get('/A-Agency', 'MainController@getAAgency');
//Route::get('/thanks-for-joining', 'Gtrolla@thanks4CREATEacc');
Route::get('/about', 'MainController@getAboutPage');
Route::get('/contact', 'MainController@getContactPage');
Route::post('/feedback', 'MainController@postContactPage');
Route::get('/privacy', 'MainController@getPrivacyPage');
Route::get('/terms', 'MainController@getTermPage');
Route::get('/Creator-Policy', 'MainController@getPolicyPage');
Route::get('/G-scan', 'MainController@getGscanPage');
Route::get('/Gscan', 'MainController@getGscanPage');
Route::get('/G-tos', 'MainController@getGtosPage');
Route::get('/Gtos', 'MainController@getGtosPage');
Route::get('/More-service', 'MainController@getMoreServicePage');
Route::get('/Creator', 'MainController@getCreatorPage');
Route::get('/Select-package', 'MainController@getSelectPakage');
Route::get('/posts', 'PostController@index');
Route::get('/post', 'PostController@show');
Route::get('/post/{id}/{slug?}', 'PostController@show');
Route::get('/Qr-code-generator', 'QrcodeController@create');

/*---for Qr code generator----*/
Route::get('/Qr-code-generator', 'QrcodeController@create');
Route::get('/QrCodeGen', 'QrcodeController@create');

Route::post('/QrCodeGen', 'QrcodeController@store');

Route::get('/test', function ()
{
    // Personal Information
    $firstName = 'John';
    $lastName = 'Doe';
    $title = 'Mr.';
    $email = 'john.doe@example.com';

    // Addresses
    $wordAddress = [
        'type' => 'work',
        'pref' => false,
        'street' => '123 my work street st',
        'city' => 'My Dreadful Town',
        'state' => 'LV',
        'country' => 'Hell',
        'zip' => '12345-678'
    ];

    $addresses = [ $wordAddress];

    // Phones
    $workPhone = [
        'type' => 'work',
        'number' => '001 555-1234',
        'cellPhone' => false
    ];
    $homePhone = [
        'type' => 'home',
        'number' => '001 555-4321',
        'cellPhone' => false
    ];
    $cellPhone = [
        'type' => 'work',
        'number' => '001 9999-8888',
        'cellPhone' => true
    ];
    $tempLocation = public_path().'/img/qrcodes/';
    $data['format'] = 'png';
    $data['Margin'] = 2;
    $data['size'] = 18;
    //$data['img_file'] = "gfx_qr".time().'.'.$data['format']; >> removing forname
    $data['img_file'] = time().'.'.$data['format'];
    $data['form_type'] = request('form_type');

    $phones = [$workPhone];

    $pngImage = QRCode::vCard($firstName, $lastName, $title, $email, $addresses, $phones)
        ->setErrorCorrectionLevel('H')
        ->setSize(4)
        ->setMargin(2)
        ->setOutfile($tempLocation.$data['img_file'])
        ->png();





    //\Image::make($pngImage)->save($tempLocation.$data['img_file']);

});

Route::get('qrtest', function () {
    $pngImage = QrCode::format('png')
        ->size(500)->errorCorrection('H')
        ->email('bradley@asds.com');
    $png_url = "product-".time().".png";
    $path=public_path('\img\\'.$png_url);
//
//    $image2 = imagecreatefromstring($pngImage);
//    $image1 = imagecreatefromstring(file_get_contents(asset('/public/G-tos.png')));
//
//
//    imagecopymerge($image1,$image2,90,90,0,0,350,350,100);
//    header('Content-Type:image/png');
//    imagepng($image1);

//    Image::make($pngImage)->save($path);
//    $states_model = new \App\ProductComment();
//
//    $states_model->get_comment_details_by_comment_id(4);


    $image_1 = imagecreatefrompng(asset('/public/img/Gts.png'));

    $image_2 =  imagecreatefromstring($pngImage);
    imagealphablending($image_1, true);
    imagesavealpha($image_1, true);
    imagecopy($image_1, $image_2, 100, 100, 50, 50, 400, 400);


    ob_start(); // Let's start output buffering.
    imagejpeg($image_1); //This will normally output the image, but because of ob_start(), it won't.
    $contents = ob_get_contents(); //Instead, output above is saved to $contents
    ob_end_clean();
    print '<p><img src="data:image/png;base64,'.base64_encode($contents).'" alt="image 1" /></p>';


});

/***************Auth ,Register,Login routes, Forget password********************************************/
Auth::routes();
Route::get('login','MainController@getLogin')->name('login');
Route::post('login','Auth\LoginController@login');
Route::get('logout','Auth\LoginController@logout');
Route::get('register','Auth\RegisterController@ShowRegisterForm');
Route::post('register','Auth\RegisterController@register');
Route::get('registerX','Auth\RegisterController@getregisterX');
Route::post('registerX','Auth\RegisterController@registerX');
Route::get('email-verification/{id}', 'Auth\RegisterController@email_verification');
Route::get('thank-you', 'Auth\RegisterController@thank_you');
Route::get('switch-account','Auth\LoginController@switch_account');
Route::get('auth/{provider}', 'Auth\RegisterController@redirectToProvider');
Route::get('user/auth/{provider}', 'Auth\RegisterController@redirectToProviderUser');
Route::get('auth/{provider}/callback', 'Auth\RegisterController@handleProviderCallback');
Route::get('forgetpassword', 'User\Auth\ForgotPasswordController@forgetpassword');
Route::post('forgetpassword', 'Auth\ForgotPasswordController@forgetpassword_post');
Route::get('resetpassword', 'Auth\ForgotPasswordController@resetpassword');
Route::post('resetpassword', 'Auth\ForgotPasswordController@resetpassword_post');

/*###################### user section ############################*/
Route::prefix('user')->group(function () {
    Route::get('login','User\Auth\LoginController@ShowLoginForm');
    Route::post('login','User\Auth\LoginController@login');
    Route::get('register','User\Auth\RegisterController@ShowRegisterForm');
    Route::post('register','User\Auth\RegisterController@register');
    Route::get('logout','User\Auth\LoginController@logout');
    Route::get('email-verification/{id}', 'User\Auth\RegisterController@verifyEmail');
});

/********************* Ajax controller routes**************************************/
Route::prefix('ajax')->group(function () {
    Route::post('get-subcategory', 'AjaxController@getSubCategoryById');
    Route::post('get-states', 'AjaxController@getStataByCountry');
    Route::post('get-cities', 'AjaxController@getCitiesByStateId');
    Route::post('check-email', 'AjaxController@isEmailExist');
    Route::post('check-username', 'AjaxController@isUsernameExist');
    Route::post('check-barcode', 'AjaxController@isbarcodeExist');
    Route::post('comment-details', 'AjaxController@getCommentDetailById');
    Route::post('message-details', 'AjaxController@gtetMessageDetailsByMessageId');
    Route::post('support-details', 'AjaxController@get_support_details_by_support_id'); //need clean
    Route::post('search-gpages', 'AjaxController@search_gpages'); //need clean
    Route::post('resolved-support-message', 'AjaxController@resolved_support_message'); //need clean
    Route::post('saveDraft', 'AjaxController@postSaveDraft'); //need clean
    Route::post('edit-product', 'AjaxController@edit_product');
});


/****************** File uplod routes*********************************/
Route::post('common/file_upload', 'FileUploadController@file_upload');
Route::post('common/deleteStorageFile', 'FileUploadController@deleteStorageFile');

/********************* Creator routes**************************************/
Route::prefix('creator')->group(function () {
    Route::get('home', 'CreatorController@publisher_details');
    Route::get('dashboard', 'CreatorController@index');
    Route::get('dashboard-new', 'CreatorController@index_new');
    Route::get('createX', 'CreatorController@create_gpage');
    Route::post('Xcreate', 'CreatorController@postSaveDraft');
    Route::get('edit-productX/{id}', 'CreatorController@edit_productX');
    Route::post('edit-productX', 'CreatorController@edit_product_post');
    Route::get('create', 'CreatorController@add_product');
    Route::get('add-product', 'CreatorController@add_product');
    Route::post('add-product', 'CreatorController@add_product_post');
    Route::post('edit-product', 'CreatorController@edit_product_post');
    Route::get('edit-product/{id}', 'CreatorController@edit_product');
    Route::post('edit-product', 'CreatorController@edit_product_post');
    Route::get('preview-gpages/{id}', 'CreatorController@preview_gpages');
    Route::post('delete-product', 'CreatorController@delete_product');
    Route::get('gpages', 'CreatorController@gpages_list');
    Route::get('draft', 'CreatorController@draft_list');
    Route::post('publish-gpages', 'CreatorController@publish_gpages');
    Route::get('gpages-info/{id}', 'CreatorController@gpages_info');
    Route::get('Get-barcode', 'CreatorController@getBarcode');
    Route::get('pay-for-business-verification', 'CreatorController@payForBusiness');
    Route::get('Get-verified', 'CreatorController@get_verified');
    Route::get('submitDraft/{id}','CreatorController@submitDraft');

});
//comment
Route::get('creator/comment-list', 'CreatorController@comment_list');
Route::get('creator/comment-exchange/{page_id}', 'CreatorController@comment_exchange');
Route::post('creator/reply-to-comment', 'CreatorController@reply_to_comment');
Route::post('creator/delete-comment', 'CreatorController@delete_comment');

//message
Route::get('creator/message-list', 'CreatorController@message_list');
Route::post('creator/reply-to-message', 'CreatorController@reply_to_message');
Route::post('creator/replyMessage', 'CreatorController@replyMessage');
Route::post('creator/delete-message', 'CreatorController@delete_message');


//support
Route::get('creator/support', 'CreatorController@send_support');
Route::post('creator/support', 'CreatorController@support_response');
Route::get('creator/support-list', 'CreatorController@support_list');
Route::get('creator/support-message-exchange/{support_id}', 'CreatorController@support_message_exchange');
Route::post('creator/delete-support-message', 'CreatorController@delete_support_message');
Route::post('creator/support-response','CreatorController@support_response');

Route::get('creator/qrcode-list', 'CreatorController@qrcode_list');
Route::get('creator/gpages-qrcode/{id}', 'CreatorController@gpages_qrcode');

Route::get('creator/gpages-stats', 'CreatorController@gpages_stats');
Route::post('creator/product-commentlist', 'CreatorController@product_commentlist');
Route::get('creator/chat/{id}', 'CreatorController@message_chat');

/********************* Account setting controller routes**************************************/
Route::get('creator/setting/', 'AccountSettingController@creator_account_setting');
Route::get('creator/setting/delete_image/', 'AccountSettingController@creator_account_setting_delete_image');
Route::get('account/setting/', 'AccountSettingController@account_setting');
Route::post('account/setting/', 'AccountSettingController@account_setting_post');


/***************Product route define***Starts*****************************************/
Route::get('product/tv1/{slug}/{id}', [
    'uses' => 'User\UserController@product'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('labs/tv1/{slug}/{id}', [
    'uses' => 'User\UserController@tv1'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product1/tv1/{slug}/{id}', [
    'uses' => 'User\UserController@product1'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product/{slug}/about/{id}', [
    'uses' => 'User\UserController@about'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product/{slug}/buy/{id}', [
    'uses' => 'User\UserController@buy'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product/{slug}/how-to-use/{id}', [
    'uses' => 'User\UserController@how_to_use'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product/{slug}/others/{id}', [
    'uses' => 'User\UserController@others'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product/{slug}/images/{id}', [
    'uses' => 'User\UserController@gpages_images'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');

Route::get('product/{slug}/comment/{id}', [
    'uses' => 'User\UserController@gpages_comment_list'
])->where('slug', '([A-Za-z0-9\-\_\/]+)');
//Route::get('/gpages/{link_id}', 'User\UserController@gfx_gpage_info');
Route::get('/{link_id}', 'User\UserController@gfx_gpage_info');

Route::get('/p/{hashid}','User\UserController@productShort');

Route::get('product/images/{id}', [
    'uses' => 'User\UserController@gpages_images'
]);

Route::get('product/how-to-use/{id}', [
    'uses' => 'User\UserController@how_to_use'
]);

Route::get('product/buy/{id}', [
    'uses' => 'User\UserController@buy'
]);

Route::get('product/others/{id}', [
    'uses' => 'User\UserController@others'
]);

Route::get('product/about/{id}', [
    'uses' => 'User\UserController@about'
]);
/***************Product route define***Ends*****************************************/

/********************* Account setting controller routes**************************************/
Route::get('creator/setting/', 'AccountSettingController@creator_account_setting');
Route::get('account/setting/', 'AccountSettingController@account_setting');
Route::post('account/setting/', 'AccountSettingController@account_setting_post');

/*-----By Jibreal------------*/
Route::get('/creator/G-overview/{id}', 'CreatorController@goverview');


/*###################### user section ############################*/ //add
Route::get('user/login','User\Auth\LoginController@ShowLoginForm');
Route::post('user/login','User\Auth\LoginController@login');
Route::get('user/register','User\Auth\RegisterController@ShowRegisterForm');
Route::post('user/register','User\Auth\RegisterController@register');
Route::get('user/logout','User\Auth\LoginController@logout');
Route::get('user/email-verification/{id}', 'Auth\RegisterController@email_verification');

/*#######################forget password section############################*/ //add
Route::get('user/forgetpassword', 'User\Auth\ForgotPasswordController@forgetpassword');
Route::post('user/forgetpassword', 'User\Auth\ForgotPasswordController@forgetpassword_post');
Route::get('user/resetpassword', 'User\Auth\ForgotPasswordController@resetpassword');
Route::post('user/resetpassword', 'User\Auth\ForgotPasswordController@resetpassword_post');
/*####################### user pages section############################*/ //add
Route::get('user/home', 'User\UserController@index')->middleware('user');
Route::get('user/activities', 'User\UserController@user_activity')->middleware('user');
Route::get('user/info', 'User\UserController@profile_info')->middleware('user');
Route::get('user/messages', 'User\UserController@messages')->middleware('user');
Route::get('user/comment-to-gpages/{id}', 'User\UserController@comment_to_gpages');
Route::post('user/gpages-comment', 'User\UserController@gpages_comment');
Route::post('user/gpages-likes', 'User\UserController@gpages_likes');
Route::post('user/comment-likes', 'User\UserController@comment_likes');
Route::post('user/gpages-fllows', 'User\UserController@gpages_fllows');
Route::get('user/update-notification-status/{id}', 'User\UserController@update_notification_status');
Route::get('user/notification-list', 'User\UserController@notification_list');
Route::post('user/delete-notification', 'User\UserController@delete_notification');
Route::get('uhome', function () {
    return redirect('user/home');
});
Route::get('user/dashboard', function () {
    return redirect('user/home');
});

Route::get('user/publisher-dashboard/{id}', 'User\UserController@publisher_details');
Route::post('user/follow-to-publisher', 'User\UserController@follow_to_publisher')->middleware('user');
Route::post('user/add-to-gpages', 'User\UserController@add_to_gpages')->middleware('user');
Route::get('user/message-chat/{id}', 'User\UserController@message_chat')->middleware('user');
Route::post('user/chat', 'User\UserController@chat')->middleware('user');
Route::post('user/delete-message', 'User\UserController@delete_message');
Route::get('user/activity/{id}', 'User\UserController@user_activity')->middleware('user');
Route::post('user/delete-activity', 'User\UserController@delete_activity');
Route::get('user/gpages/', 'User\UserController@user_gpages')->middleware('user');
Route::get('user/publisher-statement/{id}', 'User\UserController@publisher_statement');
Route::get('user/publisher-gpages/{id}', 'User\UserController@publisher_gpages');
Route::get('user/message-view/{id}', 'User\UserController@message_view');
Route::post('user/replyMessage', 'User\UserController@replyMessage');
Route::get('/user/messageList', 'User\UserController@message_list');
Route::get('/user/favoritePage', 'User\UserController@favoritePage');


/********************* Others routes**************************************/ //add
Route::get('home/about', 'HomeController@about')->name('about');
Route::get('home/feedback', 'HomeController@feedback')->name('feedback');
Route::post('feedback', 'HomeController@feedback_post');

Route::get('home/support', 'HomeController@support');
Route::post('support', 'HomeController@support_post');

Route::get('report-gpages/{page_id}', 'HomeController@reported_to_gpages');
Route::post('report-gpages', 'HomeController@reported_to_gpages_post');

Route::get('home/privacy', 'HomeController@privacy');
Route::get('home/terms', 'HomeController@terms');
Route::get('home/teams', 'HomeController@teams');
Route::get('home/apps', 'HomeController@apps');

Route::get('gpages-info/{id}', 'HomeController@gpages_info');
Route::get('search/gpages', 'HomeController@search_gpages');

//test qr-code
Route::get('qrcode-with-color', function () {
    //return \QrCode::size(500)->backgroundColor(255,55,0)->generate('A simple example of QR code');
    return \QrCode::size(500)->format('png')->generate('this is test', public_path('qrcode/test.png'));
    //return  \QrCode::size(500)->format('png')->generate('https://gfects.com/gfects/', public_path('uploads/qrcode.png'));
});


/***************Admin section route define********************************************/
Route::get('admin/login','Admin\Auth\LoginController@ShowLoginForm');
Route::post('admin/login','Admin\Auth\LoginController@login');
Route::get('admin/forgetpassword','Admin\Auth\ForgotPasswordController@forgetpassword');
Route::post('admin/forgetpassword','Admin\Auth\ForgotPasswordController@forgetpassword_post');
Route::get('admin/resetpassword','Admin\Auth\ForgotPasswordController@resetpassword');
Route::post('admin/resetpassword','Admin\Auth\ForgotPasswordController@resetpassword_post');
Route::get('admin/logout','Admin\Auth\LoginController@logout');


Route::get('admin','Admin\DashboardController@index');
Route::get('admin/dashboard','Admin\DashboardController@index');
Route::get('admin/to-be-approved-gpages','Admin\DashboardController@to_be_approved_gpages');
Route::get('admin/approved-gpages','Admin\DashboardController@approved_gpages');
Route::get('admin/rejected-approved-gpages','Admin\DashboardController@rejected_approved_gpages');
Route::post('admin/update-gpages-status','Admin\DashboardController@update_gpages_status');
Route::post('admin/reject-message-to-publisher','Admin\DashboardController@reject_message_to_publisher');
Route::get('admin/user-info/{id}','Admin\DashboardController@user_info');
Route::get('admin/gpage-info/{id}','Admin\DashboardController@gpage_info');
Route::post('admin/delete-gpages','Admin\DashboardController@delete_gpages');
Route::get('admin/notification', 'Admin\DashboardController@notification');
Route::post('admin/delete-notification', 'Admin\DashboardController@delete_notification');
Route::post('admin/read-notification', 'Admin\DashboardController@read_notification');

Route::get('admin/user-list','Admin\DashboardController@user_list');
Route::post('admin/user-account-review','Admin\DashboardController@user_account_review');
Route::post('admin/user-account-delete','Admin\DashboardController@user_account_delete');
//admin profile section
Route::get('admin/profile','Admin\ProfileController@profile');
Route::post('admin/profile','Admin\ProfileController@profile_post');
Route::get('admin/change-password','Admin\ProfileController@change_password');
Route::post('admin/change-password','Admin\ProfileController@change_password_post');
//admin feedback section
Route::get('admin/feedback','Admin\DashboardController@feedback');
Route::post('admin/delete-feedback','Admin\DashboardController@delete_feedback');
Route::get('admin/feedback-exchange/{feedback_id}','Admin\DashboardController@feedback_exchange');
Route::post('admin/feedback-response','Admin\DashboardController@feedback_response');

//admin support section
Route::get('admin/support-message','Admin\DashboardController@support');
Route::post('admin/delete-support-message','Admin\DashboardController@delete_support_message');
Route::get('admin/support-message-exchange/{support_id}','Admin\DashboardController@support_message_exchange');
Route::post('admin/support-response','Admin\DashboardController@support_response');

//admin Flagged section
Route::get('admin/flagged-list','Admin\DashboardController@flagged_list');
Route::get('admin/flagged-info/{id}','Admin\DashboardController@flagged_info');
Route::post('admin/delete-reported-message','Admin\DashboardController@delete_reported_message');
/*************************** CMS Managment ************************************************************/
//category list
Route::get('admin/category-list','Admin\CategoryController@category_list');
Route::get('admin/category-add','Admin\CategoryController@add_category');
Route::post('admin/category-edit','Admin\CategoryController@edit_category_post');
Route::get('admin/category-edit/{id}','Admin\CategoryController@edit_category');
Route::post('admin/category-delete','Admin\CategoryController@delete_category');

//subcategory list
Route::get('admin/subcategory-list','Admin\SubcategoryController@subcategory_list');
Route::get('admin/subcategory-add','Admin\SubcategoryController@add_subcategory');
Route::post('admin/subcategory-edit','Admin\SubcategoryController@edit_subcategory_post');
Route::get('admin/subcategory-edit/{id}','Admin\SubcategoryController@edit_subcategory');
Route::post('admin/subcategory-delete','Admin\SubcategoryController@delete_subcategory');
//setting
Route::get('admin/setting/{pages}','Admin\SettingController@pages');
Route::post('admin/pages','Admin\SettingController@pages_post');
Route::get('admin/flagged/reason-list','Admin\SettingController@flagged_reason_list');
Route::get('admin/flagged/add-reason','Admin\SettingController@add_reason');
Route::post('admin/flagged/delete-reason','Admin\SettingController@delete_reason');
Route::get('admin/flagged/edit-reason/{id}','Admin\SettingController@edit_reason');
Route::post('admin/flagged/edit-reason','Admin\SettingController@edit_reason_post');
//Route::get('admin/send', 'Admin\DashboardController@sendNotification');
Route::post('admin/filter-user','Admin\DashboardController@filter_user');

//emailing
Route::get('admin/email','Admin\DashboardController@email');
Route::post('admin/email','Admin\DashboardController@emailpost');


//-------------view by others-----------//
Route::get('user/{id}/{slug}/about', 'User\UserController@about_user');
Route::get('user/{id}/{slug}/activities', 'User\UserController@activities');
Route::get('user/{id}/{slug}/gpages', 'User\UserController@gpages');
Route::get('user/{id}/{slug}', 'User\UserController@user_page');


Route::get('user/publisher-info/{id}', 'User\UserController@publisher_info');
Route::post('user/profile-info', 'User\UserController@profile_info_post')->middleware('user');
Route::get('user/change-password', 'User\UserController@change_password')->middleware('user');
Route::post('user/change-password', 'User\UserController@change_password_post')->middleware('user');

//---------------API--------------------------//

Route::get('api/product-url/{id}', 'User\UserController@api_product_details');










