<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Redirect;
use Session;
use App\Country;
use App\City;
use App\State;
use App\User;
use Auth;
use Hash;
class AccountSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function creator_account_setting()
    {
        $data = [
            'title' => 'Account Setting',
            'meta_description' => 'Gfects Creator Dashboard Account Setting from your Product Gpage',
            'pagetitle' => 'Gpages account',
            'heading' => 'Your account',
            'pass' => 'account-setting',

        ];
        $id = Auth::user()->id;
        $user_model = new User;
        $country_model = new Country;
        $state_model = new State;
        $city_model = new City;
        //$data['user'] = $user_model->get_user_details_by_id($id);
        $data['user'] = $user_model->get_user_details_by_id($id);
        $data['country'] = $country_model->all_country();
        $data['state'] = $state_model-> states_by_country_id($data['user'][0]->company_country);
        $data['city'] = $state_model->cities_by_state_id($data['user'][0]->company_state);
        //print_r($data);exit;
        return view('layouts.create',$data);
    }
    
    public function account_setting()
    {
        $data = [
            'title' => 'Account Setting',
            'meta_description' =>'A new platform is born'
        ];
        $id = Auth::user()->id;
        $user_model = new User;
        $country_model = new Country;
        $state_model = new State;
        $city_model = new City;
        $data['user'] = $user_model->get_user_details_by_id($id);
        $data['country'] = $country_model->all_country();
        $data['state'] = $state_model-> states_by_country_id($data['user'][0]->company_country);
        $data['city'] = $state_model->cities_by_state_id($data['user'][0]->company_state);
        //print_r($data);exit;
        return view('common.account_setting',$data);
    }
    
    public function account_setting_post(Request $request){
        $action_type = $request->action_type;
        $id = Auth::user()->id;
        if($action_type == "basic_details"){
            $param = array(
            'first_name'=>$request->first_name,
            'last_name' =>$request->last_name,
            'date_of_birth'       =>$request->dob,
            'country'   =>$request->country,
            'state'   =>$request->state,
            'created_at' => date("Y-m-d h:i:s"),
            'updated_at' => date("Y-m-d h:i:s"),
            );
        }else if($action_type == "profile_image"){
            if($request->hasFile('profile_pic')) {
              $filenameWithExt = $request->file('profile_pic')->getClientOriginalName();
              $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
              $extension = $request->file('profile_pic')->getClientOriginalExtension();
              $fileNameToStore = $filename.'_'.time().'.'.$extension;
              $destinationPath = public_path('profile_img');
              $request->file('profile_pic')->move($destinationPath, $fileNameToStore);
              $profile_image = asset('/public/'."profile_img/".$fileNameToStore);
            }else{
              $profile_image = $request->old_profile_pic;
            }
            $param = array(
                'profile_picture'=>$profile_image,
                'created_at' => date("Y-m-d h:i:s"),
                'updated_at' => date("Y-m-d h:i:s"),
            );
        }else if($action_type == "company_details"){
            $param['company_name'] = $request->company_name;
            $param['company_title'] = $request->company_title;
            $param['company_street'] = $request->company_street;
            $param['company_country'] = $request->company_country;
            $param['company_state'] = $request->company_state;
            $param['company_city'] = $request->company_city;
            $param['company_zip'] = $request->company_zip;
            $param['company_phone'] = $request->phone;
            $param = array(
                'company_name' => $request->company_name,
                'company_title' => $request->company_title,
                'company_street' => $request->company_street,
                'company_country' => $request->company_country,
                'company_state' => $request->company_state,
                'company_city' => $request->company_city,
                'company_zip' => $request->company_zip,
                'company_phone' => $request->phone,
            );
            
            DB::table('user_details')->where('user_id', $id)->update($param);
            $response['status'] = true;
            $response['msg'] = "Data has been updated.";
            //return Redirect::back()->withErrors(['msg', $response['msg']]);
            return redirect()->back()->with('success', $response['msg']);

            exit;
        }else if ($action_type == "change_password") {
            $conf_pass = trim($request->password_confirmation);
            $password = trim($request->password);
            $old_password = trim($request->old_password);
            $user = User::find(auth()->user()->id);
            if(!Hash::check($old_password, $user->password)){
                $response['status'] = false;
                $response['msg'] = "Old password is wrong.";
                return redirect()->back()->with('false', $response['msg']);
                //echo json_encode($response);
                exit;
            }
            if($password != $conf_pass){
                $response['status'] = false;
                $response['msg'] = "Password and confirm password is mismatch";
                return redirect()->back()->with('false', $response['msg']);
                //echo json_encode($response);
                exit;
            }
            $param = array(
                'password' => Hash::make($password),
                'created_at' => date("Y-m-d h:i:s"),
                'updated_at' => date("Y-m-d h:i:s"), 
            );
        }else if($action_type == "about"){
            $about = $request->about_txt;
            if($about == ''){
                $response['status'] = false;
                $response['msg'] = "Please enter about field";
                return redirect()->back()->with('false', $response['msg']);
                //echo json_encode($response);
                exit;
            }
            $param = array(
                'about' => $about,
                'created_at' => date("Y-m-d h:i:s"),
                'updated_at' => date("Y-m-d h:i:s"), 
            );
        }
        DB::table('users')->where('id', $id)->update($param);
        $response['status'] = true;
        $response['msg'] = "Data has been updated.";
        //return Redirect::back()->withErrors(['msg', $response['msg']]);
        return redirect()->back()->with('success', $response['msg']);

        exit;

    }
}
