<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use DB;
use Session;
use App\ProductSubcategory;
use App\State;
use View;
use App\ProductComment;
use App\ProductMessage;
use App\Support;
use App\Product;
class AjaxController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
    }

    public function getSubCategoryById(Request $request)
    {   
        $id = $request->id;
        $subcategory_model = new ProductSubcategory;
        $data['result'] = $subcategory_model->subcategory_by_category_id($id);
        $view = View::make('creators.ajax.subcategory',$data);   
        $content = $view->render();
        $response['content'] = $content;
        $response['status'] = true;
        echo json_encode($response);
    }

    public function getStataByCountry(Request $request)
    {   
        $id = $request->id;
        $states_model = new State;
        $data['result'] = $states_model->states_by_country_id($id);
        $view = View::make('common.ajax.states',$data);   
        $content = $view->render();
        $response['content'] = $content;
        $response['status'] = true;
        echo json_encode($response);
    }

    public function getCitiesByStateId(Request $request)
    {   
        $id = $request->id;
        $states_model = new State;
        $data['result'] = $states_model->cities_by_state_id($id);
        $view = View::make('common.ajax.cities',$data);   
        $content = $view->render();
        $response['content'] = $content;
        $response['status'] = true;
        echo json_encode($response);
    }
    
    public function isEmailExist(Request $request){
        $email = $request->email;
        $users=User::where('email',$email)->get()->toArray();
        if(count($users)>0){
            $response['status'] = true;
            $response['msg'] = "Email is already registered.";
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }

    public function isUsernameExist(Request $request){
        $username = $request->username;
        $users=User::where('username',$username)->get()->toArray();
        if(count($users)>0){
            $response['status'] = true;
            $response['msg'] = "User name is already used.";
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    public function getCommentDetailById(Request $request){
       $id = $request->id;
       $comment_model = new ProductComment;
       $comment = $comment_model->get_comment_details_by_comment_id($id);
       if(count($comment)>0){
            $created_at = date('D j M Y',strtotime($comment[0]->created_at));
            $comment[0]->created_at = $created_at;
            $response['status'] = true;
            $response['comment'] = $comment;
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }

    public function gtetMessageDetailsByMessageId(Request $request){
       $id = $request->id;
       $message_model = new ProductMessage;
       $message = $message_model->get_message_details_by_message_id($id);
       if(count($message)>0){
            $created_at = date('D j M Y',strtotime($message[0]->created_at));
            $message[0]->created_at = $created_at;
            $response['status'] = true;
            $response['message'] = $message;
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    public function get_support_details_by_support_id(Request $request){
       $id = $request->id;
       $support_model = new Support;;
       $message = $support_model->get_support_details_by_support_id($id);
       if(count($message)>0){
            $created_at = date('D j M Y',strtotime($message[0]->created_at));
            $message[0]->created_at = $created_at;
            $response['status'] = true;
            $response['message'] = $message;
        }else{
            $response['status'] = false;
        }
        echo json_encode($response);
    }
    public function search_gpages(Request $request){
        $search_key = trim($request->search_key);
        $search_page = trim($request->search_page);
        $product_model = new Product;
        $gpages = $product_model->search_gpages($search_key);
        $output = "";
        if($gpages){
            $response['status'] = true;
            foreach ($gpages as $key => $value) {
                $image = json_decode($value->image);
                $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
                /*$output.= '<li>
                  <a href="'.url('product/'.$url_name.'/about/'.$value->id).'" target="_blank">
                  <img src="'.asset($image[0]->url).'" alt="Avatar" class="img-circle pull-left avatar" width="100px;" height="30px;">
                  <span class="title">'.$value->name.'</span>
                  </a>
                </li>';*/
                if($search_page == 'yes'){
                    $view = View::make('common.ajax.search_result', compact('gpages'));
                    $output = $view->render();
                }else{
                $output.= '<li>
                 <a href="'.url('search/gpages?search_key=').$search_key.'" target="_blank">
                  <img src="'.asset($image[0]->url).'" alt="Avatar" class="img-circle pull-left avatar" width="100px;" height="30px;">
                  <span class="title">'.$value->name.'</span>
                  </a>
                </li>';
                }
            }
            $response['result'] = $gpages;
            $response['output'] = $output;
            $response['msg'] = "Data found";
        }else{
            $response['status'] = false;
            $response['msg'] = "Data not found";
        }
        echo json_encode($response);
    }
    public function resolved_support_message(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('support')->where('serial_number', '=', $id)->update(['status'=>1,'created_at'=>date('Y-m-d H:i:s')])){
                $response['status'] = true;
                $response['msg'] = "Support message status has been updated as resolved!";
                Session::flash('success', 'Support message status has been updated as resolved!');
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid chat id !";
        }
        echo json_encode($response);
    }
}
