<?php

namespace App\Http\Controllers;

//use App\Helpers\Common_func;
use Illuminate\Http\Request;
use App\Notifications\MyNotification;
use Validator;
use DB;
use Session;
use App\User;
use App\ProductCategory;
use App\ProductSubcategory;
use App\Product;
use App\Country;
use App\ProductComment;
use App\ProductMessage;
use App\MessageChat;
use App\Support;
use App\Helpers\Common_func  as Helper;
use Auth;
use View;
class CreatorController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth',['except' => array('preview_gpages')]);
        DB::connection()->enableQueryLog();
    }

    public function index()
    {   
        $id = Auth::user()->id;
        $product_model = new Product;
        $data = [
            'title' => 'Creator Dashboard',
            'meta_description' => 'Gfects Creator Dashboard',
            'pagetitle' => 'Dashboard',
            'heading' => 'Top Gpages',
            'pass' => 'home',
            'published_gpages' => $product_model->total_created_page_by_user_id($id,2),
            'approved_gpages' => $product_model->total_created_page_by_user_id($id,3),
            'total_likes' => $product_model->total_gpages_like_by_creator_id($id),
            'total_comments' => $product_model->total_gpages_comments_by_creator_id($id),
            'total_views' => $product_model->total_gpages_views_by_creator_id($id),
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status = array(1,2,3,4),5)

        ];
        return view('layouts.creatordash',$data);
    }
    
    public function index_new()
    {   
        $id = Auth::user()->id;
        $product_model = new Product;
        $data['title'] = 'Creator Dashboard';
        $data['meta_description'] = 'Creator Dashboard';
        $data['published_gpages'] = $product_model->total_created_page_by_user_id($id,2);
        $data['approved_gpages'] = $product_model->total_created_page_by_user_id($id,3);
        $data['total_likes'] = $product_model->total_gpages_like_by_creator_id($id);
        $data['total_comments'] = $product_model->total_gpages_comments_by_creator_id($id);
        $data['total_views'] = $product_model->total_gpages_views_by_creator_id($id);
        $data['gpages_list'] = $product_model->gpages_list_by_user_id($id,$status = array(1,2,3,4));
        return view('creators.dashboard_new',$data);
    }
    public function add_product()
    {
        $country = new Country;
        $product_model = new Product;
        
        $data = [
            'title' => 'Add Product',
            'meta_description' => 'Gfects Creator Dashboard Add Product',
            'pagetitle' => 'Add Product',
            'heading' => 'Add Product',
            'pass' => 'Create',
            'category' => ProductCategory::all(),
            'country' => $country->all_country(),
            'currency' => $product_model->currency_list(),

        ];
        return view('layouts.create',$data);
    }

//    public function edit_product_post(Request $request)
//    {
//
//    }
    public function add_product_post(Request $request){
        //print_r($_POST);exit;
        #validations rules array
        $rules  = array(
            //'bar_code'=>  'required',
            'category' =>  'required',
            'sub_category'       =>  'required',
            'name' => 'required',
            //'summary' =>  'required',
            //'title'     => 'required',
            'manufacture'   =>  'required',
            //'manufacture_port_no' => 'required',
            //'msr_price'   =>  'required',
            //'price' => 'required',
            'made_in' => 'required',
            //'mnf_summary'   => 'required',
            //'color'   => 'required',
            //'weight' => 'required',
            //'unit_price'   =>  'required',
            //'dimenstions'   =>  'required',
            //'dimenstions_length'   =>  'required',
            //'dimenstions_width'   =>  'required',
            //'dimenstions_height'   =>  'required',
            //'dimenstions_girth'   =>  'required',
            //'features'   =>  'required',
            //'spect'   =>  'required',
            //'how_to_use_text'   =>  'required',
            //'how_to_use_video'   =>  'required',
            //'online_url'   =>  'required',
            //'product_web_url'   =>  'required',
            //'mnf_url'   =>  'required',
            'exlcude_from_feed'   =>  'required',
            'hide_price'   =>  'required',
            'register_to_view'   =>  'required',
            //'age_resticted'     => 'required',
        );
        #check validation 
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }
        #prepare dimention field
        $dimenstion = array(
            'type' => $request->dimenstions,
            'height' => $request->dimenstions_height,
            'width' => $request->dimenstions_width,
            'length'  => $request->dimenstions_length,
            'grith' => $request->dimenstions_girth,
        );
        #prepare buy online url 
        $new_online_url = array();
        $online_url = $request->online_url;
        $online_price = $request->online_price;
        if(!empty($online_url)){
            foreach($online_url as $key => $value) {
              $temp_array =  array(
                'online_url' => $value,
                'price' => $online_price[$key]
              );
              $new_online_url[] = $temp_array; 
            }
        }
        //print_r($new_online_url );exit;
        #prepare product table field
        $product_param  = array(
            'bar_code'  =>  $request->bar_code,
            'category_id'  =>  $request->category,
            'subcategory_id'  =>  $request->sub_category,
            'name'  =>  $request->name,
            'title'  =>  $request->title,
            //'description'  =>  $request->summary,
            'image' =>  $request->upload_img,
            'video' =>  $request->upload_video,
            'manufactured_by'  =>  $request->manufacture,
            'msr_price'  =>  $request->msr_price,
            //'price' => $request->price,
            'currency' => $request->currency,
            'made_in' => $request->made_in,
            'mnf_summary'   => $request->mnf_summary,
            'manufactured_port_no'  =>  $request->manufacture_port_no,
            'color_to_show'  =>  json_encode($request->color),
            'unit_price'  =>  $request->unit_price,
            'weight'  =>  $request->weight,
            'dimension'  =>  json_encode($dimenstion),
            'features_feed'  =>  $request->features,
            'spec_field'  =>  $request->spect,
            'how_to_use_text'   =>  $request->how_to_use_text,
            'how_to_use_video'   =>  $request->how_to_use_video,
            'buy_online_link' => json_encode($new_online_url),
            'web_page_link' => $request->product_web_url,
            'manufactured_web_page_link'  =>  $request->mnf_url,
            'exclude_from_feed'  =>  $request->exlcude_from_feed,
            'hide_price'  =>  $request->hide_price,
            'register_to_view'  =>  $request->register_to_view,
            'age_restricted'    => $request->age_resticted,
            'to_be_age_resticted' => $request->to_be_age_resticted,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
            'user_id' => Auth::user()->id,
            'link_id' => $this->random_strings(11),
        );

        //print_r($product_param);exit;
        $id = DB::table('product')->insertGetId($product_param);
        if($id){
             #notification to admin
            $user_obj = User::find(Auth::user()->id);
            $user_model = new User;
            $details = [
                'from' => $user_obj->id,
                'to' => $user_model->get_admin_id(),
                'type' => 'New G-Paged ',
                'message' =>'Hi admin new G-Pages added by '.$user_obj->name.'!',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ];
            DB::table('notifications')->insert($details);
            //$user_obj->notify(new MyNotification($details));
            //activity log
            $activity_param = array(
                'user_id' => $user_obj->id,
                'activity' => $request->name." gpage is created!",
                'type' => 'New gpages created',
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            DB::table('user_activity')->insert($activity_param);

            Session::flash('success', 'Product has been added successfully!');
            return redirect(url('creator/dashboard'));
        }else{
            Session::flash('error', 'Some things went wrong.Please try again!');
            return redirect()->back()->withInput();
        }
    }
    public function gpages_list(){
        $id = Auth::user()->id;
        $product_model = new Product;
        $status = array(2,3,3);
        $data = [
            'title' => 'List of Gpages',
            'meta_description' => 'Your Gpages',
            'pagetitle' => 'Created G-pages',
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status),
            'total_pages' =>  $product_model->total_created_page_by_user_id($id),

        ];
        //print_r($data);
        //exit;
        return view('layouts.gpages_list',$data);
    }

    public function edit_product($id)
    {   
        $product_model = new Product;
        $country = new Country;
        $data = [
            'title' => 'Edit Product Gpage',
            'meta_description' => 'Gfects Creator Dashboard Edit your Product Gpage',
            'pagetitle' => 'Edit your Gpage',
            'heading' => 'Edit your Gpage',
            'pass' => 'edit',
            'product' => Product::find($id),
            'category' => ProductCategory::all(),
            'subcategory' => ProductSubcategory::all(),
            'country' => $country->all_country(),
            'currency' => $product_model->currency_list(),

        ];
        return view('layouts.creatordash',$data);
    }
    
    public function edit_product_post(Request $request){
        $steps = $request->steps;
        $id = $request->id;
        $product_model = new Product;
        if($steps == 1){
            $product_param  = array(
                'bar_code'  =>  $request->bar_code,
                'category_id'  =>  $request->category,
                'subcategory_id'  =>  $request->sub_category,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if($steps == 2){
            $product_param  = array(
                'name'  =>  $request->name,
                'title'  =>  $request->title,
                'description'  =>  $request->summary,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if($steps == 3){
            $dimenstion = array(
                'type' => $request->dimenstions,
                'height' => $request->dimenstions_height,
                'width' => $request->dimenstions_width,
                'length'  => $request->dimenstions_length,
                'grith' => $request->dimenstions_girth,
            );
            $product_param  = array(
                'manufactured_by'  =>  $request->manufacture,
                'made_in'   => $request->made_in,
                'mnf_summary' => $request->mnf_summary,
                'msr_price'  =>  $request->msr_price,
                //'price' => $request->price,
                'currency' => $request->currency,
                'manufactured_port_no'  =>  $request->manufacture_port_no,
                'color_to_show'  =>  json_encode($request->color),
                'unit_price'  =>  $request->unit_price,
                'weight'  =>  $request->weight,
                'dimension'  =>  json_encode($dimenstion),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if($steps == 4){
          $product_param  = array(
            'image' =>  $request->upload_img,
            'video' =>  $request->upload_video,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        );  
        }else if($steps == 5){
            $product_param  = array(
                'features_feed'  =>  $request->features,
                'spec_field'  =>  $request->spect,
                'how_to_use_text'   =>  $request->how_to_use_text,
                'how_to_use_video'   =>  $request->how_to_use_video,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if($steps == 6){
            #prepare buy online url 
            $new_online_url = array();
            $online_url = $request->online_url;
            $online_price = $request->online_price;
            if(!empty($online_url)){
                foreach($online_url as $key => $value) {
                  $temp_array =  array(
                    'online_url' => $value,
                    'price' => $online_price[$key]
                  );
                  $new_online_url[] = $temp_array; 
                }
            }
            $product_param  = array(
                'buy_online_link' => json_encode($new_online_url),
                'web_page_link' => $request->product_web_url,
                'manufactured_web_page_link'  =>  $request->mnf_url,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
        }else if($steps == 7){
            $product_param  = array(
            'exclude_from_feed'  =>  $request->exclude_from_feed,
             'hide_price'  =>  $request->hide_price,
             'register_to_view'  =>  $request->register_to_view,
             'age_restricted'    => $request->age_resticted,
             'to_be_age_resticted' => $request->to_be_age_resticted,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
            );
        }
            //dd($product_param);
        if(DB::table('product')->where('id', $id)->update($product_param)){
            #notification to admin
            $user_obj = User::find(Auth::user()->id);
            $user_model = new User;
            $details = [
                'from' => $user_obj->id,
                'to' => $user_model->get_admin_id(),
                'type' => 'Gpages status',
                'message' =>'Hi admin Gpages status updated by '.$user_obj->name.'!',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ];
            //$user_obj->notify(new MyNotification($details));
            DB::table('notifications')->insert($details);
            $response['status'] = true;
            $response['msg'] = "Data has been updated.";


            //user activity log
            $gpages_name = $product_model->product_name_by_id($id);
            $activity_param = array(
                'user_id' => $user_obj->id,
                'activity' =>  $gpages_name." gpage is updated!",
                'type' => 'Gpages updated',
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            DB::table('user_activity')->insert($activity_param);


            Session::flash('updateproduct',  $gpages_name." gpage is updated!");

            return redirect(url('/creator/edit-product/'.$id));
        }else{
            $response['status'] = false;
            $response['msg'] = "Internal server error.";
        }

    }

    public function delete_product(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('product')->where('id', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Gpage has been deleted successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid product id.";
        }
        echo json_encode($response);
        exit;

    }

    public function draft_list(){

        $id = Auth::user()->id;
         $status = array(1);
        $product_model = new Product;
        $data = [
            'title' => 'List of Gpages',
            'meta_description' => 'Your Gpages',
            'pagetitle' => 'Created G-pages',
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status),
            'total_pages' =>  $product_model->total_created_page_by_user_id($id),

        ];
        return view('layouts.draft_list',$data);
    }

     public function preview_gpages($id)
    {   
        $product_model = new Product;
        $country = new Country;
        $data = [
            'title' => 'Preview Gpages',
            'meta_description' => 'Gfects Creator Dashboard Preview your Product Gpage',
            'pagetitle' => 'Preview Gpages',
            'heading' => 'Preview your Gpage',
            'pass' => 'preview-gpages',
            'product' => $product_model->product_details_by_id($id),
            'category' => ProductCategory::all(),
            'subcategory' => ProductSubcategory::all(),
            'country' => $country->all_country(),
            'currency' => $product_model->currency_list(),

        ];
        return view('layouts.creatordash',$data);
    }
    function imagecopymerge_alpha($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct){
        // creating a cut resource
        $cut = imagecreatetruecolor($src_w, $src_h);

        // copying relevant section from background to the cut resource
        imagecopy($cut, $dst_im, 0, 0, $dst_x, $dst_y, $src_w, $src_h);

        // copying relevant section from watermark to the cut resource
        imagecopy($cut, $src_im, 0, 0, $src_x, $src_y, $src_w, $src_h);

        // insert cut resource to destination image
        imagecopymerge($dst_im, $cut, $dst_x, $dst_y, 0, 0, $src_w, $src_h, $pct);
    }


    public function goverview($id)
    {
        $u_id = Auth::user()->id;
        $product_model = new Product;
        $country = new Country;
        $pngImage = \QrCode::format('png')
            ->size(500)->errorCorrection('H')
            ->generate('http://goog.com');
        $image_1 = imagecreatefrompng(asset('/public/img/Gts.png'));
        $image_2 = imagecreatefromstring($pngImage);
        imagealphablending($image_1, true);
        imagesavealpha($image_1, true);
        imagecopy($image_1, $image_2, 100, 100, 50, 50, 400, 400);


        ob_start(); // Let's start output buffering.
        imagejpeg($image_1); //This will normally output the image, but because of ob_start(), it won't.
        $contents = ob_get_contents(); //Instead, output above is saved to $contents
        ob_end_clean();

        $data = [
            'title' => 'Gpages Overveiw',
            'meta_description' => 'Overview your Gpage',
            'pagetitle' => 'G-page Quick view',
            'product' => $product_model->product_details_by_id($id),
            'category' => ProductCategory::all(),
            'subcategory' => ProductSubcategory::all(),
            'country' => $country->all_country(),
            'currency' => $product_model->currency_list(),
            'list' => $product_model->product_details_by_id($id),
            'gpages' => $product_model->gpages_stats_by_user_id($u_id),
            'id' => $id,
            'qrimage' => $contents,

            #'id' => Hashids::encode(3),

        ];


        return view('layouts.gpage_page1',$data);
    }

    public function publish_gpages(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('product')->where('id',$id)->update(['status'=> 2,'updated_at'=> date('Y-m-d H:i:s')])){
                 #notification to admin
                $user_obj = User::find(Auth::user()->id);
                $user_model = new User;
                $details = [
                    'from' => $user_obj->id,
                    'to' => $user_model->get_admin_id(),
                    'type' => 'Gpages status',
                    'message' =>'Hi admin Gpages published by '.$user_obj->name.'!',
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                DB::table('notifications')->insert($details);
                //$user_obj->notify(new MyNotification($details));
                $response['status'] = true;
                $response['msg'] = "Gpage has been published successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid gpages id.";
        }
        echo json_encode($response);
        exit;
    }

    public function comment_list(){

        $id = Auth::user()->id;
        $comment_model = new ProductComment;
        
        $data = [
            'title' => 'Comment List',
            'meta_description' => 'Gfects Creator Dashboard Comment List',
            'pagetitle' => 'Gpage Comments List',
            'heading' => 'Comment List',
            'pass' => 'comment-list',
            'comment_list' => $comment_model->comment_list_by_user_id($id),

        ];
        return view('layouts.create',$data);
    }
    
    public function comment_exchange(Request $request){

        $id = $request->page_id;
        $comment_model = new ProductComment;
        
        $data = [
            'title' => 'Comment Exchange',
            'meta_description' => 'Gfects Creator Dashboard Comment Exchange',
            'pagetitle' => 'Gpage Comments Exchange',
            'heading' => 'Comment Exchange',
            'pass' => 'comment-view',
            'comment_list' => $comment_model->comment_list_by_page_id($id),
            #'common_func_help' => App\Helpers\Common_func,

        ];
        return view('layouts.create',$data);
    }
    
    public function message_list()
    {
        $id = Auth::user()->id;
        $message_chat_model = new MessageChat;
        $data = [
            'title' => 'Message List',
            'meta_description' => 'Gfects Creator Dashboard Message from your Product Gpage',
            'pagetitle' => 'Gpages Message List',
            'heading' => 'Message List',
            'pass' => 'message-list',
            'message_list' => $message_chat_model->get_chat_by_creator_id($id),

        ];
        
        return view('layouts.creatordash',$data);
    }

    public function reply_to_comment(Request $request){
        $comment_id = $request->comment_id;
        $message = $request->message;
        $reciver_id = $request->reciver_id; 
        if(isset($comment_id) && !empty($comment_id)){
            $param = array(
                'comment_id' => $comment_id,
                'reply_msg' => $message,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            if(DB::table('product_comment_reply')->insert($param)){
                DB::table('product_comment')->where('serial_number',$comment_id)->update(['reply_status'=> 1,'updated_at'=> date('Y-m-d H:i:s')]);
                $response['status'] = true;
                $response['msg'] = "Message sent successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid comment id.";
        }
        if (isset($request->red))
        {
            //return redirect(url('creator/comment-exchange/'.$request->page_id))->with($response['status'] , $response['msg']);
            echo json_encode($response);

        }else {
            echo json_encode($response);
        }
        exit;
    }
    public function delete_comment(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            DB::table('product_comment_reply')->where('comment_id', '=', $id)->delete();
            if(DB::table('product_comment')->where('serial_number', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Comment has been deleted successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid product id.";
        }
        echo json_encode($response);
        exit;

    }
    public function reply_to_message(Request $request){
        $message_id = $request->message_id;
        $message = $request->message;
        $reciver_id = $request->reciver_id; 
        if(isset($message_id) && !empty($message_id)){
            $param = array(
                'message_id' => $message_id,
                'reply_msg' => $message,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            if(DB::table('product_message_reply')->insert($param)){
                DB::table('product_message')->where('serial_number',$message_id)->update(['reply_status'=> 1,'updated_at'=> date('Y-m-d H:i:s')]);
                $response['status'] = true;
                $response['msg'] = "Message sent successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid message id.";
        }
        echo json_encode($response);
        exit;
    }
    /*public function delete_message(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            DB::table('product_message_reply')->where('message_id', '=', $id)->delete();
            if(DB::table('product_message')->where('serial_number', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Message has been deleted successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid product id.";
        }
        echo json_encode($response);
        exit;

    }*/
    public function delete_message(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('message_chat')->where('serial_number', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Message has been deleted successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid chat id !";
        }
        echo json_encode($response);
        exit;

    }
    
    
    //support section
    public function send_support()
    {
        if(Auth::check()){
        $data = [
            'title' => 'Support Message sender',
            'meta_description' => 'Gfects Creator Dashboard Support Messagesender ',
            'pagetitle' => 'Send support Message between you and Admin',
            'heading' => 'Send a support Message',
            'pass' => 'send-support-message',

        ];
        
        return view('layouts.create',$data);
        }else{
            Session::flash('error', 'Please login to send suport message!');
            return redirect('/');
        }
    }
    
    public function support_list()
    {
        $id = Auth::user()->id;
        $support_model = new Support;
        $data = [
            'title' => 'Support Message List',
            'meta_description' => 'Gfects Creator Dashboard Support Message List ',
            'pagetitle' => 'Support Message between you and Admin',
            'heading' => 'Support Message',
            'pass' => 'support-list',
            'message_list' => $support_model->support_list_by_user_id($id,'sender'),

        ];
        
        return view('layouts.create',$data);
    }
    
    public function support_message_exchange(Request $request){
        $support_model = new Support;
        $support_id = $request->support_id;
        $data = [
            'title' => 'Support Message List',
            'meta_description' => 'Gfects Creator Dashboard Support Message List ',
            'pagetitle' => 'Support Message between you and Admin',
            'heading' => 'Support Message',
            'pass' => 'support-message-exchange',
            'support' => $support_model->get_support_message_by_id($support_id),
            'support_response' => $support_model->get_support_message_response_by_id($support_id),

        ];
        
        return view('layouts.create',$data);
    }
    public function support_response(Request $request){
        $message = $request->message;
        $name = $request->name;
        $email = $request->email;

       if (isset($request->id))
       {
           $id=$request->id;
       }else {
           $id=0;

       }
       $x=0;
       //dd($id);

        $reciver_id = $request->reciver_id;
        //$id = $request->id;
        $date = date("Y-m-d H:i:s");
        if (isset($request->about))
        {
            $subject=$request->about;
        }else {
            $subject ='not';
        }
        $param = array(
            'subject'=> $subject,
            'sender_id' => Auth::user()->id,
            'reciver_id' => $reciver_id,
            'message' => $message,
            'parent_id' => $id,
            'message' => $message,
            'created_at' => $date,
            'updated_at' => $date
        );
        //print_r($param);exit;
       /* $data = array(
          'to' => $email ,
          'from' => Auth::user()->email,
          'subject' => "G-Page Support Message",
          'msg' => $message,
          'name' => $name,
        );
        Mail::send('email.web_support',$data, function($message) use ($data) {
           $message->to($data['to'])->subject($data['subject']);
           $message->from($data['from'],'Gfects');
        });*/
        if( DB::table('support')->insert($param)){
            DB::table('support')->where('serial_number', $id)->update(['reply_status'=>1, 'updated_at'=>date('Y-m-d H:i:s')]);
            $response['status'] = true;
            Session::flash('success', 'Support message has been sent!');
            $response['msg'] ="Support message has been sent!";

        }else{
            Session::flash('error', 'Internal server error!');
            $response['status'] = false;
            $response['msg'] ="Internal server error";
        }
        if ($id ==0){
            return redirect(url('/creator/support-list'))->with($response['status'], $response['msg']);
        }else {
            echo json_encode($response);
        }

    }
    public function delete_support_message(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('support')->where('serial_number', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Message has been deleted successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid support id.";
        }
        echo json_encode($response);
        exit;

    }
    public function qrcode_list()
        {
        $id = Auth::user()->id;
        $product_model = new Product;
        $data = [
            'title' => 'Qrcode List',
            'meta_description' => 'Gfects Creator Dashboard Qrcode List from your Product Gpage',
            'pagetitle' => 'Gpages Qrcode List',
            'heading' => 'gpages Qrcode List',
            'pass' => 'qrcode-list',
            'list' => $product_model->gpages_list_by_user_id($id,array('status'=>3)),

        ];
        
        return view('layouts.creatordash',$data);
    }
    public function gpages_qrcode(Request $request){
        $id = $request->id;
        $data['title'] = 'Gpages Qrcode';
        $product_model = new Product;
        $data['list'] = $product_model->product_details_by_id($id);
        return view('creators.gpages_qrcode',$data);
    }
    
    public function gpages_stats()
    {
        $id = Auth::user()->id;
        
        $product_model = new Product;
        $status = array(1,2,3);
        $data = [
            'title' => 'Gpages Stats',
            'meta_description' => 'Gfects Creator Dashboard Stats from your Product Gpage',
            'pagetitle' => 'Gpages stats List',
            'heading' => 'gpages stats List',
            'pass' => 'gpages-stats',
            'gpages' => $product_model->gpages_stats_by_user_id($id),

        ];
        
        return view('layouts.creatordash',$data);
    }
    
    
    public function gpages_info(Request $request){
        $product_id = $request->id;
        $product_model = new Product;
        $product = $product_model->product_details_by_id($product_id);
        $data['title'] = 'Gpages Info';
        $data['product'] = $product;
        return view('creators.gpages_info',$data);
    }
    public function product_commentlist(Request $request){
        $page_id = $request->page_id;
        $response['status'] = true;
        $product_model = new Product;
        $response['comment_list'] = $product_model->get_total_commentlist_by_page_id($page_id);
        if(count($response['comment_list'])){
            $view = View::make('creators.ajax.comment_history',$response);    
            $contents = $view->render();
            $response['content'] = $contents;
            $response['status'] = true;
            $response['msg'] = 'Data found!';
        }else{
            $response['status'] = false;
            $response['msg'] = 'Data not found!';
        }
        echo json_encode($response);
    }
    public function random_strings($length_of_string) { 
        //$str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'; 
        //return substr(str_shuffle($str_result),  0, $length_of_string); 
        return substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $length_of_string);
    }
    ##################message chat by creator to user ####################################
    public function message_chat(Request $request)
    {
        $message_chat_model = new MessageChat;
        $user_model = new User;
        $data = [
            'title' => 'Message Chat',
            'meta_description' => 'Gfects Creator Dashboard Message from your Product Gpage',
            'pagetitle' => 'Gpages Message',
            'heading' => 'Message List',
            'pass' => 'message-view',
            'user_id' => $request->id,
            'chat_list' => $message_chat_model->get_chat_by_creator_id_and_user_id($request->id, Auth::user()->id),
            'user' => $user_model->get_user_details_by_id($request->id),

        ];
        
        return view('layouts.creatordash',$data);
    }

    public function chat(Request $request)
    {
        $reciver_id = $request->reciver_id;
        $msg = $request->msg;
        $sender_id = Auth::user()->id; 
        if($msg == ''){
        $response['message'] = "Message can not be empty!";
        $response["status"] = false;
        return json_encode($response);
        return true;
        }
        $param =array(
            'reciver_id' => $reciver_id,
            'sender_id' => $sender_id,
            'message' => $msg,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        );
        if(DB::table('message_chat')->insert($param)){
            $response['status'] = true;
            $response['msg'] = "Message has been sent!";
            $response['result'] = '';
        }else{
            $response['message'] = "Internal server error!";
            $response["status"] = false;
        }
        echo json_encode($response);
        exit;
    }
    //publisher home page
    public function publisher_details(Request $request)
    {
        $id = Auth::user()->id;
        $product_model = new Product;
        $user_model = new User;
        $data['title'] = 'Publiser Dashboard';
        $data['total_comments'] = $product_model->total_gpages_comments_by_creator_id($id);
        $data['total_views'] = $product_model->total_gpages_views_by_creator_id($id);
         $data['total_like'] = $product_model->get_total_like_by_creator_id($id);
        $data['total_unlike'] = $product_model->get_total_unlike_by_creator_id($id);
        $data['gpages_list'] = $product_model-> gpages_list_by_user_id($id,$status = array(2,3));
        $last_login= User::get_last_login($id);
        $data['time_ago'] = Common_func::time_ago($last_login);
        $data['user'] = $user_model->get_user_details_by_id($id);
        $data['followers'] = $product_model->get_total_followers_by_publisher_id($id);
        if(Auth::check()){
            $data['follow_status'] =  $product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('creators.creator_home',$data);
    }
    public function test(){
        return $this->random_strings(11);
    } 
}
