<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use File;
use View;
class FileUploadController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
        //$this->middleware('auth',['except' => array('/')]);
    }
    public function file_upload(Request $request)
    {
	    if($request->hasFile('custom_name')) {
	      $folder_name = $request->post('folder_name');
	      $type = $request->post('type');
	      $filenameWithExt = $request->file('custom_name')->getClientOriginalName();
	      $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
	      $extension = $request->file('custom_name')->getClientOriginalExtension();
	      $time = time();
	      $fileNameToStore = $time.'.'.$extension;
	      if($type == 'image'){
	      	$destinationFolder = "uploads/".$folder_name."/image";
	      }else if($type == 'video'){
	      	$destinationFolder = "uploads/".$folder_name."/video";
	      }else{
	      	$destinationFolder = "uploads/attachment";
	      }
	      $destinationPath = public_path($destinationFolder);
	      if (!file_exists($destinationPath)) {
	      	File::makeDirectory($destinationPath, $mode = 0777, true, true);
		  }
	      $response['url'] =  $destinationFolder."/".$fileNameToStore;
	      $response['status'] = true;
	      $response['msg'] = 'File has been uploaded!';
	      $response['name'] = $fileNameToStore;
	      $response['id'] = $time;
	      $request->file('custom_name')->move($destinationPath, $fileNameToStore);
	      if($type == 'image'){
	      	$view = View::make('creators.ajax.image_div',$response);   
	      }else{
	      	$view = View::make('creators.ajax.video_div',$response);   
	      }
	      $content = $view->render();
    	  $response['content'] = $content;
	    }else{
	      $response['status'] = false;
	      $response['msg'] = 'File can not be empty!';
	    }
	    echo json_encode($response);
	    exit;
    }
    
}
