<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use LaravelQRCode\Facades\QRCode;
use Validator;

class QrcodeController extends Controller
{
    const DATETIME_FORMAT = 'Ymd\THis\Z';

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }
    public function getCodeString($dateTimeStart ,$dateTimeEnd,$summary,$description,$location)
    {
        //$response = "BEGIN:VCALENDAR\n";
        //$response .= "VERSION:1.0\n";
        $response = "BEGIN:VEVENT\n";

        $response .= "DTSTART:" . $dateTimeStart->format(self::DATETIME_FORMAT). "\n";
        $response .= "DTEND:" . $dateTimeEnd->format(self::DATETIME_FORMAT) . "\n";

        $response .= "SUMMARY:{$summary}\n";
        if ($description) {
            $response .= "DESCRIPTION:{$description}\n";
        }
        if ($location) {
            $response .= "LOCATION:{$location}\n";
        }

        $response .= "END:VEVENT\n";
        $response .= "END:VCALENDAR";

        return $response;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data = [
            'title' => 'Qr Code Generator',
            'meta_description' =>'Create static Qr codes for free'
        ];


        //dd($data);

        return view('layouts.qrCODEcreate', $data);
    }


    /*
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function store(Request $request)
    {
        $tempLocation = public_path().'/img/qrcodes/';

        $data['format'] = 'png';
        $data['Margin'] = 2;
        $data['size'] = 18;
        //$data['img_file'] = "gfx_qr".time().'.'.$data['format']; >> removing forname
        $data['img_file'] = time().'.'.$data['format'];
        $data['form_type'] = request('form_type');

        
        //Create png file to be edited 
        file_put_contents($tempLocation.$data['img_file'], base64_decode(00000));

         
        switch ($data['form_type']) {
            case "web":

                $data['form_type'] = 'url';

                $validator= \Validator::make(request()->all(), [
                        'web_add' => 'required|string|min:6|max:50'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['body'] = $request->input('web_add');
                    //dd($data['body']);

                    //\QrCode::url('Welcome to kerneldev.com!');
                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->generate($data['body']);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);


                }
                break;
            case "text":

                $data['form_type'] = 'tex';

                $validator= \Validator::make(request()->all(), [
                        'text_msg' => 'required|string|min:3|max:250'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['body'] = $request->input('text_msg');
                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->generate($data['body']);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);


                }
                break;
            case "phone":

                $data['form_type'] = 'pho';

                $validator= Validator::make(request()->all(), [
                        'phone_num' => 'required|numeric'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['num'] = $request->input('phone_num');

                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->phoneNumber($data['num']);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);
                }
                break;
            case "sms":

                $data['form_type'] = 'sms';


                $validator= \Validator::make(request()->all(), [
                        'sms_phone' => 'required|numeric',
                        'sms_message' => 'nullable|string|min:3|max:150'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['to'] = $request->input('sms_phone');
                    $data['body'] = !empty($request->input('sms_message')) ? $request->input('sms_message') : '';


                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->SMS($data['to'],$data['body']);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);
                }
                break;
            case "email":

                $data['form_type'] = 'ema';

                $validator= \Validator::make(request()->all(), [
                        'email' => 'required|string|email|max:55',
                        'email_message' => 'nullable|string|min:3|max:250'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['to'] = $request->input('email');
                    $data['subject'] = !empty($request->input('email_subject')) ? $request->input('email_subject') : '';
                    $data['body'] = !empty($request->input('email_message')) ? $request->input('email_message') : '';
                    //dd($data);
                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->email($data['to'],$data['subject'],$data['body']);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);
                }
                break;
            case "geo":

                $data['form_type'] = 'geo';

                $validator= \Validator::make(request()->all(), [
                        'latitude' => 'required|string|max:55',
                        'latitude' => 'nullable|string|min:3|max:55'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['latitude'] = $request->input('latitude');
                    $data['Longitude'] = $request->input('Longitude');
                    #$data['body'] = !empty($request->input('email_message')) ? $request->input('email_message') : '';
                    //dd($data);
                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->geo($data['latitude'],$data['Longitude']);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);
                }
                break;
            case "wif":

                $data['form_type'] = 'wif';

                $validator= \Validator::make(request()->all(), [
                        'Wifi_name' => 'required|string|min:3|max:55',
                        'password' => 'nullable|string|min:4',
                        'encryption' => 'required|not_in:0'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{

                    $data['encryption'] = $request->input('encryption');
                    $data['Wifi_name'] = $request->input('Wifi_name');
                    $data['password'] = !empty($request->input('password')) ? $request->input('password') : '';

                    //dd($data);
                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->wifi([
                            'encryption' =>  $data['encryption'],
                            'ssid' => $data['Wifi_name'],
                            'password' => $data['password'],
                            'hidden' => 'Whether the network is a hidden SSID or not.'
                        ]);
                    \Image::make($pngImage)->save($tempLocation.$data['img_file']);
                }
                break;
            case "cal":

                $data['form_type'] = 'cal';

                $validator= \Validator::make(request()->all(), [
                        'Event_title' => 'required|string|min:3|max:55',
                        'Start_date' => 'required|date',
                        'Start_time' => 'required|date_format:H:i',
                        'Ending_Date' => 'required|date',
                        'Ending_Time' => 'required|date_format:H:i',
                        'Event_description' => 'nullable|string|min:4',
                        'Event_address' => 'nullable|string|min:4'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{
                    
                    $data['start'] = new \DateTime($request->input('Start_date').' '.$request->input('Start_time'));
                    $data['end'] = new \DateTime($request->input('Ending_Date').'-'.$request->input('Ending_Time'));#<<<<<<<<<<-----to be completed
                    $data['Event_title'] = !empty($request->input('Event_title')) ? $request->input('Event_title') : '';

                    // Optional params
                    $data['Event_description'] = !empty($request->input('Event_description')) ? $request->input('Event_description') : '';
                    $data['Event_address'] = !empty($request->input('Event_address')) ? $request->input('Event_address') : '';
                    $query =self::getCodeString($data['start'],$data['end'],$data['Event_title'],$data['Event_description'],$data['Event_address']);

                    $pngImage = \QrCode::format('png')
                        ->size(500)->errorCorrection('H')
                        ->generate($query);
                    $pngimage = QRCode::calendar($data['start'], $data['end'], $data['Event_title'], $data['Event_description'], $data['Event_address'])
                        ->setSize(4)
                        ->setMargin(2)
                        ->setOutfile($tempLocation.$data['img_file'])
                        ->png();


                }
                break;
            case "con":

                $data['form_type'] = 'con';

                $validator= \Validator::make(request()->all(), [
                        'first_name' => 'required|string|min:2|max:55',
                        'last_name' => 'required|string|min:2|max:55',
                        'company' => 'nullable|string|min:2|max:55',
                        'con_title' => 'nullable|string|min:2|max:55',
                        'con_email' => 'nullable|string|email|max:55',
                        'con_phone' => 'nullable|string|min:2|max:55',
                        'fax' => 'nullable|string|min:2|max:55',
                        'address' => 'nullable|string|min:4|max:55',
                        'city' => 'nullable|string|min:2|max:55',
                        'state' => 'nullable|string|min:2|max:55',
                        'zip' => 'nullable|string|min:2|max:55',
                        'country' => 'nullable|string|min:2|max:55',
                        'web' => 'nullable|string|min:2|max:55',
                        'birth' => 'nullable|date',
                        'note' => 'nullable|string|min:2|max:55'
                    ]);

                if($validator->fails()) {
                            return back()
                                        ->withErrors($validator)
                                        ->withInput()
                                        ->with('form_type',$data['form_type']);
                }else{
                    
                    $data['first_name'] = $request->input('first_name');
                    $data['last_name'] = $request->input('last_name');
                    #$data['company'] = !empty($request->input('company')) ? $request->input('company') : '';
                    $data['con_title'] = !empty($request->input('con_title')) ? $request->input('con_title') : '';
                    $data['con_email'] = !empty($request->input('con_email')) ? $request->input('con_email') : '';
                    $data['con_phone'] = !empty($request->input('con_phone')) ? $request->input('con_phone') : '';
                    $data['fax'] = !empty($request->input('fax')) ? $request->input('fax') : '';
                    $data['address'] = !empty($request->input('address')) ? $request->input('address') : '';
                    $data['city'] = !empty($request->input('city')) ? $request->input('city') : '';
                    $data['state'] = !empty($request->input('state')) ? $request->input('state') : '';
                    $data['zip'] = !empty($request->input('zip')) ? $request->input('zip') : '';
                    $data['country'] = !empty($request->input('country')) ? $request->input('country') : '';
                    #$data['web'] = !empty($request->input('web')) ? $request->input('web') : '';
                    #$data['birth'] = !empty($request->input('birth')) ? $request->input('birth') : '';
                    #$data['note'] = !empty($request->input('note')) ? $request->input('note') : '';
//                    $wordAddress = [
//                            'type' => 'work',
//                           'pref' => false,
//                           'street' => $data['address'],
//                           'city' => $data['city'],
//                           'state' => $data['state'],
//                           'country' => $data['country'],
//                           'zip' => $data['zip']
//                        ];


//                    $workPhone = [
//                            'type' => 'work',
//                            'number' => $data['con_phone'],
//                            'cellPhone' => false
//                        ];

//                    $homePhone = [
//                            'type' => 'home',
//                            'number' => $data['fax'],
//                            'cellPhone' => false
//                        ];


                    // Personal Information
                    $firstName = $data['first_name'];
                    $lastName = $data['last_name'];
                    $title = $data['con_title'];
                    $email = $data['con_email'];

                    // Addresses
                    $wordAddress = [
                        'type' => 'work',
                        'pref' => false,
                        'street' => $data['address'],
                        'city' => $data['city'],
                        'state' =>  $data['state'],
                        'country' => $data['country'],
                        'zip' => $data['zip']
                    ];

                    $addresses = [ $wordAddress];


                    $homePhone = [
                        'type' => 'home',
                        'number' => $data['con_phone'],
                        'cellPhone' => false
                    ];

                    $tempLocation = public_path().'/img/qrcodes/';
                    $data['format'] = 'png';
                    $data['Margin'] = 2;
                    $data['size'] = 18;
                    //$data['img_file'] = "gfx_qr".time().'.'.$data['format']; >> removing forname
                    $data['img_file'] = time().'.'.$data['format'];
                    $data['form_type'] = request('form_type');

                    $phones = [$homePhone];

                    $pngImage = QRCode::vCard($firstName, $lastName, $title, $email, $addresses, $phones)
                        ->setErrorCorrectionLevel('H')
                        ->setSize(4)
                        ->setMargin(2)
                        ->setOutfile($tempLocation.$data['img_file'])
                        ->png();




                }
                break;
        }

        ///////////>>>>>>>>>>>delete old imgs<<<<<<<<<<<<<<<\\\\\\\\\\\\\


        // Collect a list of files in a $tempLocation (modify this to your usage)
        collect(\File::files($tempLocation))->map(function($file) {
            return [
                'file' => $file,
                'basename' => pathinfo($file)['filename']
            ];
        // Filter out the non-numeric files and those that are before now
        })->filter(function($a) {
            $timeout = time() - 10;
            return is_numeric($a['basename']) && $a['basename'] < $timeout;
        // Delete each file that is outdated
        })->each(function($file) {
            try { unlink($file['file']); } catch(Exception $e) { $data['img_file'] = 'delete old file error'; }
        });




        ############## created qr code count ##################
        $file_location = 'storage/app/jsondata.json';
        // Read File
        $jsonString = file_get_contents(base_path($file_location));
        $array = json_decode($jsonString, true);
        
        $getCount = $array['qr_codes_created'];

        $array['qr_codes_created'] = $getCount + 1;
        $array[$data['form_type']] = $array[$data['form_type']] + 1;
        //dd($array);

        // Write File
        $newJsonString = json_encode($array, JSON_PRETTY_PRINT);
        file_put_contents(base_path($file_location), stripslashes($newJsonString));
        #########################################################



        //dd($data);
        return redirect( 'Qr-code-generator/')->withInput()->with('img_file',$data['img_file'])->with('form_type',$data['form_type']);

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
