<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
Use Validator;
use Mail;
use DB;
use Session;
use Hash;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }
    #this function is used for send password reset link.
  public function forgetpassword(){
    $data['title'] = 'Forget password';
    return view('users.auth.email', $data);
  }
  #this function is used for send password reset link to user
  public function forgetpassword_post(Request $request)
  {
    $data = array('email'=>$request->email);
    $validator = Validator::make($data,['email' => 'required|email']);
    //check validation 
    if ($validator->fails())
    {
        return redirect()->back()->withErrors($validator->errors());
    }
    $check_user = $user=DB::table('users')->where('email',$request->email)->get()->toArray();
    if(!$check_user){
      Session::flash('login_error', 'Enter email address does not exist.');
      return redirect('user/forgetpassword');
    }
    $to = $request->email;
    $site_url = url('/');
    $string_key = microtime()."_".$to;
    $token = Hash::make($string_key);
    $link = $site_url.'/user/resetpassword?token='.$token;
    $data = array(
      'link'=> $link,
      'to' => $to ,
      'from' => 'info@gfects.com',
      'subject' => 'Gfects forget password link.',

    );
    $current_date = date('Y-m-d H:i:s');
    $expiry_date = date('Y-m-d H:i:s', strtotime('+2 day', strtotime( $current_date)));
    #send email
    Mail::send('email.resetpassword', $data, function($message) use ($data) {
       //$message->to('backup.rkgupta@gmail.com', $data['name'])->subject($data['subject']);
       $message->to($data['to'])->subject($data['subject']);
       $message->from($data['from'],'Gfects');

    });

    #update user table password token 
    DB::table('users')
    ->where('id', $check_user[0]->id)
    ->update(['forget_token_expired_at'=> $expiry_date,'forgetpassword_token'=>$token,'updated_at'=>$current_date]);
    Session::flash('success', 'Password reset link has been sent to your email.Check your inbox.');
    return redirect('user/forgetpassword');
  }

  #this function is used for show reset password form
  public function resetpassword(Request $request)
  {
    $data['token'] = $request->token;
    $data['title'] = 'Reset password';
    $check_user = $user=DB::table('users')->where('forgetpassword_token',$request->token )->get()->toArray();
    if(!$check_user){
      Session::flash('error', 'Sorry, your token is invalid!');
      return redirect('user/forgetpassword');
    }
    return view('users.auth.resetpassword',$data);
  }

  #this function is used for reset password action
  public function resetpassword_post(Request $request)
  {
    $data = array('password'=>$request->password, 'password_confirmation'=>$request->password_confirmation);
    $validator = Validator::make($data,[
      'password' => 'min:6|alpha_num|required_with:password_confirmation|confirmed',
      'password_confirmation'=>'required'
    ]);
    //check validation 
    if ($validator->fails())
    {
      return redirect()->back()->withErrors($validator);
    }
    $password = Hash::make($request->password);
    $token = $request->token;
    $check_user = $user=DB::table('users')->where('forgetpassword_token',$token )->get()->toArray();
    //print_r($check_user);exit;
    if(!$check_user){
      Session::flash('error', 'Sorry, your token is invalid!');
      return redirect('user/forgetpassword');
    }
    #update user table password
    $today = strtotime(date("Y-m-d H:i:s"));
    $expire_date = strtotime($check_user[0]->forget_token_expired_at);

    if($expire_date >= $today){
        DB::table('users')
      ->where('id', $check_user[0]->id)
      ->update([
        'forgetpassword_token'=>'',
        'updated_at'=>date("Y-m-d H:i:s"),
        'password'=>$password,
      ]);
      Session::flash('success', 'Your password has been reset successfully!');
      return redirect('user/login');
    }else{
      Session::flash('error', 'Sorry, Your token has expired.Please try again!');
      return redirect('user/forgetpassword');
    }
  }
}
