<?php

namespace App\Http\Controllers\User\Auth;

use App\User;
use App\Http\Controllers\Controller;
use App\UserDetails;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Session;
use Mail;
use Auth;
use App\Country;
use Laravel\Socialite\Facades\Socialite;
class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }
    public function showRegisterForm()
    {
      $data = [
        'title' => 'Home',
        'meta_description' =>''
      ];
      $country = new Country;
      $data['country'] = $country->all_country();
      return view('users.auth.register',$data);
    }
    public function register(Request $request){
        $user_model = new User;
        $token = str_random(40);
        //validation rules params
        $rules  = array(
            'first_name'=>  'required',
            'last_name' =>  'required',
            'dob'       =>  'required',
            'email'     =>  'required|email|unique:users',
            'username'     =>  'required|unique:users',
            'password' => 'min:6|alpha_num|required_with:password_confirmation|confirmed',
            'password_confirmation' => 'required',
        );
        //data field parms
        $data = array(
            'first_name'=>$request->first_name,
            'last_name' =>$request->last_name,
            'dob'       =>$request->dob,
            'email'     =>  $request->email,
            'username'     =>  $request->username,
            'password' => trim($request->password),
            'password_confirmation' => trim($request->password_confirmation),
        );
        //validate field
        $validator = Validator::make($data,$rules);
        if($validator->fails()){
          //print_r($validator->errors());
          //exit;
          return redirect()->back()->withErrors($validator->errors())->withInput();
        }
        //user tables field params
        $user = new User();
        $user->name=$request->first_name." ".$request->last_name;
        $user->first_name =$request->first_name;
        $user->last_name =$request->last_name;
        $user->email=$request->email;
        $user->username= $request->username;
        $user->role= 3;
        $user->password =Hash::make($request->password);
        $user->date_of_birth =$request->dob;
        $user->profile_picture='';
        $user->register_by = 'email';
        $user->country =$request->country;
        $user->state =$request->state;
        $user->created_at =date("Y-m-d H:i:s");
        $user->updated_at =date("Y-m-d H:i:s");
        $user->verify_token = $token;
        $user->save();



//        $user_param = array(
//            'name' => $request->first_name." ".$request->last_name,
//            'first_name' => $request->first_name,
//            'last_name' => $request->last_name,
//            'email' => $request->email,
//            'username' => $request->username,
//            'role' => 3,
//            'password' => Hash::make($request->password),
//            'date_of_birth' => $request->dob,
//            'profile_picture' => '',
//            'register_by'   => 'email',
//            'country' => $request->country,
//            'state' =>$request->state,
//            'created_at' => date("Y-m-d H:i:s"),
//            'updated_at' => date("Y-m-d H:i:s"),
//            'verify_token' => $token,
//        );
//        $id = DB::table('users')->insertGetId($user_param);
//        $user = new User();
        //dd($user->id);
        if($user->id){
            //user detilas tables field params
            $user_details_param = array(
                'user_id'   =>  $user->id,
                'account_type' => 0,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            $userDetail = New UserDetails();
            $userDetail->user_id =$user->id;
            $userDetail->account_type = 0;
            $userDetail->created_at =date("Y-m-d H:i:s");
            $userDetail->updated_at = date("Y-m-d H:i:s");
            $userDetail->save();


            //DB::table('user_details')->insert($user_details_param );
            //send verification mail to user.
            $data = array(
              'name'=> $request->first_name,
              'link'=> url('/').'/user/email-verification/'.$token,
              'to' => $request->email,
              'from' => 'ravindra@coretechies.com',
              'subject' => 'Gfects account activation link.',

            );
//            Mail::send('email.verifyUser', $data, function($message) use ($data) {
//               $message->to($data['to'], $data['name'])->subject($data['subject']);
//               $message->from($data['from'],'Gfects');
//            });
            Session::flash('success', 'You have been register successfully.Please, verify your email address by clicking on the link in the email we just sent you.');
            return redirect(url('user/login'));
        }else{
            Session::flash('success', 'Some things went wrong.Pls try again!');
            return redirect(url('user/register'));
        }
    }
    //this function is used for verify user email 
    public function verifyEmail($token){
      if(!empty($token)){
          $users=User::where('verify_token',$token)->get();
       // $users = DB::table('users')->select('email','email_verified_at')->where('verify_token',$token)->get()
        if(count($users) >0){
          if(!empty($users[0]->email_verified_at)){
            Session::flash('success', 'You account have already activated!');
            return redirect(url('user/login'));
          }
          $users[0]->email_verified_at =date('Y-m-d H:i:s');
          $users[0]->status =1;
          $users[0]->save();

          //$users[0]->update(['email_verified_at' => date('Y-m-d H:i:s'),'status' => 1]);
          Session::flash('success', 'You have been successfully activated your account!');
          return redirect(url('user/login'));
        }else{
          Session::flash('error', 'Sorry, Your token is invalid!');
          return redirect(url('user/login'));
        }
      }else{
          Session::flash('error', 'Sorry, Your token is invalid!');
          return redirect(url('user/login'));
      }     
    }
  }
