<?php

namespace App\Http\Controllers\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Product;
use App\ProductComment;
use App\User;
use App\Helpers\Common_func;
use App\MessageChat;
use Auth;
use DB;
use Session;
use Validator;
use Hash;
class UserController extends Controller
{
    public function __construct()
    {   
        //$this->middleware('user');
        $this->product_model = new Product;
        $this->comment_model = new ProductComment;
        $this->user_model = new User;
    }

    

    public function index()
    {
        $id = Auth::user()->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'User page',
            'meta_description' => 'Gfects user',
            'pass' => 'home',
            'published_gpages' => $product_model->total_created_page_by_user_id($id,2),
            'approved_gpages' => $product_model->total_created_page_by_user_id($id,3),
            'total_likes' => $product_model->total_gpages_like_by_creator_id($id),
            'total_unlike' => $product_model->get_total_unlike_by_creator_id($id),
            'total_comments' => $product_model->total_gpages_comments_by_creator_id($id),
            'total_views' => $product_model->total_gpages_views_by_creator_id($id),
            'gpages_list' => $product_model->favourite_gpages_list_by_user_id($id),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'followers' => $this->product_model->get_total_followers_by_publisher_id($id),

        ];
        if(Auth::check()){
            $data['follow_status'] = $this->product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('layouts.userHomeView',$data);
    }
    
    
     public function user_activity(Request $request){
        $id = Auth::user()->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'User Activity',
            'meta_description' => 'Gfects user activities',
            'pass' => 'activities',
            'gpages_list' => $product_model->favourite_gpages_list_by_user_id($id),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'user_details' => $this->user_model->get_user_details_by_id($id),
            'activity_list' => $this->user_model->get_user_activity_by_user_id($id),

        ];
        return view('layouts.userHomeView',$data);
    }
    
    public function profile_info(Request $request)
    {
        $id = Auth::user()->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'Edit Profile',
            'meta_description' => 'Gfects user info',
            'pass' => 'profile_info',
            'gpages_list' => $product_model->favourite_gpages_list_by_user_id($id),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'user_details' => $this->user_model->get_user_details_by_id($id),
            'activity_list' => $this->user_model->get_user_activity_by_user_id($id),

        ];
        return view('layouts.userHomeView',$data);
    }
    
    
    public function publisher_details(Request $request)
    {
        $id = $request->id;
        $product_model = new Product;
        $data['title'] = 'Publiser Dashboard';
        $data['total_comments'] = $product_model->total_gpages_comments_by_creator_id($id);
        $data['total_views'] = $product_model->total_gpages_views_by_creator_id($id);
         $data['total_like'] = $product_model->get_total_like_by_creator_id($id);
        $data['total_unlike'] = $product_model->get_total_unlike_by_creator_id($id);
        $data['gpages_list'] = $product_model-> gpages_list_by_user_id($id,$status = array(2,3));
        $last_login= User::get_last_login($id);
        $data['time_ago'] = Common_func::time_ago($last_login); 
        $data['user'] = $this->user_model->get_user_details_by_id($id);
        $data['followers'] = $this->product_model->get_total_followers_by_publisher_id($id);
        if(Auth::check()){
            $data['follow_status'] = $this->product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('users.publisher_dashboard',$data);
    }
    
    public function user_page(Request $request)
    {
        $id = $request->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'User home',
            'meta_description' => 'Gfects user home',
            'pass' => 'home',
            'published_gpages' => $product_model->total_created_page_by_user_id($id,2),
            'approved_gpages' => $product_model->total_created_page_by_user_id($id,3),
            'total_like' => $product_model->get_total_like_by_creator_id($id),
            'total_unlike' => $product_model->get_total_unlike_by_creator_id($id),
            'total_comments' => $product_model->total_gpages_comments_by_creator_id($id),
            'total_views' => $product_model->total_gpages_views_by_creator_id($id),
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status = array(2,3)),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'followers' => $this->product_model->get_total_followers_by_publisher_id($id),

        ];
        if(Auth::check()){
            $data['follow_status'] = $this->product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('layouts.userPage',$data);
    }
    
    public function gpages(Request $request)
    {
        $id = $request->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'User Gpages',
            'meta_description' => 'Gfects user gpages',
            'pass' => 'home',
            'published_gpages' => $product_model->total_created_page_by_user_id($id,2),
            'approved_gpages' => $product_model->total_created_page_by_user_id($id,3),
            'total_like' => $product_model->get_total_like_by_creator_id($id),
            'total_unlike' => $product_model->get_total_unlike_by_creator_id($id),
            'total_comments' => $product_model->total_gpages_comments_by_creator_id($id),
            'total_views' => $product_model->total_gpages_views_by_creator_id($id),
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status = array(2,3)),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'followers' => $this->product_model->get_total_followers_by_publisher_id($id),
            'auto_hide' => 'hide',

        ];
        if(Auth::check()){
            $data['follow_status'] = $this->product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('layouts.userPage',$data);
    }
    
    public function about_user(Request $request)
    {
        $id = $request->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'User Statement',
            'meta_description' => 'Gfects User Statement',
            'pass' => 'about_user',
            'published_gpages' => $product_model->total_created_page_by_user_id($id,2),
            'approved_gpages' => $product_model->total_created_page_by_user_id($id,3),
            'total_like' => $product_model->get_total_like_by_creator_id($id),
            'total_unlike' => $product_model->get_total_unlike_by_creator_id($id),
            'total_comments' => $product_model->total_gpages_comments_by_creator_id($id),
            'total_views' => $product_model->total_gpages_views_by_creator_id($id),
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status = array(2,3)),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'followers' => $this->product_model->get_total_followers_by_publisher_id($id),

        ];
        if(Auth::check()){
            $data['follow_status'] = $this->product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('layouts.userPage',$data);
    }
    public function comment_to_gpages(Request $request){
        $data['title'] = "Comment TO Gpages";
        $page_id = $request->id;
        $data['page_id'] = $page_id;
        $data['page_name'] = $this->product_model->product_name_by_id($page_id);
        return view('users.comment_to_gpage',$data);
    }
    public function gpages_comment(Request $request){
        $id = $request->page_id;
        $message = trim($request->message);
        $type = $request->type;
        $date = date('Y-m-d H:i:s');
        if($id){
            $param = array(
                'sender_id' => Auth::user()->id,
                'product_id' => $id,
                'comment'   => $message,
                'created_at' => $date,
                'updated_at' => $date,
            );
            if(isset($request->type) &&  $type == 'child'){
                $param['parent_id'] = $request->comment_id;
            }
            DB::table('product_comment')->insert($param);
            $response['status'] = true;
            $response['msg'] = "Your comment has been published!";
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = " Comment can not be empty!";
            echo json_encode($response);
            exit;
        }
    }
    public function gpages_likes(Request $request){
        $id = $request->page_id;
        $status = $request->like_status;
        $date = date('Y-m-d H:i:s');
        $sender_id = Auth::user()->id;
        if($id){
            if($this->product_model->is_page_like_by_user($sender_id,$id)){
                $param = array(
                    'like_status'   => $status,
                    'updated_at' => $date,
                );
                DB::table('product_likes')->where('product_id',$id)->where('sender_id',$sender_id)->update($param);
                $response['msg'] = $status == "no"?"Your have disliked this page!":"Your have liked this page!";
            }else{
                $param = array(
                    'sender_id' => $sender_id,
                    'product_id' => $id,
                    'like_status'   => $status,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('product_likes')->insert($param);
                $response['msg'] = "Your have liked this page!";
            }
            //user activity logs
            $gpages_name = $this->product_model->product_name_by_id($id);
            if($status == 'no'){
                $activity = "You have unlike the ". $gpages_name." gpages!";
            }else{
                $activity = "You have like the ". $gpages_name." gpages!";
            }
            $activity_param = array(
                'user_id' => $sender_id,
                'activity' => $activity,
                'type' => 'Gpages Likes/Unlikes',
                'created_at' => $date,
                'updated_at' => $date,
            );
            DB::table('user_activity')->insert($activity_param);
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Gpage id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
    public function gpages_fllows(Request $request){
        $id = $request->page_id;
        $date = date('Y-m-d H:i:s');
        $user_id = Auth::user()->id;
        if($id){
            if($this->product_model->is_page_flow_by_user($user_id,$id)){
                DB::table('product_fllowers')->where('user_id',$user_id)->where('product_id', $id)->delete();
                $response['msg'] = "Your have unfllow this page!";
            }else{
                $param = array(
                    'user_id' => $user_id,
                    'product_id' => $id,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('product_fllowers')->insert($param);
                $response['msg'] = "Your have fllow this page!";
            }
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Gpage id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
    public function follow_to_publisher(Request $request){
        $id = $request->publisher_id;
        $date = date('Y-m-d H:i:s');
        $user_id = Auth::user()->id;
        if($id){
            $user_name = $this->user_model->user_name_by_id($id);
            if($this->product_model->is_publisher_follow_by_user($user_id,$id)){
                DB::table('publisher_followers')->where('user_id',$user_id)->where('publisher_id', $id)->delete();
                $response['msg'] = "Publisher has been unfollowed bu you!";
                $activity = $user_name." is unfollowed by you!";
            }else{
                $param = array(
                    'user_id' => $user_id,
                    'publisher_id' => $id,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('publisher_followers')->insert($param);
                $response['msg'] = "Publisher has been followed by you!";
                $activity = $user_name." is followed by you!";
            }
            $activity_param = array(
                'user_id' => $user_id,
                'activity' => $activity,
                'type' => 'Gpages Follow/Unfollow',
                'created_at' => $date,
                'updated_at' => $date,
            );
            DB::table('user_activity')->insert($activity_param);
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Publisher id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
    public function add_to_gpages(Request $request){
        $id = $request->page_id;
        $date = date('Y-m-d H:i:s');
        $user_id = Auth::user()->id;
        if($id){
            $gpages_name = $this->product_model->product_name_by_id($id);
            if($this->product_model->is_pages_added_by_user($user_id,$id)){
                DB::table('favourite_gpages')->where('user_id',$user_id)->where('page_id', $id)->delete();
                $response['msg'] = "Page has been removed from your gpages!";
                $activity = $gpages_name." page has been removed from your gpages!";
            }else{
                $param = array(
                    'user_id' => $user_id,
                    'page_id' => $id,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('favourite_gpages')->insert($param);
                $response['msg'] = "Page has been added to your gpages!";
                $activity = $gpages_name." page has been has been added to your gpages!";
            }
            $activity_param = array(
                'user_id' => $user_id,
                'activity' => $activity,
                'type' => 'Gpages Added/remove',
                'created_at' => $date,
                'updated_at' => $date,
            );
            DB::table('user_activity')->insert($activity_param);
            $response['status'] = true;
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Gpage id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
    public function comment_likes(Request $request){
        $id = $request->comment_id;
        $status = $request->like_status;
        $date = date('Y-m-d H:i:s');
        $sender_id = Auth::user()->id;
        if($id){
            if($this->comment_model->is_comment_like_by_user($sender_id,$id)){
                $param = array(
                    'like_status'   => $status,
                    'updated_at' => $date,
                );
                DB::table('comment_likes')->where('comment_id',$id)->where('sender_id',$sender_id)->update($param);
                $response['msg'] = $status == "no"?"Your have disliked this comment!":"Your have liked this comment!";
            }else{
                $param = array(
                    'sender_id' => $sender_id,
                    'comment_id' => $id,
                    'like_status'   => $status,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('comment_likes')->insert($param);
                $response['msg'] = $status == "no"?"Your have disliked this comment!":"Your have liked this comment!";
            }
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Comment id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
    public function about(Request $request)
    {
        $id = $request->id;
        $request->session()->forget('product_name');
        $request->session()->forget('product_id');
        $data['title'] = 'About Product';
        $data['meta_description'] = '';
        $product_model = new Product;
        $product_model->update_page_view($id);
        $data['gpage'] = $product_model->product_details_by_id($id);
        $user_model = new User;
        $data['creator'] = $user_model->get_user_details_by_product_id($id);
        $request->session()->put('product_id', $id);
        $request->session()->put('product_name', $data['gpage']->name);
        //print_r($data);exit;
        $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
        return view('users.about', $data);
    }
    public function gfx_gpage_info(Request $request)
    {
        $request->session()->forget('product_name');
        $request->session()->forget('product_id');
        $data['title'] = 'About Product';
        $data['meta_description'] = '';
        $product_model = new Product;
        $id = $this->product_model->product_id_by_link_id($request->link_id);
        if(isset($id) && !empty($id)){
            $product_model->update_page_view($id);
            $data['gpage'] = $product_model->product_details_by_id($id);
            $user_model = new User;
            $data['creator'] = $user_model->get_user_details_by_product_id($id);
            $request->session()->put('product_id', $id);
            $request->session()->put('product_name', $data['gpage']->name);
            //print_r($data);exit;
            $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
            return view('users.about', $data);
        }else{
            return view('gfects.gpages_not_found', $data);
        }
    }
    public function product(Request $request)
    {
        $id = $request->id;
        $request->session()->forget('product_name');
        $request->session()->forget('product_id');
        $data['title'] = 'About Product';
        $data['meta_description'] = '';
        $product_model = new Product;
        $product_model->update_page_view($id);
        $data['gpage'] = $product_model->product_details_by_id($id);
        $user_model = new User;
        $data['creator'] = $user_model->get_user_details_by_product_id($id);
        $request->session()->put('product_id', $id);
        $request->session()->put('product_name', $data['gpage']->name);
        //print_r($data);exit;
        $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
        $data['comment_list'] = $product_model->get_total_commentlist_by_page_id($id);
        $data['selected_page_id'] = $request->id;
        return view('users.theme_1', $data);
    }
    
    public function buy(Request $request)
    {
        $data['title'] = 'Buy Product';
        $data['meta_description'] = '';
        $product_model = new Product;
        $data['gpage'] = $product_model->product_details_by_id($request->id);
        $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
        //print_r($data);exit;
        return view('users.buy', $data);
    }
     public function how_to_use(Request $request)
    {
        $data['title'] = 'How To Use';
        $data['meta_description'] = '';
        $product_model = new Product;
        $data['gpage'] = $product_model->product_details_by_id($request->id);
        return view('users.howtouse', $data);
    }
    public function others(Request $request)
    {
        $data['title'] = 'Others';
        $data['meta_description'] = '';
        $category_id = $this->product_model->product_category_id_by_product_id($request->id);
        $data['gpages_list'] = $this->product_model->gpages_list_by_status($status = array(2,3),$category_id);
        //print_r($data);exit;
        return view('users.others', $data);
    }
    public function gpages_comment_list(Request $request){
        $data['title'] = 'Gpages Comment Info';
        $data['meta_description'] = '';
        $product_model = new Product;
        $data['gpages_list'] = $product_model->gpages_list_by_status($status = array(2,3));
        $data['comment_list'] = $product_model->get_total_commentlist_by_page_id($request->id);
        $data['selected_page_id'] = $request->id;
        //print_r($data['comment_list']);exit();
        return view('users.gpages_comment',$data);
    }
    public function gpages_images(Request $request){
        $product_model = new Product;
        $data['gpage'] = $product_model->product_details_by_id($request->id);
        $data['title'] = 'Images';
        $data['meta_description'] = '';
        return view('users.gpages_gallery',$data);
    }
    public function publisher_info(Request $request){
        $user_model = new User ;
        $data['user'] = $user_model->get_user_details_by_id($request->id);
        $data['title'] = 'Publisher Info';
        $data['meta_description'] = '';
        return view('users.publisher_profile',$data);
    }
    public function profile_info_post(Request $request){
        $id = Auth::user()->id;;
        $rules  = array(
            'first_name'=>  'required',
            'last_name' =>  'required',
            'date_of_birth'       =>  'required',
        );
        $data = array(
            'first_name'=>$request->first_name,
            'last_name' =>$request->last_name,
            'date_of_birth'       =>$request->date_of_birth,
        );
        //validate field
        $validator = Validator::make($data,$rules);
        if($validator->fails()){
          return redirect()->back()->withErrors($validator->errors())->withInput();
        }
        if($request->hasFile('profile_pic')) {
          $filenameWithExt = $request->file('profile_pic')->getClientOriginalName();
          $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
          $extension = $request->file('profile_pic')->getClientOriginalExtension();
          $fileNameToStore = $filename.'_'.time().'.'.$extension;
          $destinationPath = public_path('profile_img');
          $request->file('profile_pic')->move($destinationPath, $fileNameToStore);
          $profile_image = asset("profile_img/".$fileNameToStore);
          $data['profile_picture'] = $profile_image;
        }
         //print_r($data);exit;
        DB::table('users')->where('id',$id)->update($data);
        Session::flash('success', 'User profile info has been updated!');
        return redirect(url('user/profile-info'));
    }
    public function change_password(Request $request){
        $data['title'] = 'Change Password';
        $data['meta_description'] = '';
        return view('users.change_password',$data);
    }
    public function change_password_post(Request $request){
        $id = Auth::user()->id;
        $conf_pass = trim($request->password_confirmation);
        $password = trim($request->new_password);
        $old_password = trim($request->old_password);
        $user = User::find($id);
        if(!Hash::check($old_password, $user->password)){
            Session::flash('error', 'Old password is wrong!');
            return back()->withInput();
        }
        if($password != $conf_pass){
            Session::flash('error', 'Password and confirm password is mismatch!');
            return back()->withInput();
        }
        $param = array(
            'password' => Hash::make($password),
            'created_at' => date("Y-m-d h:i:s"),
            'updated_at' => date("Y-m-d h:i:s"), 
        );
        DB::table('users')->where('id', $id)->update($param);
        Session::flash('success_changepassword', 'Password has been updated!');
        return redirect(url('user/change-password'));
    }
    public function update_notification_status(Request $request){
        $id = $request->id;
        if(DB::table('notifications')->where('id',$id)->update(['read_at' => date('Y-m-d H:i:s')])){
            $response['status'] = true;
            Session::flash('success', 'Notification has been read!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        //return json_encode($response);
        return redirect()->back();
    }
    public function notification_list(){
        //$data['notifications'] = User::notification_list_by_id(Auth::user()->id,'all'); 
        $data['notifications'] = User::notification_list_by_id(Auth::user()->id,'all'); 
        $data['title'] = 'Notifications';
        $data['meta_description'] = '';
        return view('users.notifications',$data);
    }
    public function delete_notification(Request $request){
        $id = $request->id;
        if(DB::table('notifications')->where('id', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Notification has been deleted successfully!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        return json_encode($response);
    }
    public function user_gpages()
    {
        $id = Auth::user()->id;
        $data['user_details'] = $this->user_model->get_user_details_by_id($id);
        $product_model = new Product;
        $data['title'] = 'User Gpages';
        $data['gpages_list'] = $product_model->favourite_gpages_list_by_user_id($id);
        return view('users.user_gpages',$data);
    }
    public function publisher_gpages(Request $request)
    {
        $id = $request->id;
        $data['user_details'] = $this->user_model->get_user_details_by_id($id);
        $product_model = new Product;
        $data['title'] = 'Publisher Gpages';
        $status = array(1,2,3);
        $data['gpages_list'] = $product_model->gpages_list_by_user_id($id, $status);
        return view('users.publisher_gpages',$data);
    }
    public function publisher_statement(Request $request)
    {
        $id=$request->id;
        $data['title'] = 'Publisher Statement';
        $data['user_details'] = $this->user_model->get_user_details_by_id($id);
        return view('users.publisher_statement',$data);
    }
    ##################message chat by n user ####################################
    public function message_chat(Request $request)
    {
        $data['title'] = 'Message Chat';
        $data['publisher_id'] = $request->id;
        $message_chat_model = new MessageChat;
        $data['chat_list'] = $message_chat_model->get_chat_by_user_id(Auth::user()->id); 
        $data['publisher'] = $this->user_model->get_user_details_by_id($request->id);
        //print_r($data);exit;
        return view('users.chat',$data);
    }
    public function message_view(Request $request)
    {
        $data['title'] = 'Message View';
        $data['publisher_id'] = $request->id;
        $message_chat_model = new MessageChat;
        $data['chat_list'] = $message_chat_model->get_chat_by_user_id(Auth::user()->id);
        $data['publisher'] = $this->user_model->get_user_details_by_id($request->id);
        //print_r($data);exit;
        return view('users.chat_view',$data);
    }

    public function chat(Request $request)
    {
        $reciver_id = $request->reciver_id;
        $msg = $request->msg;
        $sender_id = Auth::user()->id; 
        if($msg == ''){
        $response['message'] = "Message can not be empty!";
        $response["status"] = false;
        return json_encode($response);
        return true;
        }
        $param =array(
            'reciver_id' => $reciver_id,
            'sender_id' => $sender_id,
            'message' => $msg,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        );
        if(DB::table('message_chat')->insert($param)){
            $response['status'] = true;
            $response['msg'] = "Message has been sent!";
            $response['result'] = '';
        }else{
            $response['message'] = "Internal server error!";
            $response["status"] = false;
        }
        echo json_encode($response);
        exit;
    }
    public function delete_message(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('message_chat')->where('serial_number', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Message has been deleted successfully.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid chat id !";
        }
        echo json_encode($response);
        exit;

    }
    //user activity logs
    public function activities(Request $request){
        $id = $request->id;
        $product_model = new Product;
        $last_login= User::get_last_login($id);
        $data = [
            'title' => 'User Activity',
            'meta_description' => 'Gfects user activities',
            'pass' => 'activities',
            'published_gpages' => $product_model->total_created_page_by_user_id($id,2),
            'approved_gpages' => $product_model->total_created_page_by_user_id($id,3),
            'total_like' => $product_model->get_total_like_by_creator_id($id),
            'total_unlike' => $product_model->get_total_unlike_by_creator_id($id),
            'total_comments' => $product_model->total_gpages_comments_by_creator_id($id),
            'total_views' => $product_model->total_gpages_views_by_creator_id($id),
            'gpages_list' => $product_model->gpages_list_by_user_id($id,$status = array(2,3)),
            'time_ago' => Common_func::time_ago($last_login),
            'user_id' => $id,
            'user' => $this->user_model->get_user_info_by_id($id),
            'followers' => $this->product_model->get_total_followers_by_publisher_id($id),
            'activity_list' => $this->user_model->get_user_activity_by_user_id($id),

        ];
        if(Auth::check()){
            $data['follow_status'] = $this->product_model->is_publisher_follow_by_user(Auth::user()->id,$id);
        }else{
            $data['follow_status'] = 0;
        }
        return view('layouts.userPage',$data);
    }
    public function delete_activity(Request $request){
        $id= $request->id;
        if(isset($id) && !empty($id)){
            if(DB::table('user_activity')->where('serial_number', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Activity has been deleted successfully!";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid activity id !";
        }
        echo json_encode($response);
        exit;

    }
}
