<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class ProductComment extends Model
{
	protected $table = 'product_comment';
	
	public function comment_list_by_user_id($id)
	{
		$result = DB::table('product_comment as pc')
		->select('product.name as product_name','u1.username as reciver_name','u2.username as sender_name','pc.created_at','pc.comment','pc.serial_number as id','pc.sender_id','pc.reply_status','pc.product_id','product.id')
		->join('product', 'product.id', '=', 'pc.product_id')
		->where('product.user_id', $id)
		->join('users as u1', 'u1.id', '=', 'product.user_id')
		->join('users as u2', 'u2.id', '=', 'pc.sender_id')
		->groupBy('product.id')
		->orderBy('pc.created_at','desc')
		->get();
		
		
		return $result;
	}

	public function comment_list_by_page_id($page_id){
		$result = DB::table('product_comment as pc')
		->select('product.name as product_name','u1.username as reciver_name','u1.profile_picture as reciver_picture','u2.username as sender_name','u2.profile_picture as sender_picture','pc.created_at','pc.comment','pc.serial_number','pc.sender_id','pc.reply_status','pc.product_id','pc.parent_id','pc.created_at as reply_at')
		->join('product', 'product.id', '=', 'pc.product_id')
		->where('pc.product_id', $page_id)
		->join('users as u1', 'u1.id', '=', 'product.user_id')
		->join('users as u2', 'u2.id', '=', 'pc.sender_id')
		->orderBy('pc.created_at','asc')
		->get();
		return $result;
	}
	public function get_comment_details_by_comment_id($id)
	{
	    $result =ProductComment::select('product.name as product_name','u1.username as reciver_name','u2.username as sender_name','product_comment.created_at','product_comment.comment','pcr.reply_msg')
            ->where('product_comment.serial_number', $id)
            ->join('product', 'product.id', '=', 'product_comment.product_id')
            ->join('users as u1', 'u1.id', '=', 'product.user_id')
            ->join('users as u2', 'u2.id', '=', 'product_comment.sender_id')
            ->leftJoin('product_comment_reply as pcr', 'pcr.comment_id', '=', 'product_comment.serial_number')
            ->get();

//		$result = DB::table('product_comment as pc')
//		->select('product.name as product_name','u1.username as reciver_name','u2.username as sender_name','pc.created_at','pc.comment','pcr.reply_msg')
//		->where('pc.serial_number', $id)
//		->join('product', 'product.id', '=', 'pc.product_id')
//		->join('users as u1', 'u1.id', '=', 'product.user_id')
//		->join('users as u2', 'u2.id', '=', 'pc.sender_id')
//		->leftJoin('product_comment_reply as pcr', 'pcr.comment_id', '=', 'pc.serial_number')
//		->get();
		return $result;
	}
	public function get_total_comments_by_parent_id($id){
		$result = DB::table('product_comment')
		->select('serial_number')
		->where('parent_id',$id)
		->get()
		->count();
		return $result;
	}
	public function is_comment_like_by_user($user_id,$id){
		$result = DB::table('comment_likes')
		->select('serial_number')
		->where('comment_id',$id)
		->where('sender_id',$user_id)
		->get();
		if(count($result) > 0){
			return true;
		}else{
			return false;
		}
	}
	public function comment_like_status_by_user($user_id,$comment_id){
		$result = DB::table('comment_likes')
		->select('serial_number','like_status')
		->where('comment_id',$comment_id)
		->where('sender_id',$user_id)
		->get();
		if(count($result) > 0){
			return $result[0]->like_status;
		}else{
			return false;
		}
	}
	public function total_comment_likes_by_comment_id($id){
		$result = DB::table('comment_likes')
		->select('serial_number')
		->where('comment_id',$id)
		->where('like_status','yes')
		->get();
		if(count($result) > 0){
			return true;
		}else{
			return false;
		}
	}
	public function total_comment_unlikes_by_comment_id($id){
		$result = DB::table('comment_likes')
		->select('serial_number')
		->where('comment_id',$id)
		->where('like_status','no')
		->get();
		if(count($result) > 0){
			return true;
		}else{
			return false;
		}
	}
}
