<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class ProductMessage extends Model
{
	protected $table = 'product_message';
	public function message_list_by_user_id($id)
	{
		$result = DB::table('product_message as pm')
		->select('product.name as product_name','u1.username as reciver_name','u2.username as sender_name','pm.created_at','pm.message','pm.serial_number as id','pm.sender_id','pm.reply_status')
		->where('pm.reciver_id', $id)
		->join('product', 'product.id', '=', 'pm.product_id')
		->join('users as u1', 'u1.id', '=', 'pm.reciver_id')
		->join('users as u2', 'u2.id', '=', 'pm.sender_id')
		->get();
		return $result;
	}

	public function get_message_details_by_message_id($id)
	{
	    $result  = ProductMessage::select('product.name as product_name','u1.username as reciver_name','u2.username as sender_name','product_message.created_at','product_message.message','pmr.reply_msg')
            ->where('product_message.serial_number', $id)
            ->join('product', 'product.id', '=', 'product_message.product_id')
            ->join('users as u1', 'u1.id', '=', 'product_message.reciver_id')
            ->join('users as u2', 'u2.id', '=', 'product_message.sender_id')
            ->leftJoin('product_message_reply as pmr', 'pmr.message_id', '=', 'product_message.serial_number')
            ->get();

//		$result = DB::table('product_message as pm')
//		->select('product.name as product_name','u1.username as reciver_name','u2.username as sender_name','pm.created_at','pm.message','pmr.reply_msg')
//		->where('pm.serial_number', $id)
//		->join('product', 'product.id', '=', 'pm.product_id')
//		->join('users as u1', 'u1.id', '=', 'pm.reciver_id')
//		->join('users as u2', 'u2.id', '=', 'pm.sender_id')
//		->leftJoin('product_message_reply as pmr', 'pmr.message_id', '=', 'pm.serial_number')
//		->get();
		return $result;
	}
}
