@extends('layouts.admin')
@section('content')
<div class="main">
    <div class="subheader">
        <ul>
            <li>Admin</li>
        </ul>
    </div>
    <!-- MAIN CONTENT -->
    <div class="main-content">
        <div class="container-fluid">
            <!-- OVERVIEW -->
            <div class="panel panel-headline">
                <div class="panel-heading">
                    <h3 class="panel-title">Flagged Reason List</h3>
                    <a class="btn btn-primary" href="{{url('admin/flagged/add-reason')}}" style="float: right;margin-top: -31px;margin-right: 50px;">Add</a>
                </div>
            </div>
            <!-- END OVERVIEW -->
            <div class="row">
                <div class="col-md-12">
                    <!-- RECENT PURCHASES -->
                    <div class="panel">
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <div class="panel-body no-padding">
                            <div class="table-responsive">
                            <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: 50px;margin-left: 353px; display: none;" id="loader_img" />
                                <table class="table table-striped datatable">
                                    <thead>
                                        <tr>
                                            <th>#SN</th>
                                            <th>Name</th>
                                            <th>Created_at</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(count($reasons)>0)
                                            @foreach($reasons as $key => $value)
                                            <?php
                                                $len = 50;
                                                $str = $value->name;
                                                $tail = max(0, $len-10);
                                                $trunk = substr($str, 0, $tail);
                                                $trunk .= strrev(preg_replace('~^..+?[\s,:]\b|^...~', '...', strrev(substr($str, $tail, $len-$tail)))); 
                                                $dec_reason_id = \Crypt::encryptString($value->id);
                                            ?>
                                                <tr>
                                                    <td></td>
                                                    <td>{{$value->name}}</td>
                                                    <td>{{$value->created_at}}</td>
                                                    <td>
                                                       <a href="{{url('admin/flagged/edit-reason/'.$dec_reason_id)}}">
                                                        <span class="label label-success">Edit</span>
                                                       </a>
                                                        <span class="label label-danger delete_action" data-id="{{$value->id}}">Delete</span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- <div class="panel-footer">
                            <div class="row">
                                <div class=" text-right">
                                    <a href="#" class="btn btn-primary">View All</a>
                                </div>
                            </div>
                        </div> -->
                    </div>
                    <!-- END RECENT PURCHASES -->
                </div>
            </div>
        </div>
    </div>
    <!-- END MAIN CONTENT -->
    <script type="text/javascript">
    $(document).ready(function(){
        $('body').on('click', '.delete_action', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: 'Are You sure want to delete ?',
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        if(result){
                            $('#loader_img').css('display','block');
                            $.ajax({
                                type: "POST",
                                url: site_url+"/admin/flagged/delete-reason",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: {id: id},
                                success: function(res){
                                   $('#loader_img').css('display','none');
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                    setTimeout(function(){
                                       window.location.reload();
                                    }, 900);
                                      
                                   }else{
                                   toastr.error(data.msg);
                                    setTimeout(function(){
                                       // window.location.reload();
                                    }, 900);
                                   }
                                }
                            });
                            return true;
                        }
                    }
                });
            }
        });
    });
       
    </script>
</div>
@endsection