@extends('layouts.admin')
@section('content')
<div class="main">
    <div class="subheader">
        <ul>
            <li>Admin</li>
        </ul>
    </div>
    <!-- MAIN CONTENT -->
    <div class="main-content">
        <div class="container-fluid">
            <!-- OVERVIEW -->
            <!-- END OVERVIEW -->
            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-headline">
                        <div class="panel-heading">
                            <h3 class="panel-title">Rejected Approved Request Gpages</h3>
                        </div>
                    </div>
                    <!-- RECENT PURCHASES -->
                    <div class="panel">
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <div class="panel-body no-padding">
                            <div class="table-responsive">
                            <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: 50px;margin-left: 353px; display: none;" id="loader_img" />
                                <table class="table table-striped datatable">
                                    <thead>
                                        <tr>
                                            <th>#SN</th>
                                            <th>Product Name</th>
                                            <th>Barcode</th>
                                            <th>Username</th>
                                            <th>Account Type</th>
                                            <th>Last Updated</th>
                                            <th>Created At</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(count($gpages)>0)
                                            @foreach($gpages as $key => $value)
                                            <?php
                                                $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                                                $url_name = strtolower(preg_replace('/-+/', '-', $url_name)); 
                                            ?>
                                                <tr>
                                                    <td></td>
                                                    <!-- <td><a target="_blank" href="{{url('admin/gpage-info/'.$value->id)}}"><?=$value->name?></a></td> -->
                                                     <td><a target="_blank" href="{{url('product/'.$url_name.'/about/'.$value->id)}}"><?=$value->name?></a></td>
                                                    <td><?=$value->bar_code?></td>
                                                    <td><a target="_blank" href="{{url('admin/user-info/'.$value->user_id)}}"><?=$value->username?></a></td>
                                                    <td>
                                                        @if($value->account_type == 1)
                                                            <span class="label label-success">Publisher</span>
                                                        @elseif($value->account_type == 2)
                                                            <span class="label label-success">Agency</span>
                                                        @elseif($value->account_type == 3)
                                                            <span class="label label-success">Business</span>
                                                        @else
                                                            <span class="label label-success">User</span>
                                                        @endif
                                                    </td>
                                                    <td><?=$value->updated_at?></td>
                                                     <td><?=$value->created_at?></td>
                                                    <td>
                                                        @if($value->status == 1)
                                                            <span class="label label-success">Draft</span>
                                                        @elseif($value->status == 2)
                                                            <span class="label label-info">Submitted</span>
                                                        @elseif($value->status == 3)
                                                            <span class="label label-success">Approved</span>
                                                        @elseif($value->status == 4)
                                                            <span class="label label-success">Rejected</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <select class="form-control common_action" style="border-radius: 1px" name="common_action" data-user_id="{{$value->id}}" data-email_id="{{$value->email}}" data-status="{{$value->status}}" id="{{$value->id}}_div_action" data-product_id="{{$value->id}}">
                                                        <option value="">Choose</option>
                                                            <option value="3" <?= $value->status == 3?'selected=selected':''?>>
                                                                Approved
                                                            </option>
                                                            <option value="4" <?= $value->status == 4?'selected=selected':''?>>
                                                                Reject
                                                            </option>
                                                            <option value="5">
                                                                Delete
                                                            </option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- END RECENT PURCHASES -->
                </div>
            </div>
        </div>
    </div>
    <!-- contact form model -->
    <div class="modal fade" id="reject_request_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"  style="overflow:scroll;">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Reject approved request</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="message_reply_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form method="post" name="reject_request_model_frm" id="reject_request_model_frm">
            <div class="modal-body mx-3">
                <input type="hidden" name="user_id" id="user_id">
                <input type="hidden" name="product_id" id="product_id">
              <div class="md-form mb-4">
                <label data-error="wrong" data-success="right" for="form34">To</label>
                <input type="text" id="to" name="to" class="form-control" readonly>
              </div>
              <div class="md-form mb-4">
                <label data-error="wrong" data-success="right" for="form34">Subject</label>
                <input type="text" id="subject" name="subject" class="form-control">
              </div>
              <input type="hidden" name="message" id="message">
              <div class="md-form mb-4">
                <label data-error="wrong" data-success="right" for="form34">Message</label>
                <textarea id="message_ck" name="message_ck" class="form-control" style="min-height: 160px;"></textarea> 
              </div>
            </div>
            <div class="modal-footer d-flex justify-content-center">
              <input class="btn btn-primary" type="submit" value="Send"></button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- contact form model end here  -->
    <!-- END MAIN CONTENT -->
    <script type="text/javascript">
        $(document).ready(function(){
            CKEDITOR.replace( 'message_ck' );
            $('body').on('change', '.common_action', function(e) {
                var product_id = $(this).data('product_id');
                var user_id = $(this).data('user_id');
                var status = $("#"+user_id+"_div_action").val();
                var email = $(this).data('email_id');
                var message = 'Are you sure ?';
                //alert("status is:"+status);
                if(status == "3"){
                     message = 'Are you sure want to  approved request?';
                }else if(status == "4"){
                     message = 'Are you sure want to reject approved request ?';
                }else if(status == "5"){
                     message = 'Are you sure want to delete G-page ?';
                }else{
                    return true;
                }
                if(product_id != "" || product_id != undefined){
                    bootbox.confirm({
                        message: message,
                        buttons: {
                            cancel: {
                                label: '<i class="fa fa-times"></i> Cancel'
                            },
                            confirm: {
                                label: '<i class="fa fa-check"></i> Confirm'
                            }
                        },
                        callback: function (result) {
                            if(result){
                                if(status == 4){
                                    $("#to").val(email);
                                    $("#user_id").val(user_id);
                                    $("#product_id").val(product_id);
                                    $("#subject").val('Your G-Page Review Feedback');
                                    $("#message").val('');
                                    $("#reject_request_model").modal("toggle"); 
                                    return true;
                                }
                                if(status == 5){
                                    $('#loader_img').css('display','block');
                                    $.ajax({
                                        type: "POST",
                                        url: site_url+"/admin/delete-gpages",
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        },
                                        data: {product_id: product_id,status:status,user_id:user_id,email:email},
                                        success: function(res){
                                           $('#loader_img').css('display','none');
                                           var data = jQuery.parseJSON(res);
                                           if(data.status){
                                            //toastr.success(data.msg);
                                            setTimeout(function(){
                                               window.location.reload();
                                            }, 900);
                                              
                                           }else{
                                            //toastr.error(data.msg);
                                            setTimeout(function(){
                                                window.location.reload();
                                            }, 900);
                                           }
                                        }
                                    });
                                    return true;
                                }
                                $('#loader_img').css('display','block');
                                $.ajax({
                                    type: "POST",
                                    url: site_url+"/admin/update-gpages-status",
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    data: {product_id: product_id,status:status,user_id:user_id,email:email},
                                    success: function(res){
                                       $('#loader_img').css('display','none');
                                       var data = jQuery.parseJSON(res);
                                       if(data.status){
                                        //toastr.success(data.msg);
                                        setTimeout(function(){
                                           window.location.reload();
                                        }, 900);
                                          
                                       }else{
                                        //toastr.error(data.msg);
                                        setTimeout(function(){
                                            window.location.reload();
                                        }, 900);
                                       }
                                    }
                                });
                            }
                        }
                    });
                }
            });
            //message reply form submit
            $('form[id="reject_request_model_frm"]').validate({
                rules: {
                  to: 'required',
                  email: 'required',
                  message: 'required'
                },
                messages: {
                  to: 'Please enter to field.',
                  email: 'Please enter email field.',
                  message: 'Please enter message field'
                },
                submitHandler: function(form) {
                    //form.submit();
                    $("#message").val(CKEDITOR.instances['message_ck'].getData());
                    $(':input[type="submit"]').prop('disabled', true);
                    frm = $('#reject_request_model_frm');
                    $.ajax({
                        type: "POST",
                        url: site_url+"/admin/reject-message-to-publisher",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: frm.serialize(),
                        success: function(res){
                           $(':input[type="submit"]').prop('disabled', false);
                           var data = jQuery.parseJSON(res);
                           $("#reject_request_model").modal("toggle");
                           if(data.status){
                              //toastr.success(data.msg);
                              setTimeout(function(){
                                 window.location.reload();
                              }, 900);
                           }else{
                              setTimeout(function(){
                                 window.location.reload();
                              }, 900);
                           }
                        }
                    });
                }
            });
        })
    </script>
</div>
@endsection