@extends('layouts.landing')
@section('content')
      <style>
        header {
            height: 60px;
            background: linear-gradient(90deg, #2e6184, #5182a0);
        }
        
        .label-success {
            background: #f05b28;
            color: #fff
        }
        /*basic reset*/
        
        * {
            margin: 0;
            padding: 0;
        }
        /*form styles*/
        
        #msform {
            width: 530px;
            margin: 20px auto;
            text-align: center;
            position: relative;
        }
        
        #msform fieldset {
            background: white;
            border: 0 none;
            border-radius: 3px;
            box-shadow: 0 0 15px 1px rgba(0, 0, 0, 0.4);
            padding: 20px 30px;
            box-sizing: border-box;
            width: 80%;
            margin: 0 10%;
            /*stacking fieldsets above each other*/
            position: absolute;
        }
        /*Hide all except first fieldset*/
        
        #msform fieldset:not(:first-of-type) {
            display: none;
        }
        /*inputs*/
        
        #msform input,
        #msform select,
        #msform textarea {
            padding: 10px 15px;
            border: 1px solid #ccc;
            border-radius: 3px;
            margin-bottom: 10px;
            width: 100%;
            box-sizing: border-box;
            font-family: montserrat;
            color: #2C3E50;
            font-size: 13px;
            margin-top: 5px;
        }
        /*buttons*/
        #msform .error{
            color: red;
        }
        #msform .action-button {
            width: 100px;
            background: #2e6184;
            font-weight: bold;
            color: white;
            border: 0 none;
            border-radius: 1px;
            cursor: pointer;
            padding: 10px 5px;
            margin: 10px 5px;
        }
        
        #msform .action-button:hover,
        #msform .action-button:focus {
            box-shadow: 0 0 0 2px white, 0 0 0 3px #2e6184;
        }
        
        #msform input[type="color"] {
            width: 24px;
            padding: 0;
            margin: 0
        }
        
        #msform .plusme {
            width: 20px;
            padding: 0;
            margin: 0;
            height: 20px;
            text-align: center;
            display: inline-block;
            font-size: 11px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        
        #msform .plusme:hover {
            border: 1px solid #333;
            background: #333;
            color: #fff;
            border-radius: 4px;
        }
        /*headings*/
        
        .fs-title {
            font-size: 15px;
            text-transform: uppercase;
            color: #2C3E50;
            margin-bottom: 10px;
        }
        
        .fs-subtitle {
            font-weight: normal;
            font-size: 13px;
            color: #666;
            margin-bottom: 20px;
        }
        /*progressbar*/
        
        #progressbar {
            margin-bottom: 30px;
            overflow: hidden;
            /*CSS counters to number the steps*/
            counter-reset: step;
        }
        
        #progressbar li {
            list-style-type: none;
            color: #333;
            text-transform: uppercase;
            font-size: 9px;
            width: 48.93%;
            float: left;
            position: relative;
        }
        
        #progressbar li:before {
            content: counter(step);
            counter-increment: step;
            width: 20px;
            line-height: 20px;
            display: block;
            font-size: 10px;
            color: #333;
            background: white;
            border-radius: 3px;
            margin: 0 auto 5px auto;
        }
        /*progressbar connectors*/
        
        #progressbar li:after {
            content: '';
            width: 100%;
            height: 2px;
            background: white;
            position: absolute;
            left: -50%;
            top: 9px;
            z-index: 0;
            /*put it behind the numbers*/
        }
        
        #progressbar li:first-child:after {
            /*connector not needed before the first step*/
            content: none;
        }
        /*marking active/completed steps green*/
        /*The number of the step and the connector before it = green*/
        
        #progressbar li.active:before,
        #progressbar li.active:after {
            background: #2e6184;
            color: white;
        }
        
        #company {
            display: none
        }
        
        /*#add_info {
            display: none
        }*/
    </style>
<?php 
  if(session('social_data')){
    $user_data = session('social_data'); 
  }else{
    $user_data = array();
  }
  if(old('account_type') == 1 ){
    $min_height = '800px';
  }elseif ((old('account_type') == 2 || old('account_type') == 3)) {
      $min_height = '1220px';
  }else{
    $min_height = '800px';
  }
?> 
    <section class="seciton section-content" style="padding: 40px 0; min-height: {{$min_height}}">
        <div class="container-fluid">
            <div class="row">
                <div class="container">

                    <div class="row">
                        <div class="col-md-12">

                            <!-- multistep form -->
                            <form id="msform" method="POST" action="{{ url('register') }}" enctype="multipart/form-data">
                                <!-- progressbar -->
                                <ul id="progressbar">
                                    <li class="active">Basic Detail</li>
                                    <li>Advance Detail</li>

                                </ul>
                                <!-- fieldsets -->
                                <fieldset>
                                    <h2 class="fs-title">Basic Detail</h2>
                                    <h3 class="fs-subtitle">Step 1/2</h3>

                                    <a href="{{url('/')}}/auth/google" class="btn btn-sm" style="background: #da3d29; color:#fff"><i class="fab fa-google"></i>&nbsp; Signup with Google</a>
                                    <a href="{{url('/')}}/auth/linkedin" class="btn btn-sm" style="background: #0677b0; color:#fff"><i class="fab fa-linkedin"></i>&nbsp; Signup with Linkedin</a>
                                    <div class="clear">
                                        <br>
                                    </div>
                                    <!-- hidden form field value -->
                                    @csrf
                                    <input type="hidden" name="social_id" value="<?=$user_data?$user_data['id']:old('social_id')?>">
                                    <input type="hidden" name="provider" value="<?=$user_data?$user_data['provider']:old('provider')?>">
                                    <input type="hidden" name="social_image" value="<?=$user_data?$user_data['profile_pic']:old('social_image')?>">
                                    <!-- form field -->
                                    @if ($errors->has('first_name'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('first_name') }}</strong>
                                        </span>
                                    @endif
                                    <input type="text" id="first_name" name="first_name"  value="<?=$user_data?$user_data['first_name']:old('first_name')?>" placeholder="Last Name" />
                                     @if ($errors->has('last_name'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('last_name') }}</strong>
                                        </span>
                                    @endif
                                    <input type="text" id="last_name" name="last_name"  value="<?=$user_data?$user_data['last_name']:old('last_name')?>" placeholder="First Name" />
                                    @if ($errors->has('dob'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('dob') }}</strong>
                                        </span>
                                    @endif
                                    <input type="date" id="dob" name="dob"  value="<?=old('dob')?>" placeholder="DOB" />
                                    @if ($errors->has('email'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                     <span class="error" role="alert" id="email_error" style="display: none">
                                            <strong>Email is already registerd.</strong>
                                      </span>
                                    <input type="text" id="email" name="email"  value="<?=$user_data?$user_data['email']:old('email')?>" placeholder="Email Address" />
                                    @if ($errors->has('country'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('country') }}</strong>
                                        </span>
                                    @endif
                                    <select class="form-control" name="country" id="country" required autofocus>
                                        <option value="">Select Country</option>
                                        @if(count($country)>0)
                                          @foreach($country as $key=>$value)
                                            <option value="{{$value->id}}">{{$value->name}}</option>
                                          @endforeach
                                        @endif
                                    </select>
                                    <!-- <select>
                                        <option selected="" disabled="">State</option>
                                        <option></option>
                                    </select> -->
                                    @if ($errors->has('state'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('state') }}</strong>
                                        </span>
                                    @endif
                                    <select class="form-control" name="state" id="state" required autofocus>
                                    </select>
                                    @if ($errors->has('username'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('username') }}</strong>
                                        </span>
                                    @endif
                                    <span class="error" role="alert" id="username_error" style="display: none">
                                        <strong>Username is already in used.</strong>
                                    </span>
                                    <input type="text" id="username" name="username"  value="<?=old('username')?>" placeholder="Username" />
                                    @if ($errors->has('password'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                                    @endif
                                    <input type="password" id="password" name="password"  value="<?=old('password')?>" placeholder="Password" />
                                    @if ($errors->has('password_confirmation'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                                        </span>
                                    @endif
                                    <input type="password" id="password_confirmation" name="password_confirmation"  value="<?=old('password_confirmation')?>" placeholder="Confirm Password" />
                                    <input type="button" name="next" class="next action-button" value="Next" />
                                </fieldset>

                                <fieldset>
                                    <h2 class="fs-title">Advance Detail</h2>
                                    <h3 class="fs-subtitle">Step 2/2</h3>
                                    <label style="text-align: left; display: block">Profile Picture</label>
                                    @if ($errors->has('profile_pic'))
                                        <span class="error" role="alert">
                                            <strong>{{ $errors->first('profile_pic') }}</strong>
                                        </span>
                                    @endif
                                    <input type="file" id="profile_pic"  name="profile_pic" value="{{ old('profile_pic') }}" onchange="readURL(this,'','profile_pic_preview')" />
                                    <label style="text-align: left; display: block">Preview</label>
                                    <img id="profile_pic_preview" src="<?=$user_data?$user_data['profile_pic']:asset('/public/profile_img/no_image.png')?>" class="img" height="144" />
                                    <br>
                                    <label style="text-align: left; display: block">Account Type</label>
                                    <br>
                                    <div style="display:block; text-align: left">
                                        <input type="radio" name="account_type" id="pub" value="1" style="width: auto; margin-right: 5px" {{old('account_type') == '1'?'checked':'checked'}}> Publisher &nbsp;&nbsp;&nbsp;&nbsp;
                                        <input type="radio" name="account_type" id="agency" value="2" style="width: auto; margin-right: 5px" {{old('account_type') == '2'?'checked':''}}> Agency &nbsp;&nbsp;&nbsp;&nbsp;
                                        <input type="radio" name="account_type" id="biz" value="3" style="width: auto; margin-right: 5px" {{old('account_type') == '3'?'checked':''}}> Business &nbsp;&nbsp;&nbsp;&nbsp;
                                        You will be required to provide company details for agency and business account types.
                                    </div>
                                    <br>
                                    <div id="company">
                                        @if ($errors->has('company_name'))
                                            <span class="error" role="alert">
                                                <strong>{{ $errors->first('company_name') }}</strong>
                                            </span>
                                        @endif
                                        <input type="text" id="company_name" name="company_name"  value="<?=old('company_name')?>" placeholder="Company Name" />
                                        @if ($errors->has('company_title'))
                                            <span class="error" role="alert">
                                                <strong>{{ $errors->first('company_title') }}</strong>
                                            </span>
                                        @endif
                                        <input type="text" id="company_title" name="company_title"  value="<?=old('company_title')?>" placeholder="Company Title" />
                                        <div id="add_info">
                                            @if ($errors->has('company_street'))
                                                <span class="error" role="alert">
                                                    <strong>{{ $errors->first('company_street') }}</strong>
                                                </span>
                                            @endif
                                            <input type="text" id="company_street" name="company_street"  value="<?=old('company_street')?>" placeholder="Company Street" />
                                            @if ($errors->has('company_zip'))
                                                <span class="error" role="alert">
                                                    <strong>{{ $errors->first('company_zip') }}</strong>
                                                </span>
                                            @endif
                                            <input type="text" id="company_zip" name="company_zip"  value="<?=old('company_zip')?>" placeholder="Company Zip" />
                                            @if ($errors->has('company_country'))
                                              <span class="error" role="alert">
                                                  <strong>{{ $errors->first('company_country') }}</strong>
                                              </span>
                                            @endif
                                            <select class="form-control" name="company_country" id="company_country">
                                                <option value="">Select Country</option>
                                                @if(count($country)>0)
                                                  @foreach($country as $key=>$value)
                                                    <option value="{{$value->id}}">{{$value->name}}</option>
                                                  @endforeach
                                                @endif
                                            </select>
                                            @if ($errors->has('company_state'))
                                                <span class="error" role="alert">
                                                    <strong>{{ $errors->first('company_state') }}</strong>
                                                </span>
                                            @endif
                                           <select class="form-control" name="company_state" id="company_state">
                                           </select>
                                           @if($errors->has('company_city'))
                                                <span class="error" role="alert">
                                                    <strong>{{ $errors->first('company_city') }}</strong>
                                                </span>
                                            @endif  
                                            <select class="form-control" name="company_city" id="company_city">
                                            </select>
                                            @if ($errors->has('phone'))
                                                <span class="error" role="alert">
                                                    <strong>{{ $errors->first('phone') }}</strong>
                                                </span>
                                            @endif
                                            <input type="text" id="phone" name="phone"  value="<?=old('phone')?>" placeholder="Company Phone" />
                                            @if ($errors->has('company_email'))
                                                <span class="error" role="alert">
                                                    <strong>{{ $errors->first('company_email') }}</strong>
                                                </span>
                                            @endif
                                            <input type="hidden" id="company_email" name="company_email"  value="<?=old('company_email')?>" placeholder="Company Email" readonly />
                                        </div>
                                    </div>
                                    <input type="button" name="previous" class="previous action-button" value="Previous" />
                                    <input type="submit" name="submit_registation_btn" class="submit action-button" value="Submit" id="submit_registation_btn" />
                                </fieldset>
                            </form>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <script>
        //jQuery time
        var current_fs, next_fs, previous_fs; //fieldsets
        var left, opacity, scale; //fieldset properties which we will animate
        var animating; //flag to prevent quick multi-click glitches

        $(".next").click(function() {
            if(!custom_required('first_name')){
              toastr.error("Please enter first name!");
              return true;
            }else if(!custom_required('last_name')){
              toastr.error("Please enter last name!");
              return true;
            }else if(!custom_required('dob')){
              toastr.error("Please enter date of birth!");
              return true;
            }else if(!custom_required('email')){
              toastr.error("Please enter email address!");
              return true;
            }else if(!custom_required('country')){
              toastr.error("Please select country!");
              return true;
            }else if(!custom_required('state')){
              toastr.error("Please select state!");
              return true;
            }else if(!custom_required('username')){
              toastr.error("Please enter username!");
              return true;
            }else if(!custom_required('password')){
              toastr.error("Please enter password!");
              return true;
            }else if(!custom_required('password_confirmation')){
              toastr.error("Please enter confirm password!");
              return true;
            }
            if (animating) return false;
            animating = true;

            current_fs = $(this).parent();
            next_fs = $(this).parent().next();

            //activate next step on progressbar using the index of next_fs
            $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

            //show the next fieldset
            next_fs.show();
            //hide the current fieldset with style
            current_fs.animate({
                opacity: 0
            }, {
                step: function(now, mx) {
                    //as the opacity of current_fs reduces to 0 - stored in "now"
                    //1. scale current_fs down to 80%
                    scale = 1 - (1 - now) * 0.2;
                    //2. bring next_fs from the right(50%)
                    left = (now * 50) + "%";
                    //3. increase opacity of next_fs to 1 as it moves in
                    opacity = 1 - now;
                    current_fs.css({
                        'transform': 'scale(' + scale + ')'
                    });
                    next_fs.css({
                        'left': left,
                        'opacity': opacity
                    });
                },
                duration: 800,
                complete: function() {
                    current_fs.hide();
                    animating = false;
                },
                //this comes from the custom easing plugin
                easing: 'easeInOutBack'
            });
        });

        $(".previous").click(function() {
            if (animating) return false;
            animating = true;

            current_fs = $(this).parent();
            previous_fs = $(this).parent().prev();

            //de-activate current step on progressbar
            $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

            //show the previous fieldset
            previous_fs.show();
            //hide the current fieldset with style
            current_fs.animate({
                opacity: 0
            }, {
                step: function(now, mx) {
                    //as the opacity of current_fs reduces to 0 - stored in "now"
                    //1. scale previous_fs from 80% to 100%
                    scale = 0.8 + (1 - now) * 0.2;
                    //2. take current_fs to the right(50%) - from 0%
                    left = ((1 - now) * 50) + "%";
                    //3. increase opacity of previous_fs to 1 as it moves in
                    opacity = 1 - now;
                    current_fs.css({
                        'left': left
                    });
                    previous_fs.css({
                        'transform': 'scale(' + scale + ')',
                        'opacity': opacity
                    });
                },
                duration: 800,
                complete: function() {
                    current_fs.hide();
                    animating = false;
                },
                //this comes from the custom easing plugin
                easing: 'easeInOutBack'
            });
        });

        /*$(".submit").click(function() {
            return false;
        })*/
    </script>
    <a href="#" class="scanner-btn">
        <i class="fa fa-qrcode"></i>
    </a>
    <script>
        $(document).on('change', '[type="radio"][name="account_type"]', function() {
            var currentlyValue = $(this).val(); // Get the radio checked value
            if (currentlyValue == 2 || currentlyValue == 3) {
                //$(".company_info_section input").prop('required', true);
                $("#company").css('display', 'block');
                $('.section-content').css('min-height', '1280px');
            } else {
                //$(".company_info_section input").removeAttr('required');
                $("#company").css('display', 'none');
                $('.section-content').css('min-height', '800px');
            }
        });
        function readURL(input){
            var max_size = 1048576 * 4;
            var ext = input.files[0]['name'].substring(input.files[0]['name'].lastIndexOf('.') + 1).toLowerCase();
            if(ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg"){
            }else{
                //alert("Please upload only png|jpg|jpeg image.");
                toastr.warning('Please upload only png, jpg, jpeg image.');
                $('#profile_pic').val('');
                return false;
            }
            if(input.files[0].size >max_size){
                //alert("File size should be equal or less than 4MB");
                toastr.warning('File size should be equal or less than 4MB');
                $('#profile_pic').val('');
                return false;
            }
            if (input.files && input.files[0] && (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")){
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#profile_pic_preview').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }else{
                 //$('#img').attr('src', '/assets/no_preview.png');
            }
        }
        //registation form functionbality code
        $(document).ready(function(){
          $( "#company_email").val($( "#email").val()); 
          //change company address when email is changes
          $( "#email" ).keyup(function() {
            $( "#company_email").val($( "#email").val());
          });
          //check user email exist
          $('body').on('keyup blur change', '#email', function() {
            $("#email_error").css('display','none');
            $("#nav-f1 .continue_btn").prop("disabled", false);
            var email = $("#email").val().trim();
            $.ajax({
                type: "POST",
                url: site_url+"/ajax/check-email",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {email:email},
                success: function(res){
                   var data = jQuery.parseJSON(res);
                   if(data.status){
                      $("#email_error").css('display','block');
                      $("#nav-f1 .continue_btn").prop("disabled", true);

                   }
                }
            });
          });
          //check user is all ready exist or not
          $('body').on('keyup blur change', '#username', function() {
            $("#username_error").css('display','none');
            $("#nav-f1 .continue_btn").prop("disabled", false);
            var username = $("#username").val().trim();
            $.ajax({
                type: "POST",
                url: site_url+"/ajax/check-username",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {username:username},
                success: function(res){
                   var data = jQuery.parseJSON(res);
                   if(data.status){
                      $("#username_error").css('display','block');
                      $("#nav-f1 .continue_btn").prop("disabled", true);
                   }
                }
            });
          });
          //get state list by country id
          $('body').on('change', '#country', function() {
            var id = $("#country").val();
            $.ajax({
                type: "POST",
                url: site_url+"/ajax/get-states",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {id:id},
                success: function(res){
                   var data = jQuery.parseJSON(res);
                   if(data.status){
                      $("#state").html(data.content);
                   }
                }
            });
          });
          //get state list when company country is selected
          $('body').on('change', '#company_country', function() {
            var id = $("#company_country").val();
            $.ajax({
                type: "POST",
                url: site_url+"/ajax/get-states",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {id:id},
                success: function(res){
                   var data = jQuery.parseJSON(res);
                   if(data.status){
                      $("#company_state").html(data.content);
                   }
                }
            });
          });
          //get city list when company state is selected
          $('body').on('change', '#company_state', function() {
            var id = $("#company_state").val();
            $.ajax({
                type: "POST",
                url: site_url+"/ajax/get-cities",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {id:id},
                success: function(res){
                   var data = jQuery.parseJSON(res);
                   if(data.status){
                      $("#company_city").html(data.content);
                   }
                }
            });
          });
          //register form submit
          $('#submit_registation_btn').click(function(event) {
            event.preventDefault(); 
            var account_type = $("input[name='account_type']:checked").val();
            if(account_type == 2 || account_type == 3){
              //alert(account_type);
              if(!custom_required('company_name')){
                toastr.error("Please enter company name!");
                return true;
              }else if(!custom_required('company_title')){
                toastr.error("Please enter company title!");
                return true;
              }
                if(!custom_required('company_street')){
                toastr.error("Please enter company street!");
                return true;
                }else if(!custom_required('company_zip')){
                  toastr.error("Please enter company zip!");
                  return true;
                }else if(!five_digit_zip('company_zip')){
                   toastr.error("Please enter 5 digit zip code!");
                  return true;
                }else if(!custom_required('company_country')){
                  toastr.error("Please select company country!");
                  return true;
                }else if(!custom_required('company_state')){
                  toastr.error("Please select company state!");
                  return true;
                }else if(!custom_required('company_city')){
                  toastr.error("Please select company city!");
                  return true;
                }else if(!custom_required('phone')){
                  toastr.error("Please enter company phone!");
                  return true;
                }
                $("#msform").submit();
            }
            $("#msform").submit();
          });
        });
    </script>
@endsection

