@extends('layouts.main')
@section('content')
<style type="text/css">
   nav > .nav.nav-tabs{
   border: none;
   color:#fff;
   background:#272e38;
   border-radius:0;
   }
   nav > div a.nav-item.nav-link,
   nav > div a.nav-item.nav-link.active
   {
   border: none;
   padding: 18px 25px;
   color:#fff;
   background:#272e38;
   border-radius:0;
   }
   nav > div a.nav-item.nav-link.active:after
   {
   content: "";
   position: relative;
   bottom: -60px;
   left: -10%;
   border: 15px solid transparent;
   border-top-color: #e74c3c ;
   }
   .tab-content{
   background: #fdfdfd;
   line-height: 25px;
   border: 1px solid #ddd;
   border-top:5px solid #e74c3c;
   border-bottom:5px solid #e74c3c;
   padding:30px 25px;
   }
   nav > div a.nav-item.nav-link:hover,
   nav > div a.nav-item.nav-link:focus
   {
   border: none;
   background: #e74c3c;
   color:#fff;
   border-radius:0;
   transition:background 0.20s linear;
   }
   .remove_click{
    pointer-events:none;
  }
</style>
<?php 
  if(session('social_data')){
    $user_data = session('social_data'); 
  }else{
    $user_data = array();
  }
?>
<div class="container">
   <div class="row">
      <div class="col-xs-12 " style="width: 100%;">
         <nav>
            <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
               <a class="nav-item nav-link active remove_click" id="nav-f1-tab" data-toggle="tab" href="#nav-f1" role="tab" aria-controls="nav-f1" aria-selected="true">Step 1/2</a>
               <!-- <a class="nav-item nav-link" id="nav-f2-tab" data-toggle="tab" href="#nav-f2" role="tab" aria-controls="nav-f2" aria-selected="false">Step 2/4</a>
               <a class="nav-item nav-link" id="nav-f3-tab" data-toggle="tab" href="#nav-f3" role="tab" aria-controls="nav-f3" aria-selected="false">Step 3/4</a> -->
               <a class="nav-item nav-link remove_click" id="nav-f2-tab" data-toggle="tab" href="#nav-f2" role="tab" aria-controls="nav-f2" aria-selected="false">Step 2/2</a>
            </div>
         </nav>
         <form method="POST" action="{{ url('register') }}" enctype="multipart/form-data" id="registation_frm">
            @csrf
            <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
               <div class="tab-pane fade show active" id="nav-f1" role="tabpanel" aria-labelledby="nav-f1-tab">
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right"></label>
                      <div class="col-md-6">
                          <a href="{{url('/')}}/auth/google" class="btn btn-primary">Google</a>
                          <a href="{{url('/')}}/auth/linkedin" class="btn btn-primary">Linkdin</a>
                      </div>
                    </div>
                    <input type="hidden" name="social_id" value="<?=$user_data?$user_data['id']:old('social_id')?>">
                    <input type="hidden" name="provider" value="<?=$user_data?$user_data['provider']:old('provider')?>">
                    <input type="hidden" name="social_image" value="<?=$user_data?$user_data['profile_pic']:old('social_image')?>">
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">First Name</label>
                      <div class="col-md-6">
                          <input id="first_name" type="text" class="form-control{{ $errors->has('first_name') ? ' is-invalid' : '' }}" name="first_name"  value="<?=$user_data?$user_data['first_name']:old('first_name')?>" required autofocus>

                          @if ($errors->has('name'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('name') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Last Name</label>
                      <div class="col-md-6">
                          <input id="last_name" type="text" class="form-control{{ $errors->has('last_name') ? ' is-invalid' : '' }}" name="last_name" value="<?=$user_data?$user_data['last_name']:old('last_name')?>" required autofocus>

                          @if ($errors->has('name'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('last_name') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">DOB</label>
                      <div class="col-md-6">
                          <input id="dob" type="text" class="form-control{{ $errors->has('dob') ? ' is-invalid' : '' }}" name="dob" value="{{ old('dob') }}" required autofocus>

                          @if ($errors->has('name'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('dob') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Email Address</label>
                      <div class="col-md-6">
                          <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="<?=$user_data?$user_data['email']:old('email')?>" required autofocus>

                          @if ($errors->has('email'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('email') }}</strong>
                              </span>
                          @endif
                          <span class="invalid-feedback" role="alert" id="email_error" style="display: none">
                                  <strong>Email is already registerd.</strong>
                          </span>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Country</label>
                      <div class="col-md-6">
                          <!-- <input id="country" type="text" class="form-control{{ $errors->has('country') ? ' is-invalid' : '' }}" name="country" value="{{ old('country') }}" required  autofocus> -->
                          <select class="form-control" name="country" id="country" required autofocus>
                            <option value="">Select Country</option>
                            @if(count($country)>0)
                              @foreach($country as $key=>$value)
                                <option value="{{$value->id}}">{{$value->name}}</option>
                              @endforeach
                            @endif
                          </select>

                          @if ($errors->has('country'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('country') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">State</label>
                      <div class="col-md-6">
                         <!--  <input id="state" type="text" class="form-control{{ $errors->has('state') ? ' is-invalid' : '' }}" name="state" value="{{ old('state') }}" required autofocus> -->
                         <select class="form-control" name="state" id="state" required autofocus>
                         </select>
                          @if ($errors->has('state'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('state') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">User Name</label>
                      <div class="col-md-6">
                          <input id="username" type="text" class="form-control{{ $errors->has('username') ? ' is-invalid' : '' }}" name="username" value="{{ old('username') }}" required autofocus>

                          @if ($errors->has('username'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('username') }}</strong>
                              </span>
                          @endif
                          <span class="invalid-feedback" role="alert" id="username_error" style="display: none">
                                  <strong>Username is already in used.</strong>
                          </span>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Password</label>
                      <div class="col-md-6">
                          <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" value="{{ old('password') }}" required autofocus>

                          @if ($errors->has('password'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('password') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Conf Password</label>
                      <div class="col-md-6">
                          <input id="password_confirmation" type="password" class="form-control{{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}" name="password_confirmation" value="{{ old('password_confirmation') }}" required autofocus>

                          @if ($errors->has('password_confirmation'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('password_confirmation') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row mb-0">
                        <div class="col-md-6 offset-md-4">    
                            <button type="button" class="btn btn-primary continue_btn" data-event_type="tab_continue_1">
                                Continue
                            </button>
                        </div>
                    </div>
                </div>
               <div class="tab-pane fade" id="nav-f2" role="tabpanel" aria-labelledby="nav-f2-tab">
                  <div class="form-group row">
                    <label for="name" class="col-md-4 col-form-label text-md-right">Profile Picture</label>
                    <div class="col-md-3">
                        <input id="profile_pic" type="file" class="form-control{{ $errors->has('profile_pic') ? ' is-invalid' : '' }}" name="profile_pic" value="{{ old('profile_pic') }}" onchange="readURL(this,'','profile_pic_preview')" autofocus>
                        <br>
                         <label for="name" class="col-md-4 col-form-label text-md-right">Preview</label>
                         <img src="<?=$user_data?$user_data['profile_pic']:asset('profile_img/no_image.png')?>" height="150px" width="200px;" id="profile_pic_preview">
                         @if ($errors->has('profile_pic'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('profile_pic') }}</strong>
                            </span>
                        @endif
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="name" class="col-md-4 col-form-label text-md-right">Account Type</label>
                    <div class="col-md-8">
                        <input  type="radio" class="" name="account_type" value="1" checked required autofocus> Publisher?
                        <input  type="radio" class="" name="account_type" value="2" required autofocus> Agency?
                        <input  type="radio" class="" name="account_type" value="3" required autofocus> Business?
                        <br>
                        <span class="info_span">
                          You will be required to provide company details for agency and business account types.
                        </span>

                    </div>
                  </div>
                  <div class="company_info_section" style="display:none">
                  <div class="form-group row">
                    <label for="name" class="col-md-4 col-form-label text-md-right">Company Name</label>
                    <div class="col-md-6">
                        <input id="company_name" type="text" class="form-control{{ $errors->has('company_name') ? ' is-invalid' : '' }}" name="company_name" value="{{ old('company_name') }}" autofocus>

                        @if ($errors->has('country'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('company_name') }}</strong>
                            </span>
                        @endif
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="name" class="col-md-4 col-form-label text-md-right">Company Title</label>
                    <div class="col-md-6">
                        <input id="company_title" type="text" class="form-control{{ $errors->has('company_title') ? ' is-invalid' : '' }}" name="company_title" value="{{ old('company_title') }}" autofocus>

                        @if ($errors->has('company_title'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('company_title') }}</strong>
                            </span>
                        @endif
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="name" class="col-md-4 col-form-label text-md-right">Address</label>
                    <div class="col-md-8">
                       Use the same address?  
                      <input  type="radio" class="" name="same_address_check" value="yes" checked> Yes
                      <input  type="radio" class="" name="same_address_check" value="no"> No
                    </div>
                  </div>
                  <div class="company_address_section" style="display:none">
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Street</label>
                      <div class="col-md-6">
                          <input id="company_street" type="text" class="form-control{{ $errors->has('company_street') ? ' is-invalid' : '' }}" name="company_street" value="{{ old('company_street') }}">

                          @if ($errors->has('company_street'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('company_street') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Zip</label>
                      <div class="col-md-6">
                          <input id="company_zip" type="text" class="form-control{{ $errors->has('company_zip') ? ' is-invalid' : '' }}" name="company_zip" value="{{ old('company_zip') }}">

                          @if ($errors->has('company_zip'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('company_zip') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Country</label>
                      <div class="col-md-6">
                          <select class="form-control" name="company_country" id="company_country">
                            <option value="">Select Country</option>
                            @if(count($country)>0)
                              @foreach($country as $key=>$value)
                                <option value="{{$value->id}}">{{$value->name}}</option>
                              @endforeach
                            @endif
                          </select>
                          @if ($errors->has('country'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('company_country') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">State</label>
                      <div class="col-md-6">
                          <!-- <input id="company_state" type="text" class="form-control{{ $errors->has('company_state') ? ' is-invalid' : '' }}" name="company_state" value="{{ old('company_state') }}" autofocus> -->
                        <select class="form-control" name="company_state" id="company_state">
                        </select>
                          @if ($errors->has('country'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('company_state') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">City</label>
                      <div class="col-md-6">
                          <!-- <input id="company_city" type="text" class="form-control{{ $errors->has('company_city') ? ' is-invalid' : '' }}" name="company_city" value="{{ old('company_city') }}" autofocus> -->
                        <select class="form-control" name="company_city" id="company_city">
                        </select>
                          @if ($errors->has('country'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('company_city') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Phone</label>
                      <div class="col-md-6">
                          <input id="phone" type="text" class="form-control{{ $errors->has('phone') ? ' is-invalid' : '' }}" name="phone" value="{{ old('phone') }}">

                          @if ($errors->has('phone'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('phone') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="name" class="col-md-4 col-form-label text-md-right">Email </label>
                      <div class="col-md-6">
                          <input id="company_email" type="text" class="form-control{{ $errors->has('company_email') ? ' is-invalid' : '' }}" name="company_email" value="{{ old('company_email') }}" readonly>

                          @if ($errors->has('company_email'))
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('company_email') }}</strong>
                              </span>
                          @endif
                      </div>
                    </div>
                  </div>
                  </div>
                  <div class="form-group row mb-0">
                    <div class="col-md-6 offset-md-4">
                        <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_2">
                            Previous
                        </button>
                        <button type="button" class="btn btn-primary" id="submit_registation_btn">
                            Submit
                        </button>
                    </div>
                  </div>
               </div>
            </div>
         </form>
      </div>
   </div>
</div>
</div>
<script type="text/javascript">
$(document).ready(function() {
  $( "#company_email").val($( "#email").val());
  $( "#dob").datepicker({
      dateFormat : 'yy-mm-dd',
      changeMonth : true,
      changeYear : true,
      yearRange: '-100y:c+nn',
      maxDate: '-18Y',
  });
  $(document).on('change', '[type="radio"][name="account_type"]', function() {
    var currentlyValue = $(this).val(); // Get the radio checked value
    if(currentlyValue == 2 || currentlyValue == 3){
      //$(".company_info_section input").prop('required', true);
      $(".company_info_section").css('display','block');
    }else{
      //$(".company_info_section input").removeAttr('required');
      $(".company_info_section").css('display','none');
    }
  });
  $(document).on('change', '[type="radio"][name="same_address_check"]', function() {
    var currentlyValue = $(this).val(); // Get the radio checked value
    if(currentlyValue == 'no'){
      //$(".company_address_section input").prop('required', true);
      $(".company_address_section").css('display','block');
    }else{
      //$(".company_address_section input").removeAttr('required');
      $(".company_address_section").css('display','none');
    }
  });
  //This code is used for handling form steps when click on continue  button
  $('body').on('click', '.continue_btn', function() {
    var type = $(this).data('event_type');
    //alert("button is click for "+type);
    if(type == 'tab_continue_1'){
      if(!custom_required('first_name')){
          toastr.error("Please enter first name!");
          return true;
        }else if(!custom_required('last_name')){
          toastr.error("Please enter last name!");
          return true;
        }else if(!custom_required('dob')){
          toastr.error("Please enter date of birth!");
          return true;
        }else if(!custom_required('email')){
          toastr.error("Please enter email address!");
          return true;
        }else if(!custom_required('country')){
          toastr.error("Please select country!");
          return true;
        }else if(!custom_required('state')){
          toastr.error("Please select state!");
          return true;
        }else if(!custom_required('username')){
          toastr.error("Please enter username!");
          return true;
        }else if(!custom_required('password')){
          toastr.error("Please enter password!");
          return true;
        }else if(!custom_required('password_confirmation')){
          toastr.error("Please enter confirm password!");
          return true;
        }
        $("#nav-f2-tab").trigger('click');
    }else if(type == 'tab_continue_2'){
       $("#nav-f3-tab").trigger('click');
    }else if(type == 'tab_continue_3'){
       $("#nav-f2-tab").trigger('click');
    }
  });
  //This code is used for handling form steps when click on previous button
  $('body').on('click', '.privious_btn', function() {
    var type = $(this).data('event_type');
    //alert("button is click for "+type);
    if(type == 'tab_previous_2'){
      $("#nav-f1-tab").trigger('click');
    }else if(type == 'tab_previous_3'){
       $("#nav-f2-tab").trigger('click');
    }else if(type == 'tab_previous_4'){
       $("#nav-f3-tab").trigger('click');
    }
  });
  //change company address when email is changes
  $( "#email" ).keyup(function() {
    $( "#company_email").val($( "#email").val());
  });
  //check user email exist
  $('body').on('keyup blur change', '#email', function() {
    $("#email_error").css('display','none');
    $("#nav-f1 .continue_btn").prop("disabled", false);
    var email = $("#email").val().trim();
    $.ajax({
        type: "POST",
        url: site_url+"/ajax/check-email",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {email:email},
        success: function(res){
           var data = jQuery.parseJSON(res);
           if(data.status){
              $("#email_error").css('display','block');
              $("#nav-f1 .continue_btn").prop("disabled", true);

           }
        }
    });
  });
  //check user is all ready exist or not
  $('body').on('keyup blur change', '#username', function() {
    $("#username_error").css('display','none');
    $("#nav-f1 .continue_btn").prop("disabled", false);
    var username = $("#username").val().trim();
    $.ajax({
        type: "POST",
        url: site_url+"/ajax/check-username",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {username:username},
        success: function(res){
           var data = jQuery.parseJSON(res);
           if(data.status){
              $("#username_error").css('display','block');
              $("#nav-f1 .continue_btn").prop("disabled", true);
           }
        }
    });
  });
  //get state list by country id
  $('body').on('change', '#country', function() {
    var id = $("#country").val();
    $.ajax({
        type: "POST",
        url: site_url+"/ajax/get-states",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {id:id},
        success: function(res){
           var data = jQuery.parseJSON(res);
           if(data.status){
              $("#state").html(data.content);
           }
        }
    });
  });
  //get state list when company country is selected
  $('body').on('change', '#company_country', function() {
    var id = $("#company_country").val();
    $.ajax({
        type: "POST",
        url: site_url+"/ajax/get-states",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {id:id},
        success: function(res){
           var data = jQuery.parseJSON(res);
           if(data.status){
              $("#company_state").html(data.content);
           }
        }
    });
  });
  //get city list when company state is selected
  $('body').on('change', '#company_state', function() {
    var id = $("#company_state").val();
    $.ajax({
        type: "POST",
        url: site_url+"/ajax/get-cities",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {id:id},
        success: function(res){
           var data = jQuery.parseJSON(res);
           if(data.status){
              $("#company_city").html(data.content);
           }
        }
    });
  });
  //register form submit
  $('#submit_registation_btn').click(function(event) {
    event.preventDefault(); 
    var account_type = $("input[name='account_type']:checked").val();
    if(account_type == 2 || account_type == 3){
      //alert(account_type);
      if(!custom_required('company_name')){
        toastr.error("Please enter company name!");
        return true;
      }else if(!custom_required('company_title')){
        toastr.error("Please enter company title!");
        return true;
      }
      var same_address_check = $("input[name='same_address_check']:checked").val();
      if(same_address_check == 'no'){
        //alert(same_address_check);
        if(!custom_required('company_street')){
        toastr.error("Please enter company street!");
        return true;
        }else if(!custom_required('company_zip')){
          toastr.error("Please enter company zip!");
          return true;
        }else if(!five_digit_zip('company_zip')){
           toastr.error("Please enter 5 digit zip code!");
          return true;
        }else if(!custom_required('company_country')){
          toastr.error("Please select company country!");
          return true;
        }else if(!custom_required('company_state')){
          toastr.error("Please select company state!");
          return true;
        }else if(!custom_required('company_city')){
          toastr.error("Please select company city!");
          return true;
        }else if(!custom_required('phone')){
          toastr.error("Please enter company phone!");
          return true;
        }
        $("#registation_frm").submit();
      }
    }
    $("#registation_frm").submit();
  });
});
function readURL(input){
    var max_size = 1048576 * 4;
    var ext = input.files[0]['name'].substring(input.files[0]['name'].lastIndexOf('.') + 1).toLowerCase();
    if(ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg"){
    }else{
        //alert("Please upload only png|jpg|jpeg image.");
        toastr.warning('Please upload only png, jpg, jpeg image.');
        $('#profile_pic').val('');
        return false;
    }
    if(input.files[0].size >max_size){
        //alert("File size should be equal or less than 4MB");
        toastr.warning('File size should be equal or less than 4MB');
        $('#profile_pic').val('');
        return false;
    }
    if (input.files && input.files[0] && (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")){
        var reader = new FileReader();
        reader.onload = function (e) {
            $('#profile_pic_preview').attr('src', e.target.result);
        }

        reader.readAsDataURL(input.files[0]);
    }else{
         //$('#img').attr('src', '/assets/no_preview.png');
    }
  }
</script>
</div>
@endsection
