'@extends('layouts.main')
@section('content')
<style> 
    .error{
      color: red;
    }   
    .comment-body ul li>table tr td img{    width: 50px;
      height: 50px;
      border-radius: 50%;
      margin-right: 15px;
    }
    .comment-body ul li>table{
      width:100%;}
    .comment-body ul li{display: block; padding: 15px 0;}
    .comment-body ul{
      margin: 0px;
      padding: 0px;
      list-style: none;
      margin-bottom: 15px;}
    .comment-body ul li>table tr:first-of-type td:first-child {
      width: 10px;
    }

    .comment-body ul li>table tr td {
      vertical-align: top;
    }
    .comment-body ul li.sub-comments {
      padding-left: 60px;
    }
    .comment-body ul li+li {
      border-top: 1px solid #ececec;
    }
    .comment-container{padding-top: 25px;width: 400px;}
    .comment-header{margin: 13px 0px;
      font-size: 20px;
      font-weight: 600;
    }
    h4{
      font-size: 15px;
    }
  </style>
<div class="main">
   @if(count($comment_list))
   <h3>Gpage Name: <strong>{{$comment_list[0]->product_name}}</strong></h3>
   <?php $parent_id = '';
   $this->comment_model = new \App\ProductComment;
   ?>
   @foreach($comment_list as $key=>$comment)
   <?php  
      $total_comment = $this->comment_model->get_total_comments_by_parent_id($comment->serial_number);
      $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($comment->serial_number);
      $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($comment->serial_number);
      if(Auth::check()){
        $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id,$comment->serial_number);
        if(!$like_status){
          $like_status = 'new';
        }
      }else{
        $like_status = 0;
      }
      $time_ago = App\Helpers\Common_func::time_ago_int($comment->created_at); 
      $time_ago_arr = explode(" ",$time_ago);
      ?>
   <div class="comment-container" style='margin-top: 0; padding-top: 0; border-bottom: 1px solid #ddd'>
      @if(!$comment->parent_id)
      <div class="comment-body">
         <ul style="margin-bottom: 5px">
            <li>
               <table>
                  <tr>
                     <td>
                        <img src="{{$comment->sender_picture}}" alt="user"/>
                        <a href="#" class="link user-name" style='font-size: 12px; color:#333'>{{$comment->sender_name}}</a>
                     </td>
                     <td>
                        <p style="margin: 0px; color:#444; max-height: 63px; overflow: hidden; text-overflow: ellipsis">{{$comment->comment}}</p>
                        <div class="more-product-assets" style="background: #f1f1f2; border:0; margin-top: 5px">
                           <table>
                              <tr>
                                 <td style="border:0">
                                    <i class="fa fa-thumbs-up"></i>
                                 </td>
                                 <td style="border:0">
                                    <p>{{ $total_com_likes?$total_com_likes:0}}</p>
                                    <h4>
                                       <a href="#" class="comment_like_action" data-comment_id="{{$comment->serial_number}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}">Likes</a>
                                    </h4>
                                 </td>
                                 <td style="border:0">
                                    <i class="fa fa-thumbs-down"></i>
                                 </td>
                                 <td style="border:0">
                                    <p>{{$total_com_unlikes?$total_com_unlikes:0}}</p>
                                    <h4>
                                       <a href="#" class="comment_dislike_action" data-comment_id="{{$comment->serial_number}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}">Unlikes</a>
                                    </h4>
                                 </td>
                                 <td style="border:0">
                                    <i class="fa fa-comment" style="color:#1073b8"></i>
                                 </td>
                                 <td style="border:0">
                                    <p>{{$total_comment?$total_comment:0}}</p>
                                    <h4>
                                       <a href="#" class="comment_reply_action" data-page_id="{{$comment->product_id}}" data-comment_id="{{$comment->serial_number}}" >Reply</a>
                                    </h4>
                                 </td>
                                 <td style="border:0">
                                    <i class="fa fa-calendar"></i>
                                 </td>
                                 <td style="border:0">
                                    <p>{{$time_ago_arr?$time_ago_arr[0]:0}}</p>
                                    <h4>
                                       <a href="javascript::void">{{$time_ago_arr?$time_ago_arr[1]:''}}</a>
                                    </h4>
                                 </td>
                              </tr>
                           </table>
                        </div>
                     </td>
                  </tr>
               </table>
            </li>
         </ul>
      </div>
      @endif
      @foreach($comment_list as $key=>$child)
      @if(!empty($child->parent_id) && $child->parent_id == $comment->serial_number)
      <?php
         $time_ago = App\Helpers\Common_func::time_ago_int($child->created_at); 
         $time_ago_arr = explode(" ",$time_ago);
         $total_com_likes = $this->comment_model->total_comment_likes_by_comment_id($child->serial_number);
         $total_com_unlikes = $this->comment_model->total_comment_unlikes_by_comment_id($child->serial_number);
         if(Auth::check()){
           $like_status = $this->comment_model->comment_like_status_by_user(Auth::user()->id,$child->serial_number);
           if(!$like_status){
            $like_status = 'new';
           }
         }else{
           $like_status = 0;
         }
         ?>
      <div class="comment-container" style='margin-top: 0; padding-top: 0; padding-left: 65px'>
         <div class="comment-body">
            <ul style="margin-bottom: 5px">
               <li style="margin-top: 0">
                  <table>
                     <tr>
                        <td>
                           <img src="{{$child->sender_picture}}" alt="user"/>
                           <a href="#" class="link user-name" style='font-size: 12px; color:#333'>{{$child->sender_name}}</a>
                        </td>
                        <td style="border-radius: 6px;background: #0872b9; padding: 10px">
                           <p style="margin: 0px; color:#fff; max-height: 63px; overflow: hidden; text-overflow: ellipsis">{{$child->comment}}</p>
                           <div class="more-product-assets" style="background: #f1f1f2; border:0; margin-top: 5px">
                              <table>
                                 <tr>
                                    <td style="border:0">
                                       <i class="fa fa-thumbs-up"></i>
                                    </td>
                                    <td style="border:0">
                                       <p>{{$total_com_likes?$total_com_likes:0}}</p>
                                       <h4>
                                          <a href="#" class="comment_like_action" data-comment_id="{{$child->serial_number}}" data-like_status="{{$like_status}}">Likes</a>
                                       </h4>
                                    </td>
                                    <td style="border:0">
                                       <i class="fa fa-thumbs-down"></i>
                                    </td>
                                    <td style="border:0">
                                       <p>{{$total_com_unlikes?$total_com_unlikes:0}}</p>
                                       <h4>
                                          <a href="#" class="comment_dislike_action" data-comment_id="{{$child->serial_number}}" data-like_status="{{$like_status}}">Unlikes</a>
                                       </h4>
                                    </td>
                                    <td style="border:0">
                                       <i class="fa fa-calendar"></i>
                                    </td>
                                    <td style="border:0">
                                       <p>{{$time_ago_arr?$time_ago_arr[0]:0}}</p>
                                       <h4>
                                          <a href="javascript::void">{{$time_ago_arr?$time_ago_arr[1]:''}}</a>
                                       </h4>
                                    </td>
                                 </tr>
                              </table>
                           </div>
                        </td>
                     </tr>
                  </table>
               </li>
            </ul>
         </div>
      </div>
      @endif
      @endforeach
   </div>
   @endforeach
   @endif
</div>
<!-- <hr class="featurette-divider"> -->
@include('common.menu')
</div>   
<!-- reply model start here -->
<div class="modal fade" id="comment_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
  aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <h4 class="modal-title w-100 font-weight-bold">Gpages Comment</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="comment_model">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form method="post" name="comment_frm" id="comment_frm">
        <input type="hidden" name="page_id" id="page_id">
        <input type="hidden" name="comment_id" id="comment_id">
        <div class="modal-body mx-3">
          <div class="md-form">
            <i class="fas fa-pencil prefix grey-text"></i>
             <label data-error="wrong" data-success="right" for="form8">Message</label>
            <textarea type="text" id="message"  name="message" class="md-textarea form-control" rows="4"></textarea>
          </div>
        </div>
        <div class="modal-footer d-flex justify-content-center">
          <input class="btn btn-unique" type="submit" value="Send"> <i class="fas fa-paper-plane-o ml-1"></i></button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- reply model end here -->
<script type="text/javascript">
   $(document).ready(function(){
     //close model by id
      $('body').on('click', '.close_btn', function(e) {
          var id = $(this).data('model_id');
          $("#"+id).modal("toggle");
      });
      //message reply form submit
      $('form[id="comment_frm"]').validate({
        rules: {
          message: 'required',
        },
        messages: {
          message: 'Please enter your comment',
        },
        submitHandler: function(form) {
          //form.submit();
          frm = $('#comment_frm');
          $.ajax({
            type: "POST",
            url: site_url+"/user/gpages-comment",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: frm.serialize(),
            success: function(res){
               var data = jQuery.parseJSON(res);
               $("#comment_model").modal("toggle");
               if(data.status){
                  toastr.success(data.msg);
                  setTimeout(function(){
                     window.location.reload();
                  }, 900);
               }else{
                  toastr.error(data.msg);
               }
            }
          });
        }
      });
      //open comment model
      $('body').on('click', '.comment_action', function(e) {
        e.preventDefault();
        var page_id = $(this).data("page_id");
        $("#page_id").val(page_id);
        $("#comment_id").val('');
        $("#message").val('');
        setTimeout(function(){ 
          $("#comment_model").modal("toggle");
        }, 50);
      });

      $('body').on('click', '.comment_reply_action', function(e) {
        e.preventDefault();
        var page_id = $(this).data("page_id");
        var comment_id = $(this).data("comment_id");
        $("#page_id").val(page_id);
        $("#comment_id").val(comment_id);
        $("#message").val('');
        setTimeout(function(){ 
          $("#comment_model").modal("toggle");
        }, 50);
      });

      $('body').on('click', '.like_action', function(e) {
        e.preventDefault();
        var page_id = $(this).data("page_id");
        var like_status = $(this).data('like_status');
        if(like_status == 'yes'){
          toastr.success('You have already like this page!');
          return true;
        }
        $.ajax({
            type: "POST",
            url: site_url+"/user/gpages-likes",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {page_id:page_id, like_status:'yes'},
            success: function(res){
               var data = jQuery.parseJSON(res);
               if(data.status){
                  toastr.success(data.msg);
                  setTimeout(function(){
                     window.location.reload();
                  }, 900);
               }else{
                  toastr.error(data.msg);
               }
            }
        });
      });
      $('body').on('click', '.dislike_action', function(e) {
        e.preventDefault();
        var page_id = $(this).data("page_id");
        var like_status = $(this).data('like_status');
        if(like_status == 'no'){
          toastr.success('You have already unlike this page!');
          return true;
        }
        $.ajax({
          type: "POST",
          url: site_url+"/user/gpages-likes",
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {page_id:page_id, like_status:'no'},
          success: function(res){
             var data = jQuery.parseJSON(res);
             if(data.status){
                toastr.success(data.msg);
                setTimeout(function(){
                   window.location.reload();
                }, 900);
             }else{
                toastr.error(data.msg);
             }
          }
        });
      });
      //comment like  action
      $('body').on('click', '.comment_like_action', function(e) {
        e.preventDefault();
          var comment_id = $(this).data("comment_id");
          var like_status = $(this).data('like_status');
          if(like_status == 'yes'){
            toastr.success('You have already like this comment!');
            return true;
          }
          $.ajax({
              type: "POST",
              url: site_url+"/user/comment-likes",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: {comment_id:comment_id, like_status:'yes'},
              success: function(res){
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                    setTimeout(function(){
                       window.location.reload();
                    }, 900);
                 }else{
                    toastr.error(data.msg);
                 }
              }
          });
      });
      //dislike comment 
      $('body').on('click', '.comment_dislike_action', function(e) {
        e.preventDefault();
        var comment_id = $(this).data("comment_id");
        var like_status = $(this).data('like_status');
        if(like_status == 'no'){
          toastr.success('You have already unlike this comment!');
          return true;
        }
        $.ajax({
            type: "POST",
            url: site_url+"/user/comment-likes",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {comment_id:comment_id, like_status:'no'},
            success: function(res){
               var data = jQuery.parseJSON(res);
               if(data.status){
                  toastr.success(data.msg);
                  setTimeout(function(){
                     window.location.reload();
                  }, 900);
               }else{
                  toastr.error(data.msg);
               }
            }
        });
      });
    })
  </script>
@endsection