<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
  @include('users.inc.head')
  <style>
      .stack-nav li a{background: transparent; text-align: left; color:#fff}
      .stack-nav li a{position: relative}
      .stack-nav li a .badge{position: absolute; right:15px; top:7px}
      .trigger-nav li a {position: relative}
      .trigger-nav li a i.flag{position: absolute; top:-5px; right:-20px; background: #f05a28; padding: 2px; color:#fff; border-radius: 3px; width: 16px; height: 16px; text-align: center; line-height: 12px}
      .sidepopup.on{left:0}
  </style>
  <?php
  //print_r($user);
  ?>
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <!--<div class="mask"></div>-->
      <div class="sidepopup on" style="top:150px; padding-top: 60px">
        
          <div class="user-area" style="position: absolute; top:-30px; left:35px; color:#fff">
              <table>
                  <tr>
                      <td><img src="<?=$user?$user[0]->profile_picture:asset('assets_web/img/1.jpg')?>" style="border-radius: 4px; width: 60px; height: 60px;  border:2px solid #224099"/>
                      </td>
                      <td style='padding-left: 15px; padding-top: 20px'><b><?=$user[0]->username?></b>
                        <br>
                         <?php
                          if($user[0]->role == 2) {
                            $account_type = $user[0]->account_type;
                          }else{
                            $account_type = 0;
                          }
                        ?>
                        @if($account_type == 1)
                          <span>Publisher</span>
                        @elseif($account_type == 2)
                            <span>Agency</span>
                        @elseif($account_type == 3)
                            <span>Business</span>
                        @else
                            <span>user</span>
                        @endif
                      </td>
                </tr>
              </table>
              
              
          </div>  
          
          <ul class="trigger-nav">
              <li>
                  <a href="{{url('creator/gpages')}}">
                      <span>Gpages <i class='flag'>{{$gpages_list?count($gpages_list):0}}</i> </span>
                  </a>
              </li>
              @if($user[0]->account_type == 2 || $user[0]->account_type == 3)
              <li>
                  <a href="javascript::void">
                      <span><?=$user[0]->verify_by_admin == '1'?'Verified ':'Unverified'?></span>
                  </a>
              </li>
              @endif
              <li>
                  <a href="{{url('user/activity/'.$user[0]->id)}}">
                      <span>Activities </span>
                  </a>
              </li>
              <li>
                  <a href="{{url('account/setting')}}">
                      <span>About </span>
                  </a>
              </li>
          </ul>
          <hr>
          <h5 style="color:#fff; padding: 5px 15px; font-size: 13px; margin-bottom: 0">
             {{$user[0]->state}}, {{$user[0]->country}}
          </h5>
          <h5 style="color:#fff; padding: 5px 15px; font-size: 13px">
              Member Since: {{date('M d, Y',strtotime($user[0]->created_at))}}
          </h5>
          <hr>
          <ul class="stack-nav">
              <li><a href="{{url('user/publisher-gpages/'.$user[0]->id)}}">Added Gpages <span class="badge">{{$gpages_list?count($gpages_list):0}}</span></a></li>
          </ul>
          
          <div style="padding: 0 25px; margin-top: 40px">
          <div class="row">
          <div class="col-6">
            <a href="{{url('creator/dashboard')}}" class="btn btn-success" style="display: block">Dashboard</a>
          </div>
          <div class="col-6"><a href="{{url('creator/message-list')}}" class="btn btn-primary" style="display: block">Message</a></div>
            <div class="col-6" style="margin-top: 10px;">
              <a href="{{url('user/logout')}}" class="btn btn-success" style="display: block">Logout</a>
            </div>
          </div>
          </div>
          
      </div>
      
    <!-- Navbar-->
    <header class="app-header" style="background: url('{{asset('assets_web/img/bannerbg.png')}}'); height: 150px">
        
        
        
        <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar" style="background: transparent">
            <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
        <div class="navbar-header">
            <a href="{{url('/')}}" class="navbar-brand" style="line-height: 35px"><img src="{{asset('assets_web/img/logo_original_sm.png')}}" height="28" alt="logo"></a>
                        </div>
        
      <!-- Navbar Right Menu-->
    </header>
    <!-- Sidebar menu-->
    <main class="app-content" style="margin-top: 150px">       
      <div class="row">         
          <div class="col-md-5" style='float:none; margin: auto'>
            @if(count($gpages_list))
              @foreach($gpages_list as $key=>$value)
                <?php 
                  $image = json_decode($value->image);
                  $this->product_model = new \App\Product;
                  $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                  $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                  $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                  $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                  $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                  $page_name = preg_replace('/-+/', '-', $page_name);
                 if(Auth::check()){
                    $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                  }else{
                    $like_status = 0;
                  }
                ?>
                <div class="more-product">
                  <div class="more-product-info">
                      <div class="more-product-img"><img src="{{asset($image[0]->url)}}"/></div>
                      <p><a href="{{url('product/'.strtolower($page_name).'/about/'.$value->id)}}">{{$value->description}}</a></p>
                  </div>
                  <div class="more-product-assets">
                      <table>
                        <tr>
                            <td style='font-weight: bold'>
                                <img src="{{$value->profile_picture}}"/> {{$value->username}}
                            </td>
                            <td><i class="fa fa-thumbs-up"></i></td>
                            <td>
                                <p>{{$total_likes}}</p>
                                <h4><a href="#" class="like_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}">Likes</a></h4>
                            </td>
                            <td><i class="fa fa-thumbs-down"></i></td>
                            <td>
                                <p>{{$total_unlikes}}</p>
                                <h4><a href="#" class="dislike_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> Unlikes</a></h4>
                            </td>
                            <td><i class="fa fa-eye"></i></td>
                            <td>
                                <p>{{$value->view_count}}</p>
                                <h4><a href="#">Views</a></h4>
                            </td>
                            <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                            <td>
                                <p>{{$total_comments}}</p>
                                <h4><a target="_blank" class="comment_action" data-page_id="{{$value->id}}" href="{{url('user/gpages-comment/'.$value->id)}}">Comments</a></h4>
                            </td>
                        </tr>
                    </table>
                  </div>
                </div>
              @endforeach
            @endif
        </div>
      </main>
      <!-- reply model start here -->
      <div class="modal fade" id="comment_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
      aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header text-center">
              <h4 class="modal-title w-100 font-weight-bold">Gpages Comment</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="comment_model">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <form method="post" name="comment_frm" id="comment_frm">
              <input type="hidden" name="page_id" id="page_id">
              <div class="modal-body mx-3">
                <div class="md-form">
                  <i class="fas fa-pencil prefix grey-text"></i>
                   <label data-error="wrong" data-success="right" for="form8">Message</label>
                  <textarea type="text" id="message"  name="message" class="md-textarea form-control" rows="4"></textarea>
                </div>
              </div>
              <div class="modal-footer d-flex justify-content-center">
                <input class="btn btn-unique" type="submit" value="Send"> <i class="fas fa-paper-plane-o ml-1"></i></button>
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- reply model end here -->
      <!-- reply model start here -->
    <div class="modal fade" id="message_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
      aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Message to publisher</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="message_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form method="post" name="publisher_msg_frm" id="publisher_msg_frm">
            <input type="hidden" name="reciver_id" id="reciver_id">
            <div class="modal-body mx-3">
              <div class="md-form">
                <i class="fas fa-pencil prefix grey-text"></i>
                 <label data-error="wrong" data-success="right" for="form8">Message</label>
                <textarea type="text" id="message"  name="message" class="md-textarea form-control" rows="4">Task is under process.</textarea>
              </div>
            </div>
            <div class="modal-footer d-flex justify-content-center">
              <input class="btn btn-unique" type="button" value="Send"> <i class="fas fa-paper-plane-o ml-1"></i></button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- reply model end here -->
      <!-- Essential javascripts for application to work-->
      @include('users.inc.footer_js_lib')
      <script type="text/javascript">
        $(document).ready(function(){
          //close model by id
            $('body').on('click', '.close_btn', function(e) {
                var id = $(this).data('model_id');
                $("#"+id).modal("toggle");
            });
            //message reply form submit
            $('form[id="comment_frm"]').validate({
              rules: {
                message: 'required',
              },
              messages: {
                message: 'Please enter your comment',
              },
              submitHandler: function(form) {
                //form.submit();
                frm = $('#comment_frm');
                $.ajax({
                  type: "POST",
                  url: site_url+"/user/gpages-comment",
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  data: frm.serialize(),
                  success: function(res){
                     var data = jQuery.parseJSON(res);
                     $("#comment_model").modal("toggle");
                     if(data.status){
                        toastr.success(data.msg);
                        setTimeout(function(){
                           window.location.reload();
                        }, 900);
                     }else{
                        toastr.error(data.msg);
                     }
                  }
                });
              }
            });
            //open comment model
            $('body').on('click', '.comment_action', function(e) {
              e.preventDefault();
              if(check_login()){
                var page_id = $(this).data("page_id");
                $("#page_id").val(page_id);
                $("#message").val('');
                setTimeout(function(){ 
                  $("#comment_model").modal("toggle");
                }, 50);
              }
            });
            $('body').on('click', '.publisher_msg_btn', function(e) {
              e.preventDefault();
              if(check_login()){
                var reciver_id = $(this).data("reciver_id");
                $("#reciver_id").val(reciver_id);
                $("#message").val('');
                setTimeout(function(){ 
                  $("#message_model").modal("toggle");
                }, 50);
              }
            });
            
            $('body').on('click', '.like_action', function(e) {
              e.preventDefault();
              if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'yes'){
                  toastr.success('You have already like this page!');
                  return true;
                }
                $.ajax({
                  type: "POST",
                  url: site_url+"/user/gpages-likes",
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  data: {page_id:page_id, like_status:'yes'},
                  success: function(res){
                     var data = jQuery.parseJSON(res);
                     if(data.status){
                        toastr.success(data.msg);
                        setTimeout(function(){
                           window.location.reload();
                        }, 900);
                     }else{
                        toastr.error(data.msg);
                     }
                  }
                });
              }
            });
            $('body').on('click', '.dislike_action', function(e) {
              e.preventDefault();
              if(check_login()){
                var page_id = $(this).data("page_id");
                var like_status = $(this).data('like_status');
                if(like_status == 'no'){
                  toastr.success('You have already unlike this page!');
                  return true;
                }
                $.ajax({
                  type: "POST",
                  url: site_url+"/user/gpages-likes",
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  data: {page_id:page_id, like_status:'no'},
                  success: function(res){
                     var data = jQuery.parseJSON(res);
                     if(data.status){
                        toastr.success(data.msg);
                        setTimeout(function(){
                           window.location.reload();
                        }, 900);
                     }else{
                        toastr.error(data.msg);
                     }
                  }
                });
              }
            });
            //fllow to publisher
            $('body').on('click', '.fllow_action', function(e) {
              e.preventDefault();
              if(check_login()){
                var publisher_id = $(this).data("publisher_id");
                //alert("fllow button is click:"+ publisher_id);
                $.ajax({
                  type: "POST",
                  url: site_url+"/user/follow-to-publisher",
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  data: {publisher_id:publisher_id},
                  success: function(res){
                     var data = jQuery.parseJSON(res);
                     if(data.status){
                        toastr.success(data.msg);
                        setTimeout(function(){
                           window.location.reload();
                        }, 900);
                     }else{
                        toastr.error(data.msg);
                     }
                  }
                });
              }
            });
          })
        </script>
      </body>
  </html>