@extends('layouts.main')
@section('content')
<style type="text/css">
    .container_msg {
      border: 2px solid #dedede;
      background-color: #f1f1f1;
      border-radius: 5px;
      padding: 10px;
      margin: 10px 0;
      /*max-width: 500px;*/
    }

    .darker {
      border-color: #ccc;
      background-color: #ddd;
      /*margin-left: 400px;*/
    }

    .container_msg::after {
      content: "";
      clear: both;
      display: table;
    }

    .container_msg img {
      float: left;
      max-width: 60px;
      width: 100%;
      margin-right: 20px;
      border-radius: 50%;
    }

    .container_msg img.right {
      float: right;
      margin-left: 20px;
      margin-right:0;
    }

    .time-right {
      float: right;
      color: #aaa;
    }

    .time-left {
      float: left;
      color: #999;
    }
</style>
	<!-- chat div start here -->
  <div>
    @if(count($support))
      <div class="container_msg">
        <img src="{{$support[0]->profile_picture?$support[0]->profile_picture:asset('profile_img/no_image.png')}}" alt="Avatar" style="width:100%;">
        <p>{{ucfirst($support[0]->name)}}</p>
        <p>{{$support[0]->message}}</p>
        <span class="time-right">{{$support[0]->created_at}}</span>
      </div>
      @if(count($support_response))
        @foreach($support_response as $key=>$response)
          <div class="container_msg darker">
            <img src="{{$response->sender_profile_pic}}" alt="Avatar" class="" style="width:100%;position: '';">
            <p>{{ucfirst($response->name)}}</p>
            <p>{{$response->message}}</p>
            <span class="time-left">{{$response->created_at}}</span>
            <i class="fa fa-trash delete_action" style="float:right" data-id="{{$response->id}}"></i>
          </div>
        @endforeach
      @endif
      @if(!$support[0]->support_status)
      <div class="container_msg darker" style="max-width: 500px;">
        <p>Reply to {{$support[0]->name}}</p>
        <textarea rows="6" cols="50" name="message" id="message">
          
        </textarea>
        <p>
        <a href="{{url('creator/support-list')}}" class="btn btn-info"> Back</a>
        <input type="button" class="btn btn-success" id="reply_btn" name="Send" value="Send" data-id="{{$support[0]->id}}" data-email="{{$support[0]->email}}" data-name="{{$support[0]->name}}" data-reciver_id="{{$support[0]->sender_id}}"></button>
        <a href="#" data-id="{{$support[0]->id}}" class="btn btn-info resolved_btn"> Resolved</a></p>
      </div>
      @endif
    @endif
    <!-- chat div end  here -->
    </div>
    <hr class="featurette-divider">
        @include('common.menu')
    </div>
    <script type="text/javascript">
        $(document).ready(function(){
          $("#message").val($("#message").val().trim());
        $('body').on('click', '#reply_btn', function(e) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          var email = $(this).data('email');
          var reciver_id = $(this).data('reciver_id');
          var message = $("#message").val().trim();
          if(message == "" || message == undefined){
            toastr.error('Please enter message');
            return true;
          }
          if(id != "" || id != undefined){
              $("#reply_btn").attr("disabled", true);
              $.ajax({
                type: "POST",
                url: site_url+"/creator/support-response",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {id: id,name: name,message:message,email:email,reciver_id:reciver_id},
                success: function(res){
                  var data = jQuery.parseJSON(res);
                  if(data.status){
                  setTimeout(function(){
                    window.location.reload();
                  }, 900);
                      
                  }else{
                    setTimeout(function(){
                      window.location.reload();
                    }, 900);
                  }
                  $("#reply_btn").attr("disabled", false);
                }
            });  
          }
        });
        //delete support
        $('body').on('click', '.delete_action', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: 'Are You sure want to delete ?',
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        if(result){
                            $('#loader_img').css('display','block');
                            $.ajax({
                                type: "POST",
                                url: site_url+"/creator/delete-support-message",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: {id: id},
                                success: function(res){
                                   $('#loader_img').css('display','none');
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                    setTimeout(function(){
                                       window.location.reload();
                                    }, 900);
                                      
                                   }else{
                                    setTimeout(function(){
                                        window.location.reload();
                                    }, 900);
                                   }
                                }
                            });
                            return true;
                        }
                    }
                });
            }
        });
        $('body').on('click', '.resolved_btn', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: 'Are You sure want to resolved it ?',
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        if(result){
                            $('#loader_img').css('display','block');
                            $.ajax({
                                type: "POST",
                                url: site_url+"/ajax/resolved-support-message",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: {id: id},
                                success: function(res){
                                   $('#loader_img').css('display','none');
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                    window.location.href = "<?=url('creator/support-list')?>";
                                   }else{
                                    toastr.error(data.msg);
                                   }
                                }
                            });
                            return true;
                        }
                    }
                });
            }
        });
      })
    </script>
  @endsection
