@extends('layouts.landing')
@section('content')
<section class="seciton section-slider">
   <div class="container-fluid">
      <div class="row">
         <div class="product-slider">
            <div><img src="{{asset('assets_web/img/banners/SLIDER_1.jpg')}}"></div>
            <div><img src="{{asset('assets_web/img/banners/SLIDER_2.jpg')}}"></div>
         </div>
      </div>
   </div>
</section>
<section class="seciton section-content" style="padding: 40px 0">
   <div class="container-fluid">
      <div class="row">
         <div class="container">
            <div class="row">
               <h4 class="section-index-title">Top Products</h4>
            </div>
            <div class="row" id="main_div_row">
               @if($gpages && count($gpages))
                  @foreach($gpages as $key=>$page)
                    @if($page->exclude_from_feed == 1)
                    @else
                      <?php 
                        $image = json_decode($page->image);
                        $this->product_model = new \App\Product;
                        $total_likes = $this->product_model->get_total_likes_by_page_id($page->id);
                        $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $page->name);
                        $page_name = preg_replace('/-+/', '-', $page_name);
                      ?>
                       <div class="col-md-4">
                          <div class="restro-show">
                             <a href="{{url('product/'.strtolower($page_name).'/about/'.$page->id)}}">
                                <div class="restro-show-img" style="background-image: url({{asset($image[0]->url)}})"></div>
                                <div class="restro-show-detail">
                                   <span class="label label-success"><span class="fa fa-thumbs-up"></span> {{$total_likes}}</span>
                                   <h4>{{$page->title}}</h4>
                                   <p>by <b>{{$page->username}}</b></p>
                                </div>
                             </a>
                          </div>
                       </div>
                     @endif
                  @endforeach
               @endif
            </div>
            <div class="viewmore"><a href="#" id="btn-more">View More</a></div>
            <input type="hidden" name="count_item" id="count_item" value="{{count($gpages)}}">
         </div>
      </div>
   </div>
</section>
<script type="text/javascript">
  $(document).ready(function(){
    $('body').on('click', '#btn-more', function(e) {
      event.preventDefault();
      var count_item = $('#count_item').val();
      //alert(count_item);
       $('#btn-more').text('Data is loading....');
      $.ajax({
        type: "GET",
        url: site_url,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        async: false,
        data: {count_item: count_item},
        success: function(res){
           var data = jQuery.parseJSON(res);
           if(data.status){
              if(data.output == ''){
                $('#btn-more').text('No More Data');
                return true;
              }
              $('#main_div_row').append(data.output);
              $('#count_item').val(data.new_count_item);
              $('#btn-more').text('View More');
           }else{
            //toastr.error(data.msg);
           }
        }
      });
    });
  });
</script>
@endsection

 