
<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Gfects LLC">
    <link rel="icon" href="{{url('/img/Gfects_icon.png')}}">
    <meta name="description" content=""@yield('meta_description', 'Page')"">

    <title>Gfects | @yield('title', 'Page')</title>

    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">

     <link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic"
          rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
    <!-- Custom styles for this template -->
    <link href="{{asset('/public/css/styling.css')}}" rel="stylesheet">
    
    {{-- For posting redirect --}} @if(isset($canonical))
    <link rel="canonical" href="{{ $canonical }}" />
    @endif
    
    @yield('more_css_style')
    
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-85605806-1"></script>
    @yield('Google_adsense')
  </head>
  <body>

    <header class="headerbg z-depth-half fixed-top">
      <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light navbar-custom  fixed-top">
            <div class="container">
              <a class="navbar-brand" href="{{  url('/') }}" id="site-logo">
                    <img src="https://gfects.com/gfects/public/assets_web/img/logo_original_sm.png" alt="Gfects logo">
              </a>

              <button class="navbar-toggler navbar-toggler-right collapsed" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
              </button>

              <div class="navbar-collapse collapse headerbg" id="navbarResponsive" style="">
                <form class="navbar-form form-inline mt-1">
                  <div class="form-group" style="display:inline;">
                    <div class="input-group" id="search-cuisine">
                      <input type="text" class="form-control" placeholder="Search for products.." id="search" aria-describedby="basic-addon2">
                      <input type="hidden" name="page_search" id="page_search" value="{{$title == 'Search Result'?'yes':'no'}}">
                      <span class="input-group-append">
                        <button class="btn btn-warning" type="button"><i class="fas fa-search"></i></button>
                      </span>
                    </div>
                  </div>
                </form>
                <ul class="navbar-nav ml-auto">
                  @if(Auth::check())
                        @if(Auth::user()->role == 2 && Auth::user()->switch_role == 0)
                          <li class="nav-item dropdown">
                            <a href="#" class="dropdown-toggle users" data-toggle="dropdown">
                              Account
                            </a>
                            <ul class="dropdown-menu">
                              <li>
                                  <a href="{{  url('creator/home/') }}" class="login text-light">User Home Page</a>
                              </li>
                              <li>
                                  <a href="{{  url('creator/dashboard') }}" class="login text-light">Dashboard</a>
                              </li>
                            </ul>
                          </li>
                        @elseif(Auth::user()->role == 2 && Auth::user()->switch_role == 3)  
                          <li class="nav-item"><a href="{{  url('user/dashboard') }}" class="login text-light">Account</a></li>
                        @else
                          <li class="nav-item"><a href="{{ url('user/dashboard') }}" class="login text-light">Account</a></li>
                        @endif
                        @endif
                        @guest
                          <li class="nav-item"><a href="{{url('apps')}}" class="nav-link btn  text-light">Apps</a></li>
                          <li class="nav-item">
                              <a href="{{  url('Account') }}" class="nav-link btn nav-register-btn text-light">
                                Account
                              </a>
                          </li>
                        @else
                          <li class="nav-item"><a href="{{ url('logout') }}" class="login signup">Logout</a></li>
                        @endguest
                </ul>
              </div>
            </div>
          </nav>
      </div>
    </header>

    <div class="m-5 p-2"></div>
    
    <main role="main">
      @yield('section_content_top')
      <div class="container marketing">
        <!-- START THE FEATURETTES -->

        @yield('section_content', 'Something is missing')
      </div>

      @yield('section_content_3')

      <!-- /.container -->


      <!-- FOOTER -->
     <footer class="py-5 mt-4 bg-dark">
      @yield('footer_content_1')

      <div class="container" id="footer-first">
        <div class="row">
           <div class="col-sm-6">
              <img src="https://gfects.com/gfects/public/assets_web/img/logo_original_sm.png" height="32">
              <p class="paragraph mt-2 text-light">&copy; 2017-{{ date('Y') }} Gfects | All Rights Reserved</p>
           </div>
           <!-- /.col-lg-6 -->
           <div class="col-sm-6">
              <ul class="footer-nav-social list-inline list-unstyled  mt-2 h4">
                 <li class="list-inline-item"><a href="#" class="text-light"><i class="fab fa-facebook-square"></i></a></li>
                 <li class="list-inline-item"><a href="#" class="text-light"><i class="fab fa-linkedin"></i></a></li>
                 <li class="list-inline-item"><a href="https://www.instagram.com/gfects_nfc/?hl=en" class="text-light"><i class="fab fa-instagram"></i></a></li>
              </ul>
           </div>
        </div>
     </div>
    <!-- /.container -->
      </footer>
    </main>


<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
<script src="https://code.jquery.com/ui/1.12.0/jquery-ui.min.js" integrity="sha256-eGE6blurk5sHj+rmkfsGYeKyZx3M4bG+ZlFyA7Kns7E=" crossorigin="anonymous"></script>
    @yield('ext_scripts')
  </body>
</html>
