@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
    <style>
		#userArea{
		    position:relative;
		}
		#pill_cont{
			width:160px;
			height:31px;
			border:#BEC0C2 solid 1px;
			padding:1px;
			position: absolute;
			right: 15px;
			bottom: 0;
			
		}
		.badge-pill{
			width:77px;
		}
		.col-sm.text-right{
			padding-right:0px;
		}
	</style>
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
    <div>
        <div ng-app="app">
            <div class="card-deck mt-4">
                <div class="card bg-info m-4 shadow-sm text-light">
                    <div class="m-4">
                        <span>Gpages</span>
                        <h3>2</h3>
                    </div>
                </div>
                <div class="card bg-success m-4 shadow-sm text-light">
                    <div class="m-4">
                        <span>Vitalized</span>
                        <h3>2</h3>
                    </div>
                </div>
                <div class="card bg-warning m-4 shadow-sm">
                    <div class="m-4">
                        <span>Comments</span>
                        <h3>2</h3>
                    </div>
                </div>
                
            </div>
            
            <div id="userArea">
                
                <div id="pill_cont" class="badge-pill row">
                  	<div class="badge-pill badge-secondary text-center"><span>User</span></div>
                  	<div class="col-sm text-right"><p >Creator</p></div>
                </div>
                
                <nav class="mt-4">
                  <div class="nav nav-tabs" id="nav-tab" role="tablist">
                    <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">Account</a>
                    <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false">G-pages</a>
                  </div>
                </nav>
            </div>

            <div class="tab-content" id="nav-tabContent">
              <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                    <div class="my-3 p-3 bg-white rounded shadow-sm" ng-controller="ClickToEditCtrl">
                        <h6 class="border-bottom border-gray pb-2 mb-0">Account details</h6>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/discount.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">Usermane</strong>
                                    
                                </div>
                                <span class="d-block">{{ Auth::user()->uname }}</span>
                            </div>
                        </div>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/id-card.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">First Name</strong>
                                    <div  ng-hide="editorEnabled">
                                        <a ng-click="enableEditor()" class="text-primary btn" style="font-size:12px">Edit</a>
                                    </div>
                                </div>
                                <span class="d-block" ng-hide="editorEnabled">{{ Auth::user()->fname }}</span>
                                 @if ($errors->has('firstName'))
                                <span class="d-block text-danger{{ $errors->has('firstName') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('firstName') }}
                                </span>
                                @endif
                                <div ng-show="editorEnabled">
                                    <form class="needs-validation" name="createACCf01" method="POST" action="api/user/edit"> 
                                      @csrf
                                        <input type="text" name="firstName" class="{{ $errors->has('firstName') ? ' is-invalid' : '' }}" ng-bind='title' value="{{ Auth::user()->fname }}">
                                        <button type="submit" class="btn bg-success font-weight-bold ml-2"><i class="fas fa-check text-light"></i></button>
                                        <button class="btn bg-danger font-weight-bold ml-2" ng-click="disableEditor()"><i class="fas fa-times text-light"></i></button>
                                    </form>
                                        <div class="invalid-feedback{{ $errors->has('firstName') ? ' is-invalid' : '' }}">
                                          A valid first name is required.
                                        </div>
                                </div>
                            </div>
                        </div>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/id-card.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">Last name</strong>
                                    <a ng-click="enableEditor()" class="text-primary btn" style="font-size:12px">Edit</a>
                                </div>
                                <span class="d-block{{ $errors->has('lastName') ? ' text-danger' : '' }}">{{ Auth::user()->lname }}</span>
                                 @if ($errors->has('lastName'))
                                <span class="d-block text-danger{{ $errors->has('lastName') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('lastName') }}
                                </span>
                                @endif
                                <div ng-show="editorEnabled">
                                    <form class="needs-validation" name="createACCf01" method="POST" action="api/user/edit"> 
                                      @csrf
                                        <input type="text" name="lastName" class="{{ $errors->has('lastName') ? ' is-invalid' : '' }}" ng-bind='title' value="{{ Auth::user()->lname }}">
                                        <button type="submit" class="btn bg-success font-weight-bold ml-2"><i class="fas fa-check text-light"></i></button>
                                        <button class="btn bg-danger font-weight-bold ml-2" ng-click="disableEditor()"><i class="fas fa-times text-light"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/gift.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">Birthdate</strong>
                                    <a ng-click="enableEditor()" class="text-primary btn" style="font-size:12px">Edit</a>
                                </div>
                                <span class="d-block">{{ Auth::user()->dob_month }} / {{ Auth::user()->dob_day }} / {{ Auth::user()->birth_year }}</span>
                                 @if ($errors->has('Bsdate'))
                                <span class="d-block text-danger{{ $errors->has('Bsdate') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('Bsdate') }}
                                </span>
                                @endif
                                <div ng-show="editorEnabled">
                                    <form class="needs-validation" name="createACCf01" method="POST" action="api/user/edit"> 
                                      @csrf
                                        <input type="date" class="{{ $errors->has('Bsdate') ? ' is-invalid' : '' }}" id="Bsdate" name="Bsdate" value="{!! !empty(Auth::user()->birth_year) ? Auth::user()->birth_year.'-'.Auth::user()->dob_month.'-'.Auth::user()->dob_day : old('Bsdate') !!}" require>
                                        <button type="submit" class="btn bg-success font-weight-bold ml-2"><i class="fas fa-check text-light"></i></button>
                                        <button class="btn bg-danger font-weight-bold ml-2" ng-click="disableEditor()"><i class="fas fa-times text-light"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/letter.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">Email</strong>
                                    <a ng-click="enableEditor()" class="text-primary btn" style="font-size:12px">Edit</a>
                                </div>
                                <span class="d-block">{{ Auth::user()->email }}</span>
                                 @if ($errors->has('email'))
                                <div class="text-danger{{ $errors->has('email') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('email') }}
                                </div>
                                @endif
                                <div ng-show="editorEnabled">
                                    <form class="needs-validation" name="createACCf01" method="POST" action="api/user/edit"> 
                                      @csrf
                                        <input type="text" name="email" class="{{ $errors->has('email') ? ' is-invalid' : '' }}" ng-bind='title' value="{{ Auth::user()->email }}">
                                        <button type="submit" class="btn bg-success font-weight-bold ml-2"><i class="fas fa-check text-light"></i></button>
                                        <button class="btn bg-danger font-weight-bold ml-2" ng-click="disableEditor()"><i class="fas fa-times text-light"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/placeholder.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">Address</strong>
                                    <a ng-click="enableEditor()" class="text-primary btn" style="font-size:12px">Edit</a>
                                </div>
                                <span class="d-block"><p>
                                    <b>State / Province / Region</b> {{ Auth::user()->state }}, <b> country </b>{{ Auth::user()->country }} <span> </span><span></span>
                                  </p></span>
                                 @if ($errors->has('state'))
                                <span class="d-block text-danger {{ $errors->has('state') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('state') }}
                                </span>
                                @endif
                                 @if ($errors->has('country'))
                                <span class="d-block text-danger {{ $errors->has('country') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('country') }}
                                </span>
                                @endif
                                <div ng-show="editorEnabled">
                                    <form class="needs-validation" name="createACCf01" method="POST" action="api/user/edit"> 
                                      @csrf
                                        <select class="gds-cr {{ $errors->has('country') ? ' is-invalid' : '' }}" id="country" name="country" country-data-region-id="gds-cr-two" country-data-default-value="US" ng-model="country" valve="{{ Auth::user()->country }}" required></select>
                                        <br>
                                        <select class="{{ $errors->has('state') ? ' is-invalid' : '' }}" id="gds-cr-two" region-data-language="en" name="state"  value="{{ Auth::user()->state }}" required></select>
                                        <button type="submit" class="btn bg-success font-weight-bold ml-2"><i class="fas fa-check text-light"></i></button>
                                        <button class="btn bg-danger font-weight-bold ml-2" ng-click="disableEditor()"><i class="fas fa-times text-light"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="media text-muted pt-3">
                            <img class="bd-placeholder-img mr-2 rounded" src="/img/key.svg" width="32" height="32" >
                            <div class="media-body pb-3 mb-0 small lh-125 border-bottom border-gray">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <strong class="text-gray-dark">Password</strong>
                                    <a ng-click="enableEditor()" class="text-primary btn" style="font-size:12px">Edit</a>
                                </div>
                                <span class="d-block">*****</span>
                                 @if ($errors->has('password'))
                                <span class="d-block text-danger {{ $errors->has('password') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('password') }}
                                </span>
                                @endif
                                 @if ($errors->has('password_confirmation'))
                                <span class="d-block text-danger {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}">
                                    {{ $errors->first('password_confirmation') }}
                                </span>
                                @endif
                                <div ng-show="editorEnabled">
                                    <form class="needs-validation" name="createACCf01" method="POST" action="api/user/edit"> 
                                      @csrf
                                        <input type="password" name="password" class="{{ $errors->has('password') ? ' is-invalid' : '' }}" ng-bind='title' value="">
                                        <br>
                                        <label for="password-confirm">Confirm Password</label>
                                        <br>
                                        <input type="password" class="{{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}" id="password_confirmation" name="password_confirmation" placeholder="re-enter password" required>
                                        <button type="submit" class="btn bg-success font-weight-bold ml-2"><i class="fas fa-check text-light"></i></button>
                                        <button class="btn bg-danger font-weight-bold ml-2" ng-click="disableEditor()"><i class="fas fa-times text-light"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <small class="text-right mt-3 d-none">
                          <a href="#">More</a>
                        </small>
                    </div>
                </div>  

                <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                    <div class="row m-4">
                        <div class="col-md-6">
                          <div class="card flex-md-row mb-4 shadow-sm h-md-250">
                            <svg class="bd-placeholder-img card-img-left flex-auto d-none d-lg-block" width="200" height="250" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid slice" focusable="false" role="img" aria-label="Placeholder: Thumbnail"><title>Placeholder</title><rect fill="#55595c" width="100%" height="100%"></rect><text fill="#eceeef" dy=".3em" x="50%" y="50%">Thumbnail</text></svg>
                            <div class="card-body d-flex flex-column align-items-start">
                              <strong class="d-inline-block mb-2 text-primary">World</strong>
                              <h3 class="mb-0">
                                <a class="text-dark" href="#">Featured post</a>
                              </h3>
                              <div class="mb-1 text-muted">Nov 12</div>
                              <p class="card-text mb-auto">This is a wider card with supporting text below as a natural lead-in to additional content.</p>
                              <a href="#">Continue reading</a>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-6">
                          <div class="card flex-md-row mb-4 shadow-sm h-md-250">
                            <div class="card-body d-flex flex-column align-items-start">
                              <strong class="d-inline-block mb-2 text-success">Design</strong>
                              <h3 class="mb-0">
                                <a class="text-dark" href="#">Post title</a>
                              </h3>
                              <div class="mb-1 text-muted">Nov 11</div>
                              <p class="card-text mb-auto">This is a wider card with supporting text below as a natural lead-in to additional content.</p>
                              <a href="#">Continue reading</a>
                            </div>
                            <svg class="bd-placeholder-img card-img-right flex-auto d-none d-lg-block" width="200" height="250" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid slice" focusable="false" role="img" aria-label="Placeholder: Thumbnail"><title>Placeholder</title><rect fill="#55595c" width="100%" height="100%"></rect><text fill="#eceeef" dy=".3em" x="50%" y="50%">Thumbnail</text></svg>
                          </div>
                        </div>
                      </div>
                </div>             
            </div>
        </div>
        <hr class="featurette-divider">
    </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  <div class="text-muted text-center">
    <small><em>Icons  from <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a> is licensed by <a href="http://creativecommons.org/licenses/by/3.0/" title="Creative Commons BY 3.0" target="_blank">CC 3.0 BY</a></em></small>
  </div>
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
    <!-- For country and state selector cass start-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/country-region-dropdown-menu/1.2.1/geodatasource-cr.min.js"></script>
    <!--cass end -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="/js/angular-contr.js"></script>
  @endsection
{{-- script end--}}

{{--Body  end--}}
