<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
  @include('users.inc.head')
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <div class="mask"></div>
      @include('users.inc.side_pop_up') 
    <!-- Navbar-->
    <header class="app-header">  
        <h4 class="header-title">
        <a  href="#" onclick="open_tab(event,'how_to_use_text')">How to use</a> | 
        <a  href="#" onclick="open_tab(event,'how_to_use_video')">Video</a></h4>    
        <!-- Sidebar toggle button-->
        <a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
            <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
      <!-- Navbar Right Menu-->
       @include('users.inc.nav_right_menu')
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
      @include('users.inc.app_side_bar')
    </aside>
    <main class="app-content">
        <div class="row" id="how_to_use_text" style="display: flex;">
            <div class="col-md-8">
              <div class="tile">
                <h4 class="tile-title">{{$gpage?$gpage->name:''}}</h4>
                <?=$gpage->how_to_use_text?>
              </div>
            </div>
            <div class="col-md-4">
            <?php $image = json_decode($gpage->image); ?>
              <div class="products-slider">
                  <div class="product">
                    <img src="{{asset($image[0]->url)}}" width="250px" height="200px" style="margin-left: -100px;" />
                </div>
              </div>
          </div>
        </div>
        <div class="row" id="how_to_use_video" style="display: none">
            <div class="col-md-8">
              <div class="tile">
              <?php $how_to_use_video = json_decode($gpage->how_to_use_video); ?>
                <h4 class="tile-title">{{$gpage?$gpage->name:''}}</h4>
                @if($how_to_use_video)
                    @foreach($how_to_use_video as $key=>$value)
                        <video width="320" height="240" controls>
                            <source src="{{asset($value->url)}}" type="video/mp4">
                            <source src="{{asset($value->url)}}" type="video/ogg">
                            Your browser does not support the video tag.
                        </video>
                    @endforeach
                @endif
              </div>
            </div>
            <div class="col-md-4">
            <?php $image = json_decode($gpage->image); ?>
              <div class="products-slider">
                  <div class="product">
                    <img src="{{asset($image[0]->url)}}" width="250px" height="200px" style="margin-left: -100px;" />
                </div>
              </div>
          </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <table>
                        <tr>
                            <td><i class="fa fa-thumbs-up"></i></td>
                            <td>
                                <p>1.5K</p>
                                <h4><a href="#">Vitalize</a></h4>
                            </td>
                            <td><i class="fa fa-thumbs-down"></i></td>
                            <td>
                                <p>1.5K</p>
                                <h4><a href="#">Vitalize</a></h4>
                            </td>
                            <td><i class="fa fa-plus"></i></td>
                            <td>
                                <p>1.3K</p>
                                <h4><a href="#">Add</a></h4>
                            </td>
                            <td><i class="fa fa-share-alt"></i></td>
                            <td>
                                <p>0</p>
                                <h4><a href="#">Share</a></h4>
                            </td>
                            <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                            <td>
                                <p>1.4K</p>
                                <h4><a href="#">Comments</a></h4>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3" class="text-center">
                                <h3>By User Aggto</h3>
                            </td>
                            <td colspan="4" class="text-center">
                                <h3>Last Updated May 1, 2018</h3>
                            </td>
                            <td colspan="3" class="text-center">
                                <h3>Last Updated May 1, 2018</h3>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </main>
    <!-- Essential javascripts for application to work-->
    @include('users.inc.footer_js_lib')
    <script type="text/javascript">
        function open_tab(event, id){
            if(id == 'how_to_use_text'){
                $("#"+id).css('display','flex');
                $("#how_to_use_video").css('display','none');
            }else if(id == 'how_to_use_video'){
                $("#"+id).css('display','flex');
                $("#how_to_use_text").css('display','none');
            }
        }
    </script>
  </body>
</html>