<?php
$dataFile = __DIR__ . '/data.json';

if (!file_exists($dataFile)) {
    file_put_contents($dataFile, json_encode([
        'redirect_url' => 'https://example.com',
        'clicks' => 0,
        'blocked_bots' => 0
    ], JSON_UNESCAPED_SLASHES));
}

$data = json_decode(file_get_contents($dataFile), true);

$message = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['redirect_url'])) {
    $url = trim($_POST['redirect_url']);
    if (filter_var($url, FILTER_VALIDATE_URL)) {
        $data['redirect_url'] = $url;
        file_put_contents($dataFile, json_encode($data, JSON_UNESCAPED_SLASHES));
        $message = 'Redirect URL updated.';
    } else {
        $message = 'URL tidak valid.';
    }
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Redirect Admin Panel</title>
    <style>
        body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;padding:24px;max-width:720px;margin:auto;line-height:1.5}
        h1{margin:0 0 16px}
        .card{border:1px solid #ddd;border-radius:10px;padding:16px;margin:16px 0;background:#fff}
        label{display:block;font-weight:600;margin:8px 0 4px}
        input[type="text"]{width:100%;padding:10px;border:1px solid #bbb;border-radius:8px}
        button{padding:10px 16px;border:0;border-radius:8px;cursor:pointer}
        .ok{color:#0a7a0a}
        .err{color:#b00020}
        .meta{color:#444}
        .grid{display:grid;grid-template-columns:1fr 1fr;gap:12px}
        .mono{font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace}
    </style>
</head>
<body>
    <h1>Redirect Admin Panel</h1>

    <?php if (!empty($message)): ?>
        <p class="ok"><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>

    <div class="card">
        <form method="POST">
            <label for="redirect_url">Redirect URL</label>
            <input id="redirect_url" type="text" name="redirect_url" value="<?= htmlspecialchars($data['redirect_url'] ?? '') ?>" placeholder="https://your-target.tld/path">
            <div style="margin-top:12px">
                <button type="submit">Simpan</button>
            </div>
        </form>
    </div>

    <div class="card grid">
        <div>
            <div class="meta">Total Clicks</div>
            <div class="mono" style="font-size:28px"><?= (int)($data['clicks'] ?? 0) ?></div>
        </div>
        <div>
            <div class="meta">Blocked Bots</div>
            <div class="mono" style="font-size:28px"><?= (int)($data['blocked_bots'] ?? 0) ?></div>
        </div>
    </div>

    <p class="meta">File data: <span class="mono"><?= htmlspecialchars($dataFile) ?></span></p>
</body>
</html>
