<?php
/**
 * Antibot.pw Blocker
 *
 * - Dipanggil dari index.php:
 *     $RedirectURL = $botRedirection;
 *     include_once __DIR__ . "/blocker.php";
 *
 * - Satu-satunya yang perlu kamu ubah di file ini: API key antibot.pw
 */

error_reporting(0);

// ================= CONFIG ================= //

$config_antibot = [
    // Ganti dengan API key dari dashboard antibot.pw
    'apikey' => '4fc000e74a8e9fce46292391af5e1e66',
];

// Kalau API key kosong, jangan blok apa-apa
if (empty($config_antibot['apikey'])) {
    return;
}

// pakai session biar nggak spam request ke API
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ================= CLASS ANTIBOT ================= //

class AntibotPw
{
    private $apiKey;

    public function __construct($apiKey)
    {
        $this->apiKey = $apiKey;
    }

    private function getClientIp()
    {
        // urutan cek IP, mirip contoh resmi
        $keys = [
            'HTTP_CLIENT_IP',
            'HTTP_X_FORWARDED_FOR',
            'HTTP_X_FORWARDED',
            'HTTP_FORWARDED_FOR',
            'HTTP_FORWARDED',
            'REMOTE_ADDR',
        ];

        $ip = '';
        foreach ($keys as $k) {
            if (!empty($_SERVER[$k])) {
                $ip = $_SERVER[$k];
                break;
            }
        }

        // kalau ada beberapa IP (proxy), ambil yang pertama
        $ipParts = explode(',', $ip);
        $ip = trim($ipParts[0]);

        // kalau localhost, ganti ke IP publik contoh supaya bisa dicek
        if ($ip === '127.0.0.1' || $ip === '::1') {
            $ip = '23.200.91.255'; // contoh IP yang juga dipakai di snippet resmi:contentReference[oaicite:1]{index=1}
        }

        return $ip;
    }

    private function httpGet($url)
    {
        // kalau nggak ada cURL, fallback ke file_get_contents
        if (!function_exists('curl_init')) {
            return @file_get_contents($url);
        }

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 30,
        ]);
        $resp = curl_exec($ch);
        curl_close($ch);

        return $resp;
    }

    public function isBot()
    {
        $ip = $this->getClientIp();

        // kalau nggak ada IP atau UA, besar kemungkinan bot → boleh kamu anggap bot
        if (!$ip || empty($_SERVER['HTTP_USER_AGENT'])) {
            return true;
        }

        // Endpoint resmi antibot blocker:
        // https://antibot.pw/api/v2-blockers?ip=...&apikey=...&ua={useragent} :contentReference[oaicite:2]{index=2}
        $endpoint = 'https://antibot.pw/api/v2-blockers';

        $query = http_build_query([
            'ip'     => $ip,
            'apikey' => $this->apiKey,
            'ua'     => $_SERVER['HTTP_USER_AGENT'],
        ]);

        $response = $this->httpGet($endpoint . '?' . $query);
        if ($response === false || $response === null || $response === '') {
            // kalau API error, fail-open (anggap bukan bot supaya nggak matiin trafik)
            return false;
        }

        $json = json_decode($response, true);
        if (!is_array($json)) {
            return false;
        }

        // Dari contoh resmi, bot ditandai dengan field is_bot = 1 / true:contentReference[oaicite:3]{index=3}
        return !empty($json['is_bot']);
    }
}

// ================= LOGIKA BLOKIR ================= //

// cek hanya sekali per session supaya nggak kebanyakan hit API
if (!isset($_SESSION['antibot_checked'])) {
    $_SESSION['antibot_checked'] = true;

    $antibot = new AntibotPw($config_antibot['apikey']);
    $isBot   = $antibot->isBot();

    if ($isBot) {
        $_SESSION['antibot_is_bot'] = true;
    }
}

// kalau terdeteksi bot
if (!empty($_SESSION['antibot_is_bot'])) {

    // ==== update statistik blocked_bots di data.json ====
    $dataFile = __DIR__ . '/data.json';
    if (is_file($dataFile) && is_readable($dataFile) && is_writable($dataFile)) {
        $stats = json_decode(file_get_contents($dataFile), true);
        if (!is_array($stats)) {
            $stats = [];
        }
        $stats['blocked_bots'] = isset($stats['blocked_bots'])
            ? (int)$stats['blocked_bots'] + 1
            : 1;

        file_put_contents($dataFile, json_encode($stats, JSON_UNESCAPED_SLASHES));
    }

    // $RedirectURL sudah dikirim dari index.php (misal ke Google / halaman lain)
    if (!empty($RedirectURL)) {
        header('Location: ' . $RedirectURL, true, 302);
        exit;
    }

    // kalau nggak ada RedirectURL, kirim 404
    http_response_code(404);
    exit('Not Found');
}

// bukan bot → lanjutkan eksekusi index.php
return;
