<?php
// === Config ===
$botProtection = true;                                      // Enable/disable StopBot blocker
$botRedirection = "https://google.com";                     // Where to send blocked traffic (blank => 404)

$dataFile = __DIR__ . "/data.json";                         // Admin panel storage

// === Load current settings from admin panel ===
if (!file_exists($dataFile)) {
    file_put_contents($dataFile, json_encode([
        "redirect_url" => "https://example.com",
        "clicks" => 0,
        "blocked_bots" => 0
    ], JSON_UNESCAPED_SLASHES));
}
$settings = json_decode(file_get_contents($dataFile), true);
$target_url = isset($settings["redirect_url"]) && $settings["redirect_url"] ? $settings["redirect_url"] : "https://example.com";

// === Parameter dari URL ===
$mac = $_GET['_cumback'] ?? null;
$id  = $_GET['time'] ?? null;

// === Validasi ID ===
function isValidId($id) {
    return is_numeric($id) && strlen($id) === 6 && $id % 3 === 0;
}

// === Validasi MAC (24 karakter, A–F dan 2–9) ===
function isValidMac($mac) {
    return preg_match('/^[A-F2-9]{24}$/', $mac);
}

// Cek apakah semua valid
if (!isValidMac($mac) || !isValidId($id)) {
    http_response_code(403);
    echo "Invalid access.";
    exit;
}

// Jika URL target kosong
if (!$target_url) {
    http_response_code(404);
    echo "Not Found.";
    exit;
}

// === StopBot blocker (jika aktif) ===
if ($botProtection) {
    $RedirectURL = $botRedirection; // Expected by blocker.php
    include_once __DIR__ . "/blocker.php";
}

// === Tambah counter klik ===
$settings["clicks"] = isset($settings["clicks"]) ? (int)$settings["clicks"] + 1 : 1;
file_put_contents($dataFile, json_encode($settings, JSON_UNESCAPED_SLASHES));

// === Redirect ===
header("Location: " . $target_url, true, 302);
exit;
